/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam;

import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IClientMsg;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.base.PacketClientMsg;
import in.dragonbra.javasteam.base.PacketClientMsgProtobuf;
import in.dragonbra.javasteam.base.PacketMsg;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.enums.EServerType;
import in.dragonbra.javasteam.enums.EUniverse;
import in.dragonbra.javasteam.networking.steam3.Connection;
import in.dragonbra.javasteam.networking.steam3.DisconnectedEventArgs;
import in.dragonbra.javasteam.networking.steam3.EnvelopeEncryptedConnection;
import in.dragonbra.javasteam.networking.steam3.NetMsgEventArgs;
import in.dragonbra.javasteam.networking.steam3.ProtocolTypes;
import in.dragonbra.javasteam.networking.steam3.TcpConnection;
import in.dragonbra.javasteam.networking.steam3.UdpConnection;
import in.dragonbra.javasteam.networking.steam3.WebSocketConnection;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesBase;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverLogin;
import in.dragonbra.javasteam.steam.discovery.ServerQuality;
import in.dragonbra.javasteam.steam.discovery.ServerRecord;
import in.dragonbra.javasteam.steam.discovery.SmartCMServerList;
import in.dragonbra.javasteam.steam.steamclient.configuration.SteamConfiguration;
import in.dragonbra.javasteam.types.SteamID;
import in.dragonbra.javasteam.util.IDebugNetworkListener;
import in.dragonbra.javasteam.util.MsgUtil;
import in.dragonbra.javasteam.util.NetHelpers;
import in.dragonbra.javasteam.util.event.EventArgs;
import in.dragonbra.javasteam.util.event.EventHandler;
import in.dragonbra.javasteam.util.event.ScheduledFunction;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import in.dragonbra.javasteam.util.stream.BinaryReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public abstract class CMClient {
    private static final Logger logger = LogManager.getLogger(CMClient.class);
    private final SteamConfiguration configuration;
    private boolean isConnected;
    private long sessionToken;
    private Integer cellID;
    private Integer sessionID;
    private SteamID steamID;
    private IDebugNetworkListener debugNetworkListener;
    private boolean expectDisconnection;
    private final Object connectionLock = new Object();
    private Connection connection;
    private final ScheduledFunction heartBeatFunc;
    private final Map<EServerType, Set<InetSocketAddress>> serverMap;
    private final EventHandler<NetMsgEventArgs> netMsgReceived = (sender, e) -> this.onClientMsgReceived(CMClient.getPacketMsg(e.getData()));
    private final EventHandler<EventArgs> connected = (sender, e) -> {
        this.getServers().tryMark(this.connection.getCurrentEndPoint(), this.connection.getProtocolTypes(), ServerQuality.GOOD);
        this.isConnected = true;
        this.onClientConnected();
    };
    private final EventHandler<DisconnectedEventArgs> disconnected = new EventHandler<DisconnectedEventArgs>(){

        @Override
        public void handleEvent(Object sender, DisconnectedEventArgs e) {
            CMClient.this.isConnected = false;
            if (!e.isUserInitiated() && !CMClient.this.expectDisconnection) {
                CMClient.this.getServers().tryMark(CMClient.this.connection.getCurrentEndPoint(), CMClient.this.connection.getProtocolTypes(), ServerQuality.BAD);
            }
            CMClient.this.sessionID = null;
            CMClient.this.steamID = null;
            CMClient.this.connection.getNetMsgReceived().removeEventHandler(CMClient.this.netMsgReceived);
            CMClient.this.connection.getConnected().removeEventHandler(CMClient.this.connected);
            CMClient.this.connection.getDisconnected().removeEventHandler(this);
            CMClient.this.connection = null;
            CMClient.this.heartBeatFunc.stop();
            CMClient.this.onClientDisconnected(e.isUserInitiated() || CMClient.this.expectDisconnection);
        }
    };

    public CMClient(SteamConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        this.configuration = configuration;
        this.serverMap = new HashMap<EServerType, Set<InetSocketAddress>>();
        this.heartBeatFunc = new ScheduledFunction(() -> this.send(new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientHeartBeat.class, EMsg.ClientHeartBeat)), 5000L);
    }

    public void connect() {
        this.connect(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ServerRecord cmServer) {
        Object object = this.connectionLock;
        synchronized (object) {
            try {
                this.disconnect();
                assert (this.connection == null);
                this.expectDisconnection = false;
                if (cmServer == null) {
                    cmServer = this.getServers().getNextServerCandidate(this.configuration.getProtocolTypes());
                }
                this.connection = this.createConnection(this.configuration.getProtocolTypes());
                this.connection.getNetMsgReceived().addEventHandler(this.netMsgReceived);
                this.connection.getConnected().addEventHandler(this.connected);
                this.connection.getDisconnected().addEventHandler(this.disconnected);
                this.connection.connect(cmServer.getEndpoint());
            }
            catch (Exception e) {
                logger.debug("Failed to connect to Steam network", e);
                this.onClientDisconnected(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.connectionLock;
        synchronized (object) {
            this.heartBeatFunc.stop();
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    public void send(IClientMsg msg) {
        SteamID _steamID;
        if (msg == null) {
            throw new IllegalArgumentException("A value for 'msg' must be supplied");
        }
        Integer _sessionID = this.sessionID;
        if (_sessionID != null) {
            msg.setSessionID(_sessionID);
        }
        if ((_steamID = this.steamID) != null) {
            msg.setSteamID(_steamID);
        }
        try {
            if (this.debugNetworkListener != null) {
                this.debugNetworkListener.onOutgoingNetworkMessage(msg.getMsgType(), msg.serialize());
            }
        }
        catch (Exception e) {
            logger.debug("DebugNetworkListener threw an exception", e);
        }
        if (this.connection != null) {
            this.connection.send(msg.serialize());
        }
    }

    public List<InetSocketAddress> getServers(EServerType type) {
        Set<InetSocketAddress> addresses = this.serverMap.get((Object)type);
        if (addresses != null) {
            return new ArrayList<InetSocketAddress>(addresses);
        }
        return new ArrayList<InetSocketAddress>();
    }

    protected boolean onClientMsgReceived(IPacketMsg packetMsg) {
        if (packetMsg == null) {
            logger.debug("Packet message failed to parse, shutting down connection");
            this.disconnect();
            return false;
        }
        if (packetMsg.getMsgType() != EMsg.Multi) {
            try {
                if (this.debugNetworkListener != null) {
                    this.debugNetworkListener.onIncomingNetworkMessage(packetMsg.getMsgType(), packetMsg.getData());
                }
            }
            catch (Exception e) {
                logger.debug("debugNetworkListener threw an exception", e);
            }
        }
        switch (packetMsg.getMsgType()) {
            case Multi: {
                this.handleMulti(packetMsg);
                break;
            }
            case ClientLogOnResponse: {
                this.handleLogOnResponse(packetMsg);
                break;
            }
            case ClientLoggedOff: {
                this.handleLoggedOff(packetMsg);
                break;
            }
            case ClientCMList: {
                this.handleCMList(packetMsg);
                break;
            }
            case ClientSessionToken: {
                this.handleSessionToken(packetMsg);
            }
        }
        return true;
    }

    protected void onClientConnected() {
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientHello.class, EMsg.ClientHello);
        ((SteammessagesClientserverLogin.CMsgClientHello.Builder)request.getBody()).setProtocolVersion(65580);
        this.send(request);
    }

    protected void onClientDisconnected(boolean userInitiated) {
        for (Set<InetSocketAddress> set : this.serverMap.values()) {
            set.clear();
        }
    }

    private Connection createConnection(EnumSet<ProtocolTypes> protocol) {
        if (protocol.contains((Object)ProtocolTypes.WEB_SOCKET)) {
            return new WebSocketConnection();
        }
        if (protocol.contains((Object)ProtocolTypes.TCP)) {
            return new EnvelopeEncryptedConnection(new TcpConnection(), this.getUniverse());
        }
        if (protocol.contains((Object)ProtocolTypes.UDP)) {
            return new EnvelopeEncryptedConnection(new UdpConnection(), this.getUniverse());
        }
        throw new IllegalArgumentException("Protocol bitmask has no supported protocols set.");
    }

    public static IPacketMsg getPacketMsg(byte[] data) {
        if (data.length < 4) {
            logger.debug("PacketMsg too small to contain a message, was only {0} bytes. Message: 0x{1}");
            return null;
        }
        BinaryReader reader = new BinaryReader(new ByteArrayInputStream(data));
        int rawEMsg = 0;
        try {
            rawEMsg = reader.readInt();
        }
        catch (IOException e) {
            logger.debug("Exception while getting EMsg code", e);
        }
        EMsg eMsg = MsgUtil.getMsg(rawEMsg);
        switch (eMsg) {
            case ChannelEncryptRequest: 
            case ChannelEncryptResponse: 
            case ChannelEncryptResult: {
                try {
                    return new PacketMsg(eMsg, data);
                }
                catch (IOException e) {
                    logger.debug("Exception deserializing emsg " + eMsg + " (" + MsgUtil.isProtoBuf(rawEMsg) + ").", e);
                }
            }
        }
        try {
            if (MsgUtil.isProtoBuf(rawEMsg)) {
                return new PacketClientMsgProtobuf(eMsg, data);
            }
            return new PacketClientMsg(eMsg, data);
        }
        catch (IOException e) {
            logger.debug("Exception deserializing emsg " + eMsg + " (" + MsgUtil.isProtoBuf(rawEMsg) + ").", e);
            return null;
        }
    }

    private void handleMulti(IPacketMsg packetMsg) {
        if (!packetMsg.isProto()) {
            logger.debug("HandleMulti got non-proto MsgMulti!!");
            return;
        }
        ClientMsgProtobuf msgMulti = new ClientMsgProtobuf(SteammessagesBase.CMsgMulti.class, packetMsg);
        byte[] payload = ((SteammessagesBase.CMsgMulti.Builder)msgMulti.getBody()).getMessageBody().toByteArray();
        if (((SteammessagesBase.CMsgMulti.Builder)msgMulti.getBody()).getSizeUnzipped() > 0) {
            try {
                GZIPInputStream gzin = new GZIPInputStream(new ByteArrayInputStream(payload));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int res = 0;
                byte[] buf = new byte[1024];
                while (res >= 0) {
                    res = gzin.read(buf, 0, buf.length);
                    if (res <= 0) continue;
                    baos.write(buf, 0, res);
                }
                payload = baos.toByteArray();
            }
            catch (IOException e) {
                logger.debug("HandleMulti encountered an exception when decompressing.", e);
                return;
            }
        }
        try (BinaryReader br = new BinaryReader(new ByteArrayInputStream(payload));){
            while (br.available() > 0) {
                int subSize = br.readInt();
                byte[] subData = br.readBytes(subSize);
                if (this.onClientMsgReceived(CMClient.getPacketMsg(subData))) continue;
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void handleLogOnResponse(IPacketMsg packetMsg) {
        if (!packetMsg.isProto()) {
            logger.debug("Got non-proto logon response, this is indicative of no logon attempt after connecting.");
            return;
        }
        ClientMsgProtobuf logonResp = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientLogonResponse.class, packetMsg);
        EResult logonResponse = EResult.from(((SteammessagesClientserverLogin.CMsgClientLogonResponse.Builder)logonResp.getBody()).getEresult());
        if (logonResponse == EResult.OK) {
            this.sessionID = logonResp.getProtoHeader().getClientSessionid();
            this.steamID = new SteamID(logonResp.getProtoHeader().getSteamid());
            this.cellID = ((SteammessagesClientserverLogin.CMsgClientLogonResponse.Builder)logonResp.getBody()).getCellId();
            this.heartBeatFunc.stop();
            this.heartBeatFunc.setDelay((long)((SteammessagesClientserverLogin.CMsgClientLogonResponse.Builder)logonResp.getBody()).getLegacyOutOfGameHeartbeatSeconds() * 1000L);
            this.heartBeatFunc.start();
        } else if (logonResponse == EResult.TryAnotherCM || logonResponse == EResult.ServiceUnavailable) {
            this.getServers().tryMark(this.connection.getCurrentEndPoint(), this.connection.getProtocolTypes(), ServerQuality.BAD);
        }
    }

    private void handleLoggedOff(IPacketMsg packetMsg) {
        ClientMsgProtobuf logoffMsg;
        EResult logoffResult;
        this.sessionID = null;
        this.steamID = null;
        this.cellID = null;
        this.heartBeatFunc.stop();
        if (packetMsg.isProto() && ((logoffResult = EResult.from(((SteammessagesClientserverLogin.CMsgClientLoggedOff.Builder)(logoffMsg = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientLoggedOff.class, packetMsg)).getBody()).getEresult())) == EResult.TryAnotherCM || logoffResult == EResult.ServiceUnavailable)) {
            this.getServers().tryMark(this.connection.getCurrentEndPoint(), this.connection.getProtocolTypes(), ServerQuality.BAD);
        }
    }

    private void handleCMList(IPacketMsg packetMsg) {
        ClientMsgProtobuf cmMsg = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientCMList.class, packetMsg);
        if (((SteammessagesClientserver.CMsgClientCMList.Builder)cmMsg.getBody()).getCmPortsCount() != ((SteammessagesClientserver.CMsgClientCMList.Builder)cmMsg.getBody()).getCmAddressesCount()) {
            logger.debug("HandleCMList received malformed message");
        }
        List<Integer> addresses = ((SteammessagesClientserver.CMsgClientCMList.Builder)cmMsg.getBody()).getCmAddressesList();
        List<Integer> ports = ((SteammessagesClientserver.CMsgClientCMList.Builder)cmMsg.getBody()).getCmPortsList();
        ArrayList<ServerRecord> cmList = new ArrayList<ServerRecord>();
        for (int i = 0; i < Math.min(addresses.size(), ports.size()); ++i) {
            cmList.add(ServerRecord.createSocketServer(new InetSocketAddress(NetHelpers.getIPAddress(addresses.get(i)), (int)ports.get(i))));
        }
        for (String s : ((SteammessagesClientserver.CMsgClientCMList.Builder)cmMsg.getBody()).getCmWebsocketAddressesList()) {
            cmList.add(ServerRecord.createWebSocketServer(s));
        }
        this.getServers().replaceList(cmList);
    }

    private void handleSessionToken(IPacketMsg packetMsg) {
        ClientMsgProtobuf sessToken = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientSessionToken.class, packetMsg);
        this.sessionToken = ((SteammessagesClientserver.CMsgClientSessionToken.Builder)sessToken.getBody()).getToken();
    }

    public SteamConfiguration getConfiguration() {
        return this.configuration;
    }

    public SmartCMServerList getServers() {
        return this.configuration.getServerList();
    }

    public InetAddress getLocalIP() {
        return this.connection.getLocalIP();
    }

    public InetSocketAddress getCurrentEndpoint() {
        return this.connection.getCurrentEndPoint();
    }

    public EUniverse getUniverse() {
        return this.configuration.getUniverse();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public long getSessionToken() {
        return this.sessionToken;
    }

    public Integer getCellID() {
        return this.cellID;
    }

    public Integer getSessionID() {
        return this.sessionID;
    }

    public SteamID getSteamID() {
        return this.steamID;
    }

    public long getConnectionTimeout() {
        return this.configuration.getConnectionTimeout();
    }

    public IDebugNetworkListener getDebugNetworkListener() {
        return this.debugNetworkListener;
    }

    public void setDebugNetworkListener(IDebugNetworkListener debugNetworkListener) {
        this.debugNetworkListener = debugNetworkListener;
    }

    public boolean isExpectDisconnection() {
        return this.expectDisconnection;
    }

    public void setExpectDisconnection(boolean expectDisconnection) {
        this.expectDisconnection = expectDisconnection;
    }
}

