/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.authentication;

import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient;
import in.dragonbra.javasteam.rpc.service.Authentication;
import in.dragonbra.javasteam.steam.authentication.AuthSession;
import in.dragonbra.javasteam.steam.authentication.AuthenticationException;
import in.dragonbra.javasteam.steam.authentication.IAuthenticator;
import in.dragonbra.javasteam.steam.authentication.SteamAuthentication;
import in.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse;
import in.dragonbra.javasteam.types.SteamID;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lin/dragonbra/javasteam/steam/authentication/CredentialsAuthSession;", "Lin/dragonbra/javasteam/steam/authentication/AuthSession;", "authentication", "Lin/dragonbra/javasteam/steam/authentication/SteamAuthentication;", "authenticator", "Lin/dragonbra/javasteam/steam/authentication/IAuthenticator;", "response", "Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesAuthSteamclient$CAuthentication_BeginAuthSessionViaCredentials_Response$Builder;", "<init>", "(Lin/dragonbra/javasteam/steam/authentication/SteamAuthentication;Lin/dragonbra/javasteam/steam/authentication/IAuthenticator;Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesAuthSteamclient$CAuthentication_BeginAuthSessionViaCredentials_Response$Builder;)V", "steamID", "Lin/dragonbra/javasteam/types/SteamID;", "sendSteamGuardCode", "", "code", "", "codeType", "Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesAuthSteamclient$EAuthSessionGuardType;", "javasteam"})
public final class CredentialsAuthSession
extends AuthSession {
    @NotNull
    private final SteamID steamID;

    public CredentialsAuthSession(@NotNull SteamAuthentication authentication, @Nullable IAuthenticator authenticator, @NotNull SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Response.Builder response) {
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        long l = response.getClientId();
        byte[] byArray = response.getRequestId().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        List<SteammessagesAuthSteamclient.CAuthentication_AllowedConfirmation> list = response.getAllowedConfirmationsList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllowedConfirmationsList(...)");
        super(authentication, authenticator, l, byArray, list, response.getInterval());
        this.steamID = new SteamID(response.getSteamid());
    }

    public final void sendSteamGuardCode(@Nullable String code, @Nullable SteammessagesAuthSteamclient.EAuthSessionGuardType codeType) throws AuthenticationException {
        SteammessagesAuthSteamclient.CAuthentication_UpdateAuthSessionWithSteamGuardCode_Request.Builder builder;
        SteammessagesAuthSteamclient.CAuthentication_UpdateAuthSessionWithSteamGuardCode_Request.Builder $this$sendSteamGuardCode_u24lambda_u240 = builder = SteammessagesAuthSteamclient.CAuthentication_UpdateAuthSessionWithSteamGuardCode_Request.newBuilder();
        boolean bl = false;
        $this$sendSteamGuardCode_u24lambda_u240.setClientId(this.getClientId());
        $this$sendSteamGuardCode_u24lambda_u240.setSteamid(this.steamID.convertToUInt64());
        $this$sendSteamGuardCode_u24lambda_u240.setCode(code);
        $this$sendSteamGuardCode_u24lambda_u240.setCodeType(codeType);
        SteammessagesAuthSteamclient.CAuthentication_UpdateAuthSessionWithSteamGuardCode_Request.Builder request = builder;
        Authentication authentication = this.getAuthentication().getAuthenticationService$javasteam();
        SteammessagesAuthSteamclient.CAuthentication_UpdateAuthSessionWithSteamGuardCode_Request cAuthentication_UpdateAuthSessionWithSteamGuardCode_Request = request.build();
        Intrinsics.checkNotNullExpressionValue((Object)cAuthentication_UpdateAuthSessionWithSteamGuardCode_Request, (String)"build(...)");
        ServiceMethodResponse message = authentication.updateAuthSessionWithSteamGuardCode(cAuthentication_UpdateAuthSessionWithSteamGuardCode_Request).runBlock();
        SteammessagesAuthSteamclient.CAuthentication_UpdateAuthSessionWithSteamGuardCode_Response.Builder response = (SteammessagesAuthSteamclient.CAuthentication_UpdateAuthSessionWithSteamGuardCode_Response.Builder)message.getDeserializedResponse(SteammessagesAuthSteamclient.CAuthentication_UpdateAuthSessionWithSteamGuardCode_Response.class);
        if (message.getResult() != EResult.OK && message.getResult() != EResult.DuplicateRequest) {
            throw new AuthenticationException("Failed to send steam guard code", message.getResult());
        }
    }
}

