/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.authentication;

import com.google.protobuf.GeneratedMessage;
import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.protobufs.steamclient.Enums;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient;
import in.dragonbra.javasteam.rpc.service.Authentication;
import in.dragonbra.javasteam.steam.authentication.AccessTokenGenerateResult;
import in.dragonbra.javasteam.steam.authentication.AuthSessionDetails;
import in.dragonbra.javasteam.steam.authentication.AuthenticationException;
import in.dragonbra.javasteam.steam.authentication.CredentialsAuthSession;
import in.dragonbra.javasteam.steam.authentication.QrAuthSession;
import in.dragonbra.javasteam.steam.handlers.steamunifiedmessages.SteamUnifiedMessages;
import in.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse;
import in.dragonbra.javasteam.steam.steamclient.SteamClient;
import in.dragonbra.javasteam.types.SteamID;
import in.dragonbra.javasteam.util.crypto.CryptoHelper;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.concurrent.CancellationException;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0007J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lin/dragonbra/javasteam/steam/authentication/SteamAuthentication;", "", "steamClient", "Lin/dragonbra/javasteam/steam/steamclient/SteamClient;", "<init>", "(Lin/dragonbra/javasteam/steam/steamclient/SteamClient;)V", "authenticationService", "Lin/dragonbra/javasteam/rpc/service/Authentication;", "getAuthenticationService$javasteam", "()Lin/dragonbra/javasteam/rpc/service/Authentication;", "getPasswordRSAPublicKey", "Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesAuthSteamclient$CAuthentication_GetPasswordRSAPublicKey_Response$Builder;", "accountName", "", "generateAccessTokenForApp", "Lin/dragonbra/javasteam/steam/authentication/AccessTokenGenerateResult;", "steamID", "Lin/dragonbra/javasteam/types/SteamID;", "refreshToken", "allowRenewal", "", "beginAuthSessionViaQR", "Lin/dragonbra/javasteam/steam/authentication/QrAuthSession;", "authSessionDetails", "Lin/dragonbra/javasteam/steam/authentication/AuthSessionDetails;", "beginAuthSessionViaCredentials", "Lin/dragonbra/javasteam/steam/authentication/CredentialsAuthSession;", "Companion", "javasteam"})
public final class SteamAuthentication {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SteamClient steamClient;
    @NotNull
    private final Authentication authenticationService;

    public SteamAuthentication(@NotNull SteamClient steamClient) {
        Intrinsics.checkNotNullParameter((Object)steamClient, (String)"steamClient");
        this.steamClient = steamClient;
        SteamUnifiedMessages steamUnifiedMessages = this.steamClient.getHandler(SteamUnifiedMessages.class);
        if (steamUnifiedMessages == null) {
            throw new NullPointerException("Unable to get SteamUnifiedMessages handler");
        }
        SteamUnifiedMessages unifiedMessages = steamUnifiedMessages;
        this.authenticationService = new Authentication(unifiedMessages);
    }

    @NotNull
    public final Authentication getAuthenticationService$javasteam() {
        return this.authenticationService;
    }

    private final SteammessagesAuthSteamclient.CAuthentication_GetPasswordRSAPublicKey_Response.Builder getPasswordRSAPublicKey(String accountName) throws AuthenticationException {
        SteammessagesAuthSteamclient.CAuthentication_GetPasswordRSAPublicKey_Request.Builder builder;
        SteammessagesAuthSteamclient.CAuthentication_GetPasswordRSAPublicKey_Request.Builder $this$getPasswordRSAPublicKey_u24lambda_u240 = builder = SteammessagesAuthSteamclient.CAuthentication_GetPasswordRSAPublicKey_Request.newBuilder();
        boolean bl = false;
        $this$getPasswordRSAPublicKey_u24lambda_u240.setAccountName(accountName);
        SteammessagesAuthSteamclient.CAuthentication_GetPasswordRSAPublicKey_Request.Builder request = builder;
        SteammessagesAuthSteamclient.CAuthentication_GetPasswordRSAPublicKey_Request cAuthentication_GetPasswordRSAPublicKey_Request = request.build();
        Intrinsics.checkNotNullExpressionValue((Object)cAuthentication_GetPasswordRSAPublicKey_Request, (String)"build(...)");
        ServiceMethodResponse message = this.authenticationService.getPasswordRSAPublicKey(cAuthentication_GetPasswordRSAPublicKey_Request).runBlock();
        if (message.getResult() != EResult.OK) {
            throw new AuthenticationException("Failed to get password public key", message.getResult());
        }
        return (SteammessagesAuthSteamclient.CAuthentication_GetPasswordRSAPublicKey_Response.Builder)message.getDeserializedResponse(SteammessagesAuthSteamclient.CAuthentication_GetPasswordRSAPublicKey_Response.class);
    }

    @JvmOverloads
    @NotNull
    public final AccessTokenGenerateResult generateAccessTokenForApp(@NotNull SteamID steamID, @NotNull String refreshToken, boolean allowRenewal) throws IllegalArgumentException, IllegalArgumentException {
        SteammessagesAuthSteamclient.CAuthentication_AccessToken_GenerateForApp_Request.Builder builder;
        Intrinsics.checkNotNullParameter((Object)steamID, (String)"steamID");
        Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
        SteammessagesAuthSteamclient.CAuthentication_AccessToken_GenerateForApp_Request.Builder $this$generateAccessTokenForApp_u24lambda_u241 = builder = SteammessagesAuthSteamclient.CAuthentication_AccessToken_GenerateForApp_Request.newBuilder();
        boolean bl = false;
        $this$generateAccessTokenForApp_u24lambda_u241.setRefreshToken(refreshToken);
        $this$generateAccessTokenForApp_u24lambda_u241.setSteamid(steamID.convertToUInt64());
        if (allowRenewal) {
            $this$generateAccessTokenForApp_u24lambda_u241.setRenewalType(SteammessagesAuthSteamclient.ETokenRenewalType.k_ETokenRenewalType_Allow);
        }
        SteammessagesAuthSteamclient.CAuthentication_AccessToken_GenerateForApp_Request.Builder request = builder;
        SteammessagesAuthSteamclient.CAuthentication_AccessToken_GenerateForApp_Request cAuthentication_AccessToken_GenerateForApp_Request = request.build();
        Intrinsics.checkNotNullExpressionValue((Object)cAuthentication_AccessToken_GenerateForApp_Request, (String)"build(...)");
        ServiceMethodResponse message = this.authenticationService.generateAccessTokenForApp(cAuthentication_AccessToken_GenerateForApp_Request).runBlock();
        if (message.getResult() != EResult.OK) {
            throw new IllegalArgumentException("Failed to generate token " + message.getResult());
        }
        SteammessagesAuthSteamclient.CAuthentication_AccessToken_GenerateForApp_Response.Builder response = (SteammessagesAuthSteamclient.CAuthentication_AccessToken_GenerateForApp_Response.Builder)message.getDeserializedResponse(SteammessagesAuthSteamclient.CAuthentication_AccessToken_GenerateForApp_Response.class);
        return new AccessTokenGenerateResult(response);
    }

    public static /* synthetic */ AccessTokenGenerateResult generateAccessTokenForApp$default(SteamAuthentication steamAuthentication, SteamID steamID, String string, boolean bl, int n, Object object) throws IllegalArgumentException, IllegalArgumentException {
        if ((n & 4) != 0) {
            bl = false;
        }
        return steamAuthentication.generateAccessTokenForApp(steamID, string, bl);
    }

    @NotNull
    public final QrAuthSession beginAuthSessionViaQR(@NotNull AuthSessionDetails authSessionDetails) throws AuthenticationException, CancellationException {
        Intrinsics.checkNotNullParameter((Object)authSessionDetails, (String)"authSessionDetails");
        if (!this.steamClient.isConnected()) {
            throw new IllegalArgumentException("The SteamClient instance must be connected.");
        }
        SteammessagesAuthSteamclient.CAuthentication_DeviceDetails.Builder builder = SteammessagesAuthSteamclient.CAuthentication_DeviceDetails.newBuilder();
        GeneratedMessage.Builder $this$beginAuthSessionViaQR_u24lambda_u242 = builder;
        boolean bl = false;
        $this$beginAuthSessionViaQR_u24lambda_u242.setDeviceFriendlyName(authSessionDetails.getDeviceFriendlyName());
        $this$beginAuthSessionViaQR_u24lambda_u242.setPlatformType(authSessionDetails.platformType);
        $this$beginAuthSessionViaQR_u24lambda_u242.setOsType(authSessionDetails.clientOSType.code());
        SteammessagesAuthSteamclient.CAuthentication_DeviceDetails.Builder deviceDetails = builder;
        GeneratedMessage.Builder $this$beginAuthSessionViaQR_u24lambda_u243 = $this$beginAuthSessionViaQR_u24lambda_u242 = SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaQR_Request.newBuilder();
        boolean bl2 = false;
        $this$beginAuthSessionViaQR_u24lambda_u243.setWebsiteId(authSessionDetails.websiteID);
        $this$beginAuthSessionViaQR_u24lambda_u243.setDeviceDetails(deviceDetails.build());
        GeneratedMessage.Builder request = $this$beginAuthSessionViaQR_u24lambda_u242;
        SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaQR_Request cAuthentication_BeginAuthSessionViaQR_Request = request.build();
        Intrinsics.checkNotNullExpressionValue((Object)cAuthentication_BeginAuthSessionViaQR_Request, (String)"build(...)");
        ServiceMethodResponse message = this.authenticationService.beginAuthSessionViaQR(cAuthentication_BeginAuthSessionViaQR_Request).runBlock();
        if (message.getResult() != EResult.OK) {
            throw new AuthenticationException("Failed to begin QR auth session", message.getResult());
        }
        SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaQR_Response.Builder response = (SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaQR_Response.Builder)message.getDeserializedResponse(SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaQR_Response.class);
        return new QrAuthSession(this, authSessionDetails.authenticator, response);
    }

    @NotNull
    public final CredentialsAuthSession beginAuthSessionViaCredentials(@Nullable AuthSessionDetails authSessionDetails) throws AuthenticationException {
        byte[] byArray;
        Object object;
        if (authSessionDetails == null) {
            throw new IllegalArgumentException("authSessionDetails is null");
        }
        CharSequence charSequence = authSessionDetails.username;
        if (charSequence == null || charSequence.length() == 0 || (charSequence = (CharSequence)authSessionDetails.password) == null || charSequence.length() == 0) {
            throw new IllegalArgumentException("BeginAuthSessionViaCredentials requires a username and password to be set in authSessionDetails.");
        }
        if (!this.steamClient.isConnected()) {
            throw new IllegalArgumentException("The SteamClient instance must be connected.");
        }
        SteammessagesAuthSteamclient.CAuthentication_GetPasswordRSAPublicKey_Response.Builder passwordRSAPublicKey = this.getPasswordRSAPublicKey(authSessionDetails.username);
        BigInteger publicModulus = new BigInteger(passwordRSAPublicKey.getPublickeyMod(), 16);
        BigInteger publicExponent = new BigInteger(passwordRSAPublicKey.getPublickeyExp(), 16);
        RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(publicModulus, publicExponent);
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(rsaPublicKeySpec);
        Cipher cipher = Cipher.getInstance("RSA/None/PKCS1Padding", CryptoHelper.SEC_PROV);
        Object $this$beginAuthSessionViaCredentials_u24lambda_u244 = cipher;
        boolean bl = false;
        ((Cipher)$this$beginAuthSessionViaCredentials_u24lambda_u244).init(1, publicKey);
        Cipher cipher2 = cipher;
        Base64.Encoder encoder = Base64.getEncoder();
        String string = authSessionDetails.password;
        if (string != null) {
            object = string;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray2 = ((String)object).getBytes(charset);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        } else {
            byArray = null;
        }
        $this$beginAuthSessionViaCredentials_u24lambda_u244 = encoder.encodeToString(cipher2.doFinal(byArray));
        Intrinsics.checkNotNullExpressionValue((Object)$this$beginAuthSessionViaCredentials_u24lambda_u244, (String)"encodeToString(...)");
        String encryptedPassword = StringsKt.dropLast((String)$this$beginAuthSessionViaCredentials_u24lambda_u244, (int)1);
        Enums.ESessionPersistence persistentSession = authSessionDetails.persistentSession ? Enums.ESessionPersistence.k_ESessionPersistence_Persistent : Enums.ESessionPersistence.k_ESessionPersistence_Ephemeral;
        Object $this$beginAuthSessionViaCredentials_u24lambda_u245 = object = SteammessagesAuthSteamclient.CAuthentication_DeviceDetails.newBuilder();
        boolean bl2 = false;
        ((SteammessagesAuthSteamclient.CAuthentication_DeviceDetails.Builder)$this$beginAuthSessionViaCredentials_u24lambda_u245).setDeviceFriendlyName(authSessionDetails.getDeviceFriendlyName());
        ((SteammessagesAuthSteamclient.CAuthentication_DeviceDetails.Builder)$this$beginAuthSessionViaCredentials_u24lambda_u245).setOsType(authSessionDetails.clientOSType.code());
        ((SteammessagesAuthSteamclient.CAuthentication_DeviceDetails.Builder)$this$beginAuthSessionViaCredentials_u24lambda_u245).setPlatformType(authSessionDetails.platformType);
        Object deviceDetails = object;
        Object $this$beginAuthSessionViaCredentials_u24lambda_u246 = $this$beginAuthSessionViaCredentials_u24lambda_u245 = SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Request.newBuilder();
        boolean bl3 = false;
        ((SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Request.Builder)$this$beginAuthSessionViaCredentials_u24lambda_u246).setAccountName(authSessionDetails.username);
        ((SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Request.Builder)$this$beginAuthSessionViaCredentials_u24lambda_u246).setDeviceDetails(((SteammessagesAuthSteamclient.CAuthentication_DeviceDetails.Builder)deviceDetails).build());
        ((SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Request.Builder)$this$beginAuthSessionViaCredentials_u24lambda_u246).setEncryptedPassword(encryptedPassword);
        ((SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Request.Builder)$this$beginAuthSessionViaCredentials_u24lambda_u246).setEncryptionTimestamp(passwordRSAPublicKey.getTimestamp());
        ((SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Request.Builder)$this$beginAuthSessionViaCredentials_u24lambda_u246).setPersistence(persistentSession);
        ((SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Request.Builder)$this$beginAuthSessionViaCredentials_u24lambda_u246).setWebsiteId(authSessionDetails.websiteID);
        Object request = $this$beginAuthSessionViaCredentials_u24lambda_u245;
        $this$beginAuthSessionViaCredentials_u24lambda_u245 = authSessionDetails.guardData;
        if (!($this$beginAuthSessionViaCredentials_u24lambda_u245 == null || $this$beginAuthSessionViaCredentials_u24lambda_u245.length() == 0)) {
            ((SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Request.Builder)request).setGuardData(authSessionDetails.guardData);
        }
        SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Request cAuthentication_BeginAuthSessionViaCredentials_Request = ((SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Request.Builder)request).build();
        Intrinsics.checkNotNullExpressionValue((Object)cAuthentication_BeginAuthSessionViaCredentials_Request, (String)"build(...)");
        ServiceMethodResponse message = this.authenticationService.beginAuthSessionViaCredentials(cAuthentication_BeginAuthSessionViaCredentials_Request).runBlock();
        if (message.getResult() != EResult.OK) {
            throw new AuthenticationException("Authentication failed", message.getResult());
        }
        SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Response.Builder response = (SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Response.Builder)message.getDeserializedResponse(SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Response.class);
        return new CredentialsAuthSession(this, authSessionDetails.authenticator, response);
    }

    @JvmOverloads
    @NotNull
    public final AccessTokenGenerateResult generateAccessTokenForApp(@NotNull SteamID steamID, @NotNull String refreshToken) throws IllegalArgumentException, IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)steamID, (String)"steamID");
        Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
        return SteamAuthentication.generateAccessTokenForApp$default(this, steamID, refreshToken, false, 4, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lin/dragonbra/javasteam/steam/authentication/SteamAuthentication$Companion;", "", "<init>", "()V", "javasteam"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

