/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.discovery;

import in.dragonbra.javasteam.networking.steam3.ProtocolTypes;
import in.dragonbra.javasteam.protobufs.steam.discovery.BasicServerListProtos;
import in.dragonbra.javasteam.steam.discovery.IServerListProvider;
import in.dragonbra.javasteam.steam.discovery.ServerRecord;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FileServerListProvider
implements IServerListProvider {
    private static final Logger logger = LogManager.getLogger(FileServerListProvider.class);
    private final File file;

    public FileServerListProvider(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        this.file = file;
        try {
            if (!file.exists()) {
                file.getAbsoluteFile().getParentFile().mkdirs();
                file.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<ServerRecord> fetchServerList() {
        block9: {
            ArrayList<ServerRecord> arrayList;
            FileInputStream fis = new FileInputStream(this.file);
            try {
                ArrayList<ServerRecord> records = new ArrayList<ServerRecord>();
                BasicServerListProtos.BasicServerList serverList = BasicServerListProtos.BasicServerList.parseFrom(fis);
                for (int i = 0; i < serverList.getServersCount(); ++i) {
                    BasicServerListProtos.BasicServer server = serverList.getServers(i);
                    records.add(ServerRecord.createServer(server.getAddress(), server.getPort(), ProtocolTypes.from(server.getProtocol())));
                }
                fis.close();
                arrayList = records;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    logger.debug("servers list file not found");
                    break block9;
                }
                catch (IOException e) {
                    logger.debug("Failed to read server list file " + this.file.getAbsolutePath());
                }
            }
            fis.close();
            return arrayList;
        }
        return null;
    }

    @Override
    public void updateServerList(List<ServerRecord> endpoints) {
        BasicServerListProtos.BasicServerList.Builder builder = BasicServerListProtos.BasicServerList.newBuilder();
        for (ServerRecord endpoint : endpoints) {
            builder.addServers(BasicServerListProtos.BasicServer.newBuilder().setAddress(endpoint.getHost()).setPort(endpoint.getPort()).setProtocol(ProtocolTypes.code(endpoint.getProtocolTypes())));
        }
        try (FileOutputStream fos = new FileOutputStream(this.file, false);){
            builder.build().writeTo(fos);
            fos.flush();
        }
        catch (IOException e) {
            logger.debug("Failed to write servers to file " + this.file.getAbsolutePath(), e);
        }
    }
}

