/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamapps.callback;

import in.dragonbra.javasteam.base.ClientMsg;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.generated.MsgClientUpdateGuestPassesList;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.KeyValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamapps/callback/GuestPassListCallback;", "Lin/dragonbra/javasteam/steam/steamclient/callbackmgr/CallbackMsg;", "packetMsg", "Lin/dragonbra/javasteam/base/IPacketMsg;", "<init>", "(Lin/dragonbra/javasteam/base/IPacketMsg;)V", "result", "Lin/dragonbra/javasteam/enums/EResult;", "getResult", "()Lin/dragonbra/javasteam/enums/EResult;", "countGuestPassesToGive", "", "getCountGuestPassesToGive", "()I", "countGuestPassesToRedeem", "getCountGuestPassesToRedeem", "guestPasses", "", "Lin/dragonbra/javasteam/types/KeyValue;", "getGuestPasses", "()Ljava/util/List;", "javasteam"})
public final class GuestPassListCallback
extends CallbackMsg {
    @NotNull
    private final EResult result;
    private final int countGuestPassesToGive;
    private final int countGuestPassesToRedeem;
    @NotNull
    private final List<KeyValue> guestPasses;

    public GuestPassListCallback(@NotNull IPacketMsg packetMsg) {
        Intrinsics.checkNotNullParameter((Object)packetMsg, (String)"packetMsg");
        ClientMsg<MsgClientUpdateGuestPassesList> guestPassesResp = new ClientMsg<MsgClientUpdateGuestPassesList>(MsgClientUpdateGuestPassesList.class, packetMsg);
        MsgClientUpdateGuestPassesList msg = guestPassesResp.getBody();
        this.result = msg.getResult();
        this.countGuestPassesToGive = msg.getCountGuestPassesToGive();
        this.countGuestPassesToRedeem = msg.getCountGuestPassesToRedeem();
        List tempList = new ArrayList();
        try {
            int n = this.countGuestPassesToGive + this.countGuestPassesToRedeem;
            for (int i = 0; i < n; ++i) {
                KeyValue kv = new KeyValue();
                kv.tryReadAsBinary(guestPassesResp.getPayload());
                tempList.add(kv);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("failed to read guest passes", e);
        }
        this.guestPasses = CollectionsKt.toList((Iterable)tempList);
    }

    @NotNull
    public final EResult getResult() {
        return this.result;
    }

    public final int getCountGuestPassesToGive() {
        return this.countGuestPassesToGive;
    }

    public final int getCountGuestPassesToRedeem() {
        return this.countGuestPassesToRedeem;
    }

    @NotNull
    public final List<KeyValue> getGuestPasses() {
        return this.guestPasses;
    }
}

