/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamgameserver;

import com.google.protobuf.ByteString;
import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EAccountType;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.enums.EServerFlags;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverGameservers;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverLogin;
import in.dragonbra.javasteam.steam.handlers.ClientMsgHandler;
import in.dragonbra.javasteam.steam.handlers.steamgameserver.LogOnDetails;
import in.dragonbra.javasteam.steam.handlers.steamgameserver.StatusDetails;
import in.dragonbra.javasteam.steam.handlers.steamgameserver.callback.StatusReplyCallback;
import in.dragonbra.javasteam.steam.handlers.steamgameserver.callback.TicketAuthCallback;
import in.dragonbra.javasteam.steam.handlers.steamuser.callback.LoggedOnCallback;
import in.dragonbra.javasteam.steam.steamclient.SteamClient;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.SteamID;
import in.dragonbra.javasteam.util.HardwareUtils;
import in.dragonbra.javasteam.util.NetHelpers;
import in.dragonbra.javasteam.util.Utils;
import java.net.Inet6Address;
import java.net.InetAddress;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamgameserver/SteamGameServer;", "Lin/dragonbra/javasteam/steam/handlers/ClientMsgHandler;", "<init>", "()V", "logOn", "", "details", "Lin/dragonbra/javasteam/steam/handlers/steamgameserver/LogOnDetails;", "logOnAnonymous", "appId", "", "logOff", "sendStatus", "Lin/dragonbra/javasteam/steam/handlers/steamgameserver/StatusDetails;", "handleMsg", "packetMsg", "Lin/dragonbra/javasteam/base/IPacketMsg;", "Companion", "javasteam"})
@SourceDebugExtension(value={"SMAP\nSteamGameServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SteamGameServer.kt\nin/dragonbra/javasteam/steam/handlers/steamgameserver/SteamGameServer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1#2:158\n*E\n"})
public final class SteamGameServer
extends ClientMsgHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void logOn(@NotNull LogOnDetails details) {
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        Object object = details.getToken();
        if (!(!(object == null || object.length() == 0))) {
            boolean $i$a$-require-SteamGameServer$logOn$22 = false;
            String $i$a$-require-SteamGameServer$logOn$22 = "LogOn requires a game server token to be set in 'details'.";
            throw new IllegalArgumentException($i$a$-require-SteamGameServer$logOn$22.toString());
        }
        if (!this.getClient().isConnected()) {
            object = new LoggedOnCallback(EResult.NoConnection);
            SteamClient $i$a$-require-SteamGameServer$logOn$22 = this.getClient();
            CallbackMsg p0 = (CallbackMsg)object;
            boolean $i$f$logOn$stub_for_inlining = false;
            boolean bl = false;
            $i$a$-require-SteamGameServer$logOn$22.postCallback(p0);
            return;
        }
        ClientMsgProtobuf logon = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientLogon.class, EMsg.ClientLogonGameServer);
        SteamID gsId = new SteamID(0L, 0L, this.getClient().getUniverse(), EAccountType.GameServer);
        logon.getProtoHeader().setClientSessionid(0);
        logon.getProtoHeader().setSteamid(gsId.convertToUInt64());
        int localIp = NetHelpers.getIPAddress(this.getClient().getLocalIP());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setDeprecatedObfustucatedPrivateIp(localIp ^ 0xBAADF00D);
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setProtocolVersion(65580);
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setClientOsType(Utils.getOSType().code());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setGameServerAppId(details.getAppID());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setMachineId(ByteString.copyFrom((byte[])HardwareUtils.getMachineID()));
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setGameServerToken(details.getToken());
        this.getClient().send(logon);
    }

    @JvmOverloads
    public final void logOnAnonymous(int appId) {
        if (!this.getClient().isConnected()) {
            this.getClient().postCallback(new LoggedOnCallback(EResult.NoConnection));
            return;
        }
        ClientMsgProtobuf logon = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientLogon.class, EMsg.ClientLogonGameServer);
        SteamID gsId = new SteamID(0L, 0L, this.getClient().getUniverse(), EAccountType.AnonGameServer);
        logon.getProtoHeader().setClientSessionid(0);
        logon.getProtoHeader().setSteamid(gsId.convertToUInt64());
        int localIp = NetHelpers.getIPAddress(this.getClient().getLocalIP());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setDeprecatedObfustucatedPrivateIp(localIp ^ 0xBAADF00D);
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setProtocolVersion(65580);
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setClientOsType(Utils.getOSType().code());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setGameServerAppId(appId);
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setMachineId(ByteString.copyFrom((byte[])HardwareUtils.getMachineID()));
        this.getClient().send(logon);
    }

    public static /* synthetic */ void logOnAnonymous$default(SteamGameServer steamGameServer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        steamGameServer.logOnAnonymous(n);
    }

    public final void logOff() {
        this.setExpectDisconnection(true);
        ClientMsgProtobuf logOff = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientLogOff.class, EMsg.ClientLogOff);
        this.getClient().send(logOff);
        this.getClient().disconnect();
    }

    public final void sendStatus(@NotNull StatusDetails details) {
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        if (!(details.getAddress() == null || !(details.getAddress() instanceof Inet6Address))) {
            boolean bl = false;
            String string = "Only IPv4 addresses are supported.";
            throw new IllegalArgumentException(string.toString());
        }
        ClientMsgProtobuf status = new ClientMsgProtobuf(SteammessagesClientserverGameservers.CMsgGSServerType.class, EMsg.GSServerType);
        ((SteammessagesClientserverGameservers.CMsgGSServerType.Builder)status.getBody()).setAppIdServed(details.getAppID());
        ((SteammessagesClientserverGameservers.CMsgGSServerType.Builder)status.getBody()).setFlags(EServerFlags.code(details.getServerFlags()));
        ((SteammessagesClientserverGameservers.CMsgGSServerType.Builder)status.getBody()).setGameDir(details.getGameDirectory());
        ((SteammessagesClientserverGameservers.CMsgGSServerType.Builder)status.getBody()).setGamePort(details.getPort());
        ((SteammessagesClientserverGameservers.CMsgGSServerType.Builder)status.getBody()).setGameQueryPort(details.getQueryPort());
        ((SteammessagesClientserverGameservers.CMsgGSServerType.Builder)status.getBody()).setGameVersion(details.getVersion());
        InetAddress inetAddress = details.getAddress();
        if (inetAddress != null) {
            InetAddress it = inetAddress;
            boolean bl = false;
            ((SteammessagesClientserverGameservers.CMsgGSServerType.Builder)status.getBody()).setDeprecatedGameIpAddress(NetHelpers.getIPAddress(it));
        }
        this.getClient().send(status);
    }

    @Override
    public void handleMsg(@NotNull IPacketMsg packetMsg) {
        Intrinsics.checkNotNullParameter((Object)packetMsg, (String)"packetMsg");
        CallbackMsg callbackMsg = SteamGameServer.Companion.getCallback(packetMsg);
        if (callbackMsg == null) {
            return;
        }
        CallbackMsg callback = callbackMsg;
        this.getClient().postCallback(callback);
    }

    @JvmOverloads
    public final void logOnAnonymous() {
        SteamGameServer.logOnAnonymous$default(this, 0, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamgameserver/SteamGameServer$Companion;", "", "<init>", "()V", "getCallback", "Lin/dragonbra/javasteam/steam/steamclient/callbackmgr/CallbackMsg;", "packetMsg", "Lin/dragonbra/javasteam/base/IPacketMsg;", "javasteam"})
    public static final class Companion {
        private Companion() {
        }

        private final CallbackMsg getCallback(IPacketMsg packetMsg) {
            CallbackMsg callbackMsg;
            EMsg eMsg = packetMsg.getMsgType();
            switch (eMsg == null ? -1 : WhenMappings.$EnumSwitchMapping$0[eMsg.ordinal()]) {
                case 1: {
                    callbackMsg = new StatusReplyCallback(packetMsg);
                    break;
                }
                case 2: {
                    callbackMsg = new TicketAuthCallback(packetMsg);
                    break;
                }
                default: {
                    callbackMsg = null;
                }
            }
            return callbackMsg;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[EMsg.values().length];
                try {
                    nArray[EMsg.GSStatusReply.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EMsg.ClientTicketAuthComplete.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

