/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamnetworking;

import com.google.protobuf.ByteString;
import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver;
import in.dragonbra.javasteam.steam.handlers.ClientMsgHandler;
import in.dragonbra.javasteam.steam.handlers.steamnetworking.callback.NetworkingCertificateCallback;
import in.dragonbra.javasteam.steam.steamclient.SteamClient;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.AsyncJobSingle;
import in.dragonbra.javasteam.types.JobID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamnetworking/SteamNetworking;", "Lin/dragonbra/javasteam/steam/handlers/ClientMsgHandler;", "<init>", "()V", "requestNetworkingCertificate", "Lin/dragonbra/javasteam/types/AsyncJobSingle;", "Lin/dragonbra/javasteam/steam/handlers/steamnetworking/callback/NetworkingCertificateCallback;", "appId", "", "publicKey", "", "handleMsg", "", "packetMsg", "Lin/dragonbra/javasteam/base/IPacketMsg;", "Companion", "javasteam"})
public final class SteamNetworking
extends ClientMsgHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final AsyncJobSingle<NetworkingCertificateCallback> requestNetworkingCertificate(int appId, @NotNull byte[] publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        ClientMsgProtobuf msg = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientNetworkingCertRequest.class, EMsg.ClientNetworkingCertRequest);
        msg.setSourceJobID(this.getClient().getNextJobID());
        ((SteammessagesClientserver.CMsgClientNetworkingCertRequest.Builder)msg.getBody()).setAppId(appId);
        ((SteammessagesClientserver.CMsgClientNetworkingCertRequest.Builder)msg.getBody()).setKeyData(ByteString.copyFrom((byte[])publicKey));
        this.getClient().send(msg);
        SteamClient steamClient = this.getClient();
        JobID jobID = msg.getSourceJobID();
        Intrinsics.checkNotNullExpressionValue((Object)jobID, (String)"getSourceJobID(...)");
        return new AsyncJobSingle<NetworkingCertificateCallback>(steamClient, jobID);
    }

    @Override
    public void handleMsg(@NotNull IPacketMsg packetMsg) {
        Intrinsics.checkNotNullParameter((Object)packetMsg, (String)"packetMsg");
        CallbackMsg callbackMsg = SteamNetworking.Companion.getCallback(packetMsg);
        if (callbackMsg == null) {
            return;
        }
        CallbackMsg callback = callbackMsg;
        this.getClient().postCallback(callback);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamnetworking/SteamNetworking$Companion;", "", "<init>", "()V", "getCallback", "Lin/dragonbra/javasteam/steam/steamclient/callbackmgr/CallbackMsg;", "packetMsg", "Lin/dragonbra/javasteam/base/IPacketMsg;", "javasteam"})
    public static final class Companion {
        private Companion() {
        }

        private final CallbackMsg getCallback(IPacketMsg packetMsg) {
            EMsg eMsg = packetMsg.getMsgType();
            return (eMsg == null ? -1 : WhenMappings.$EnumSwitchMapping$0[eMsg.ordinal()]) == 1 ? (CallbackMsg)new NetworkingCertificateCallback(packetMsg) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[EMsg.values().length];
                try {
                    nArray[EMsg.ClientNetworkingCertRequestResponse.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

