/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamunifiedmessages;

import com.google.protobuf.GeneratedMessage;
import in.dragonbra.javasteam.steam.handlers.steamunifiedmessages.SteamUnifiedMessages;
import in.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse;
import in.dragonbra.javasteam.types.AsyncJobSingle;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007J(\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamunifiedmessages/UnifiedService;", "", "steamUnifiedMessages", "Lin/dragonbra/javasteam/steam/handlers/steamunifiedmessages/SteamUnifiedMessages;", "<init>", "(Lin/dragonbra/javasteam/steam/handlers/steamunifiedmessages/SteamUnifiedMessages;)V", "className", "", "getClassName", "()Ljava/lang/String;", "sendMessage", "Lin/dragonbra/javasteam/types/AsyncJobSingle;", "Lin/dragonbra/javasteam/steam/handlers/steamunifiedmessages/callback/ServiceMethodResponse;", "message", "Lcom/google/protobuf/GeneratedMessage;", "methodName", "sendNotification", "", "sendMessageOrNotification", "rpcName", "isNotification", "", "Companion", "javasteam"})
public abstract class UnifiedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SteamUnifiedMessages steamUnifiedMessages;

    public UnifiedService(@NotNull SteamUnifiedMessages steamUnifiedMessages) {
        Intrinsics.checkNotNullParameter((Object)steamUnifiedMessages, (String)"steamUnifiedMessages");
        this.steamUnifiedMessages = steamUnifiedMessages;
    }

    private final String getClassName() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return string;
    }

    @NotNull
    public final AsyncJobSingle<ServiceMethodResponse> sendMessage(@NotNull GeneratedMessage message, @NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        String rpcEndpoint = UnifiedService.Companion.getRpcEndpoint(this.getClassName(), methodName);
        AsyncJobSingle<ServiceMethodResponse> asyncJobSingle = this.sendMessageOrNotification(rpcEndpoint, message, false);
        Intrinsics.checkNotNull(asyncJobSingle);
        return asyncJobSingle;
    }

    public final void sendNotification(@NotNull GeneratedMessage message, @NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        String rpcEndpoint = UnifiedService.Companion.getRpcEndpoint(this.getClassName(), methodName);
        this.sendMessageOrNotification(rpcEndpoint, message, true);
    }

    private final AsyncJobSingle<ServiceMethodResponse> sendMessageOrNotification(String rpcName, GeneratedMessage message, boolean isNotification) {
        if (isNotification) {
            this.steamUnifiedMessages.sendNotification(rpcName, message);
            return null;
        }
        return this.steamUnifiedMessages.sendMessage(rpcName, message);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0002\u00a8\u0006\b"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamunifiedmessages/UnifiedService$Companion;", "", "<init>", "()V", "getRpcEndpoint", "", "parentClassName", "methodName", "javasteam"})
    public static final class Companion {
        private Companion() {
        }

        private final String getRpcEndpoint(String parentClassName, String methodName) {
            String string = "%s.%s#%s";
            Object[] objectArray = new Object[]{parentClassName, methodName, 1};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

