/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamuser.callback;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import in.dragonbra.javasteam.base.ClientMsg;
import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EAccountFlags;
import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.generated.MsgClientLogOnResponse;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverLogin;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.SteamID;
import in.dragonbra.javasteam.util.NetHelpers;
import java.net.InetAddress;
import java.util.Date;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0010\u0010D\u001a\u00020E2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000b\"\u0004\b\u000e\u0010\bR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\"\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\t\u001a\u0004\u0018\u00010\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\"\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010\t\u001a\u0004\u0018\u00010\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\"\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\"\u0010+\u001a\u0004\u0018\u00010*2\b\u0010\t\u001a\u0004\u0018\u00010*@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001e\u0010.\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0012R\u001e\u00100\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u0012R\"\u00103\u001a\u0004\u0018\u0001022\b\u0010\t\u001a\u0004\u0018\u000102@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\"\u00106\u001a\u0004\u0018\u00010*2\b\u0010\t\u001a\u0004\u0018\u00010*@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010-R\"\u00108\u001a\u0004\u0018\u00010*2\b\u0010\t\u001a\u0004\u0018\u00010*@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010-R\u001e\u0010:\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u0012R\u001e\u0010<\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\u0012R\u001c\u0010>\u001a\u0004\u0018\u00010?X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010C\u00a8\u0006F"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamuser/callback/LoggedOnCallback;", "Lin/dragonbra/javasteam/steam/steamclient/callbackmgr/CallbackMsg;", "packetMsg", "Lin/dragonbra/javasteam/base/IPacketMsg;", "<init>", "(Lin/dragonbra/javasteam/base/IPacketMsg;)V", "result", "Lin/dragonbra/javasteam/enums/EResult;", "(Lin/dragonbra/javasteam/enums/EResult;)V", "value", "getResult", "()Lin/dragonbra/javasteam/enums/EResult;", "extendedResult", "getExtendedResult", "setExtendedResult", "", "outOfGameSecsPerHeartbeat", "getOutOfGameSecsPerHeartbeat", "()I", "inGameSecsPerHeartbeat", "getInGameSecsPerHeartbeat", "Ljava/net/InetAddress;", "publicIP", "getPublicIP", "()Ljava/net/InetAddress;", "Ljava/util/Date;", "serverTime", "getServerTime", "()Ljava/util/Date;", "accountFlags", "Ljava/util/EnumSet;", "Lin/dragonbra/javasteam/enums/EAccountFlags;", "getAccountFlags", "()Ljava/util/EnumSet;", "setAccountFlags", "(Ljava/util/EnumSet;)V", "clientSteamID", "Lin/dragonbra/javasteam/types/SteamID;", "getClientSteamID", "()Lin/dragonbra/javasteam/types/SteamID;", "setClientSteamID", "(Lin/dragonbra/javasteam/types/SteamID;)V", "", "emailDomain", "getEmailDomain", "()Ljava/lang/String;", "cellID", "getCellID", "cellIDPingThreshold", "getCellIDPingThreshold", "", "steam2Ticket", "getSteam2Ticket", "()[B", "ipCountryCode", "getIpCountryCode", "vanityURL", "getVanityURL", "numLoginFailuresToMigrate", "getNumLoginFailuresToMigrate", "numDisconnectsToMigrate", "getNumDisconnectsToMigrate", "parentalSettings", "Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesParentalSteamclient$ParentalSettings;", "getParentalSettings", "()Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesParentalSteamclient$ParentalSettings;", "setParentalSettings", "(Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesParentalSteamclient$ParentalSettings;)V", "handleNonProtoLogin", "", "javasteam"})
public final class LoggedOnCallback
extends CallbackMsg {
    @NotNull
    private EResult result;
    @Nullable
    private EResult extendedResult;
    private int outOfGameSecsPerHeartbeat;
    private int inGameSecsPerHeartbeat;
    @Nullable
    private InetAddress publicIP;
    @Nullable
    private Date serverTime;
    @Nullable
    private EnumSet<EAccountFlags> accountFlags;
    @Nullable
    private SteamID clientSteamID;
    @Nullable
    private String emailDomain;
    private int cellID;
    private int cellIDPingThreshold;
    @Nullable
    private byte[] steam2Ticket;
    @Nullable
    private String ipCountryCode;
    @Nullable
    private String vanityURL;
    private int numLoginFailuresToMigrate;
    private int numDisconnectsToMigrate;
    @Nullable
    private SteammessagesParentalSteamclient.ParentalSettings parentalSettings;

    @NotNull
    public final EResult getResult() {
        return this.result;
    }

    @Nullable
    public final EResult getExtendedResult() {
        return this.extendedResult;
    }

    public final void setExtendedResult(@Nullable EResult eResult) {
        this.extendedResult = eResult;
    }

    public final int getOutOfGameSecsPerHeartbeat() {
        return this.outOfGameSecsPerHeartbeat;
    }

    public final int getInGameSecsPerHeartbeat() {
        return this.inGameSecsPerHeartbeat;
    }

    @Nullable
    public final InetAddress getPublicIP() {
        return this.publicIP;
    }

    @Nullable
    public final Date getServerTime() {
        return this.serverTime;
    }

    @Nullable
    public final EnumSet<EAccountFlags> getAccountFlags() {
        return this.accountFlags;
    }

    public final void setAccountFlags(@Nullable EnumSet<EAccountFlags> enumSet) {
        this.accountFlags = enumSet;
    }

    @Nullable
    public final SteamID getClientSteamID() {
        return this.clientSteamID;
    }

    public final void setClientSteamID(@Nullable SteamID steamID) {
        this.clientSteamID = steamID;
    }

    @Nullable
    public final String getEmailDomain() {
        return this.emailDomain;
    }

    public final int getCellID() {
        return this.cellID;
    }

    public final int getCellIDPingThreshold() {
        return this.cellIDPingThreshold;
    }

    @Nullable
    public final byte[] getSteam2Ticket() {
        return this.steam2Ticket;
    }

    @Nullable
    public final String getIpCountryCode() {
        return this.ipCountryCode;
    }

    @Nullable
    public final String getVanityURL() {
        return this.vanityURL;
    }

    public final int getNumLoginFailuresToMigrate() {
        return this.numLoginFailuresToMigrate;
    }

    public final int getNumDisconnectsToMigrate() {
        return this.numDisconnectsToMigrate;
    }

    @Nullable
    public final SteammessagesParentalSteamclient.ParentalSettings getParentalSettings() {
        return this.parentalSettings;
    }

    public final void setParentalSettings(@Nullable SteammessagesParentalSteamclient.ParentalSettings parentalSettings) {
        this.parentalSettings = parentalSettings;
    }

    public LoggedOnCallback(@NotNull IPacketMsg packetMsg) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)packetMsg, (String)"packetMsg");
            this.result = EResult.Invalid;
            if (!packetMsg.isProto()) {
                this.handleNonProtoLogin(packetMsg);
                return;
            }
            ClientMsgProtobuf loginResp = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientLogonResponse.class, packetMsg);
            SteammessagesClientserverLogin.CMsgClientLogonResponse.Builder resp = (SteammessagesClientserverLogin.CMsgClientLogonResponse.Builder)loginResp.getBody();
            this.result = EResult.from(resp.getEresult());
            this.extendedResult = EResult.from(resp.getEresultExtended());
            this.outOfGameSecsPerHeartbeat = resp.getLegacyOutOfGameHeartbeatSeconds();
            this.inGameSecsPerHeartbeat = resp.getHeartbeatSeconds();
            this.publicIP = NetHelpers.getIPAddress(resp.getPublicIp().getV4());
            this.serverTime = new Date((long)resp.getRtime32ServerTime() * 1000L);
            this.accountFlags = EAccountFlags.from(resp.getAccountFlags());
            this.clientSteamID = new SteamID(resp.getClientSuppliedSteamid());
            this.emailDomain = resp.getEmailDomain();
            this.cellID = resp.getCellId();
            this.cellIDPingThreshold = resp.getCellIdPingThreshold();
            this.steam2Ticket = resp.getSteam2Ticket().toByteArray();
            this.ipCountryCode = resp.getIpCountryCode();
            this.vanityURL = resp.getVanityUrl();
            this.numLoginFailuresToMigrate = resp.getCountLoginfailuresToMigrate();
            this.numDisconnectsToMigrate = resp.getCountDisconnectsToMigrate();
            ByteString byteString = resp.getParentalSettings();
            if (byteString == null) break block3;
            ByteString it = byteString;
            boolean bl = false;
            try {
                this.parentalSettings = SteammessagesParentalSteamclient.ParentalSettings.parseFrom(it);
            }
            catch (InvalidProtocolBufferException e) {
                e.printStackTrace();
            }
        }
    }

    public LoggedOnCallback(@NotNull EResult result) {
        Intrinsics.checkNotNullParameter((Object)((Object)result), (String)"result");
        this.result = EResult.Invalid;
        this.result = result;
    }

    private final void handleNonProtoLogin(IPacketMsg packetMsg) {
        ClientMsg<MsgClientLogOnResponse> loginResp = new ClientMsg<MsgClientLogOnResponse>(MsgClientLogOnResponse.class, packetMsg);
        MsgClientLogOnResponse resp = loginResp.getBody();
        this.result = resp.getResult();
        this.outOfGameSecsPerHeartbeat = resp.getOutOfGameHeartbeatRateSec();
        this.inGameSecsPerHeartbeat = resp.getInGameHeartbeatRateSec();
        this.publicIP = NetHelpers.getIPAddress(resp.getIpPublic());
        this.serverTime = new Date((long)resp.getServerRealTime() * 1000L);
        this.clientSteamID = resp.getClientSuppliedSteamId();
    }
}

