/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamuserstats;

import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.ELeaderboardDataRequest;
import in.dragonbra.javasteam.enums.ELeaderboardDisplayType;
import in.dragonbra.javasteam.enums.ELeaderboardSortMethod;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver2;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverLbs;
import in.dragonbra.javasteam.steam.handlers.ClientMsgHandler;
import in.dragonbra.javasteam.steam.handlers.steamuserstats.callback.FindOrCreateLeaderboardCallback;
import in.dragonbra.javasteam.steam.handlers.steamuserstats.callback.LeaderboardEntriesCallback;
import in.dragonbra.javasteam.steam.handlers.steamuserstats.callback.NumberOfPlayersCallback;
import in.dragonbra.javasteam.steam.steamclient.SteamClient;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.AsyncJobSingle;
import in.dragonbra.javasteam.types.JobID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ,\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J4\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a8\u0006\u001e"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamuserstats/SteamUserStats;", "Lin/dragonbra/javasteam/steam/handlers/ClientMsgHandler;", "<init>", "()V", "getNumberOfCurrentPlayers", "Lin/dragonbra/javasteam/types/AsyncJobSingle;", "Lin/dragonbra/javasteam/steam/handlers/steamuserstats/callback/NumberOfPlayersCallback;", "appId", "", "findLeaderBoard", "Lin/dragonbra/javasteam/steam/handlers/steamuserstats/callback/FindOrCreateLeaderboardCallback;", "name", "", "createLeaderboard", "sortMethod", "Lin/dragonbra/javasteam/enums/ELeaderboardSortMethod;", "displayType", "Lin/dragonbra/javasteam/enums/ELeaderboardDisplayType;", "getLeaderboardEntries", "Lin/dragonbra/javasteam/steam/handlers/steamuserstats/callback/LeaderboardEntriesCallback;", "id", "rangeStart", "rangeEnd", "dataRequest", "Lin/dragonbra/javasteam/enums/ELeaderboardDataRequest;", "handleMsg", "", "packetMsg", "Lin/dragonbra/javasteam/base/IPacketMsg;", "Companion", "javasteam"})
public final class SteamUserStats
extends ClientMsgHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final AsyncJobSingle<NumberOfPlayersCallback> getNumberOfCurrentPlayers(int appId) {
        ClientMsgProtobuf msg = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgDPGetNumberOfCurrentPlayers.class, EMsg.ClientGetNumberOfCurrentPlayersDP);
        msg.setSourceJobID(this.getClient().getNextJobID());
        ((SteammessagesClientserver2.CMsgDPGetNumberOfCurrentPlayers.Builder)msg.getBody()).setAppid(appId);
        this.getClient().send(msg);
        SteamClient steamClient = this.getClient();
        JobID jobID = msg.getSourceJobID();
        Intrinsics.checkNotNullExpressionValue((Object)jobID, (String)"getSourceJobID(...)");
        return new AsyncJobSingle<NumberOfPlayersCallback>(steamClient, jobID);
    }

    @NotNull
    public final AsyncJobSingle<FindOrCreateLeaderboardCallback> findLeaderBoard(int appId, @Nullable String name) {
        ClientMsgProtobuf msg = new ClientMsgProtobuf(SteammessagesClientserverLbs.CMsgClientLBSFindOrCreateLB.class, EMsg.ClientLBSFindOrCreateLB);
        msg.setSourceJobID(this.getClient().getNextJobID());
        msg.getProtoHeader().setRoutingAppid(appId);
        ((SteammessagesClientserverLbs.CMsgClientLBSFindOrCreateLB.Builder)msg.getBody()).setAppId(appId);
        ((SteammessagesClientserverLbs.CMsgClientLBSFindOrCreateLB.Builder)msg.getBody()).setLeaderboardName(name);
        ((SteammessagesClientserverLbs.CMsgClientLBSFindOrCreateLB.Builder)msg.getBody()).setCreateIfNotFound(false);
        this.getClient().send(msg);
        SteamClient steamClient = this.getClient();
        JobID jobID = msg.getSourceJobID();
        Intrinsics.checkNotNullExpressionValue((Object)jobID, (String)"getSourceJobID(...)");
        return new AsyncJobSingle<FindOrCreateLeaderboardCallback>(steamClient, jobID);
    }

    @NotNull
    public final AsyncJobSingle<FindOrCreateLeaderboardCallback> createLeaderboard(int appId, @NotNull String name, @NotNull ELeaderboardSortMethod sortMethod, @NotNull ELeaderboardDisplayType displayType) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)sortMethod), (String)"sortMethod");
        Intrinsics.checkNotNullParameter((Object)((Object)displayType), (String)"displayType");
        ClientMsgProtobuf msg = new ClientMsgProtobuf(SteammessagesClientserverLbs.CMsgClientLBSFindOrCreateLB.class, EMsg.ClientLBSFindOrCreateLB);
        msg.setSourceJobID(this.getClient().getNextJobID());
        msg.getProtoHeader().setRoutingAppid(appId);
        ((SteammessagesClientserverLbs.CMsgClientLBSFindOrCreateLB.Builder)msg.getBody()).setAppId(appId);
        ((SteammessagesClientserverLbs.CMsgClientLBSFindOrCreateLB.Builder)msg.getBody()).setLeaderboardName(name);
        ((SteammessagesClientserverLbs.CMsgClientLBSFindOrCreateLB.Builder)msg.getBody()).setLeaderboardDisplayType(displayType.code());
        ((SteammessagesClientserverLbs.CMsgClientLBSFindOrCreateLB.Builder)msg.getBody()).setLeaderboardSortMethod(sortMethod.code());
        ((SteammessagesClientserverLbs.CMsgClientLBSFindOrCreateLB.Builder)msg.getBody()).setCreateIfNotFound(true);
        this.getClient().send(msg);
        SteamClient steamClient = this.getClient();
        JobID jobID = msg.getSourceJobID();
        Intrinsics.checkNotNullExpressionValue((Object)jobID, (String)"getSourceJobID(...)");
        return new AsyncJobSingle<FindOrCreateLeaderboardCallback>(steamClient, jobID);
    }

    @NotNull
    public final AsyncJobSingle<LeaderboardEntriesCallback> getLeaderboardEntries(int appId, int id, int rangeStart, int rangeEnd, @NotNull ELeaderboardDataRequest dataRequest) {
        Intrinsics.checkNotNullParameter((Object)((Object)dataRequest), (String)"dataRequest");
        ClientMsgProtobuf msg = new ClientMsgProtobuf(SteammessagesClientserverLbs.CMsgClientLBSGetLBEntries.class, EMsg.ClientLBSGetLBEntries);
        msg.setSourceJobID(this.getClient().getNextJobID());
        ((SteammessagesClientserverLbs.CMsgClientLBSGetLBEntries.Builder)msg.getBody()).setAppId(appId);
        ((SteammessagesClientserverLbs.CMsgClientLBSGetLBEntries.Builder)msg.getBody()).setLeaderboardId(id);
        ((SteammessagesClientserverLbs.CMsgClientLBSGetLBEntries.Builder)msg.getBody()).setLeaderboardDataRequest(dataRequest.code());
        ((SteammessagesClientserverLbs.CMsgClientLBSGetLBEntries.Builder)msg.getBody()).setRangeStart(rangeStart);
        ((SteammessagesClientserverLbs.CMsgClientLBSGetLBEntries.Builder)msg.getBody()).setRangeEnd(rangeEnd);
        this.getClient().send(msg);
        SteamClient steamClient = this.getClient();
        JobID jobID = msg.getSourceJobID();
        Intrinsics.checkNotNullExpressionValue((Object)jobID, (String)"getSourceJobID(...)");
        return new AsyncJobSingle<LeaderboardEntriesCallback>(steamClient, jobID);
    }

    @Override
    public void handleMsg(@NotNull IPacketMsg packetMsg) {
        Intrinsics.checkNotNullParameter((Object)packetMsg, (String)"packetMsg");
        CallbackMsg callbackMsg = SteamUserStats.Companion.getCallback(packetMsg);
        if (callbackMsg == null) {
            return;
        }
        CallbackMsg callback = callbackMsg;
        this.getClient().postCallback(callback);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamuserstats/SteamUserStats$Companion;", "", "<init>", "()V", "getCallback", "Lin/dragonbra/javasteam/steam/steamclient/callbackmgr/CallbackMsg;", "packetMsg", "Lin/dragonbra/javasteam/base/IPacketMsg;", "javasteam"})
    public static final class Companion {
        private Companion() {
        }

        private final CallbackMsg getCallback(IPacketMsg packetMsg) {
            CallbackMsg callbackMsg;
            EMsg eMsg = packetMsg.getMsgType();
            switch (eMsg == null ? -1 : WhenMappings.$EnumSwitchMapping$0[eMsg.ordinal()]) {
                case 1: {
                    callbackMsg = new NumberOfPlayersCallback(packetMsg);
                    break;
                }
                case 2: {
                    callbackMsg = new FindOrCreateLeaderboardCallback(packetMsg);
                    break;
                }
                case 3: {
                    callbackMsg = new LeaderboardEntriesCallback(packetMsg);
                    break;
                }
                default: {
                    callbackMsg = null;
                }
            }
            return callbackMsg;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[EMsg.values().length];
                try {
                    nArray[EMsg.ClientGetNumberOfCurrentPlayersDPResponse.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EMsg.ClientLBSFindOrCreateLBResponse.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EMsg.ClientLBSGetLBEntriesResponse.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

