/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.steamclient;

import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver;
import in.dragonbra.javasteam.steam.CMClient;
import in.dragonbra.javasteam.steam.authentication.SteamAuthentication;
import in.dragonbra.javasteam.steam.handlers.ClientMsgHandler;
import in.dragonbra.javasteam.steam.handlers.steamapps.SteamApps;
import in.dragonbra.javasteam.steam.handlers.steamcloud.SteamCloud;
import in.dragonbra.javasteam.steam.handlers.steamfriends.SteamFriends;
import in.dragonbra.javasteam.steam.handlers.steamgamecoordinator.SteamGameCoordinator;
import in.dragonbra.javasteam.steam.handlers.steamgameserver.SteamGameServer;
import in.dragonbra.javasteam.steam.handlers.steammasterserver.SteamMasterServer;
import in.dragonbra.javasteam.steam.handlers.steamnetworking.SteamNetworking;
import in.dragonbra.javasteam.steam.handlers.steamnotifications.SteamNotifications;
import in.dragonbra.javasteam.steam.handlers.steamscreenshots.SteamScreenshots;
import in.dragonbra.javasteam.steam.handlers.steamunifiedmessages.SteamUnifiedMessages;
import in.dragonbra.javasteam.steam.handlers.steamuser.SteamUser;
import in.dragonbra.javasteam.steam.handlers.steamuserstats.SteamUserStats;
import in.dragonbra.javasteam.steam.handlers.steamworkshop.SteamWorkshop;
import in.dragonbra.javasteam.steam.steamclient.AsyncJobManager;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.ICallbackMsg;
import in.dragonbra.javasteam.steam.steamclient.callbacks.CMListCallback;
import in.dragonbra.javasteam.steam.steamclient.callbacks.ConnectedCallback;
import in.dragonbra.javasteam.steam.steamclient.callbacks.DisconnectedCallback;
import in.dragonbra.javasteam.steam.steamclient.configuration.SteamConfiguration;
import in.dragonbra.javasteam.types.AsyncJob;
import in.dragonbra.javasteam.types.JobID;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 <2\u00020\u0001:\u0001<B\u0015\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\tJ\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\tH\u0002J\u0016\u0010\u001f\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bJ\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\tJ%\u0010 \u001a\u0004\u0018\u0001H!\"\b\b\u0000\u0010!*\u00020\t2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0\b\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u0004\u0018\u00010\u0010J\u0006\u0010%\u001a\u00020\u0010J\u000e\u0010&\u001a\u00020\u0010H\u0086@\u00a2\u0006\u0002\u0010'J\u0010\u0010%\u001a\u0004\u0018\u00010\u00102\u0006\u0010(\u001a\u00020)J\u0010\u0010*\u001a\u00020\u001c2\b\u0010+\u001a\u0004\u0018\u00010,J\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u000201J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0014J\b\u00106\u001a\u00020\u001cH\u0014J\u0010\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u000203H\u0014J\u0010\u00109\u001a\u00020\u001c2\u0006\u00104\u001a\u000205H\u0002J\u0010\u0010:\u001a\u00020\u001c2\u0006\u00104\u001a\u000205H\u0002J\u0010\u0010;\u001a\u00020\u001c2\u0006\u00104\u001a\u000205H\u0002R\"\u0010\u0006\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0015\u001a\u00020\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006="}, d2={"Lin/dragonbra/javasteam/steam/steamclient/SteamClient;", "Lin/dragonbra/javasteam/steam/CMClient;", "configuration", "Lin/dragonbra/javasteam/steam/steamclient/configuration/SteamConfiguration;", "<init>", "(Lin/dragonbra/javasteam/steam/steamclient/configuration/SteamConfiguration;)V", "handlers", "Ljava/util/HashMap;", "Ljava/lang/Class;", "Lin/dragonbra/javasteam/steam/handlers/ClientMsgHandler;", "currentJobId", "Ljava/util/concurrent/atomic/AtomicLong;", "processStartTime", "Ljava/util/Date;", "callbackQueue", "Lkotlinx/coroutines/channels/Channel;", "Lin/dragonbra/javasteam/steam/steamclient/callbackmgr/ICallbackMsg;", "jobManager", "Lin/dragonbra/javasteam/steam/steamclient/AsyncJobManager;", "getJobManager$javasteam", "()Lin/dragonbra/javasteam/steam/steamclient/AsyncJobManager;", "authentication", "Lin/dragonbra/javasteam/steam/authentication/SteamAuthentication;", "getAuthentication", "()Lin/dragonbra/javasteam/steam/authentication/SteamAuthentication;", "authentication$delegate", "Lkotlin/Lazy;", "addHandler", "", "handler", "addHandlerCore", "removeHandler", "getHandler", "T", "type", "(Ljava/lang/Class;)Lin/dragonbra/javasteam/steam/handlers/ClientMsgHandler;", "getCallback", "waitForCallback", "waitForCallbackAsync", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "timeout", "", "postCallback", "msg", "Lin/dragonbra/javasteam/steam/steamclient/callbackmgr/CallbackMsg;", "getNextJobID", "Lin/dragonbra/javasteam/types/JobID;", "startJob", "job", "Lin/dragonbra/javasteam/types/AsyncJob;", "onClientMsgReceived", "", "packetMsg", "Lin/dragonbra/javasteam/base/IPacketMsg;", "onClientConnected", "onClientDisconnected", "userInitiated", "handleCMList", "handleJobHeartbeat", "handleJobFailed", "Companion", "javasteam"})
@SourceDebugExtension(value={"SMAP\nSteamClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SteamClient.kt\nin/dragonbra/javasteam/steam/steamclient/SteamClient\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,284:1\n216#2,2:285\n1#3:287\n*S KotlinDebug\n*F\n+ 1 SteamClient.kt\nin/dragonbra/javasteam/steam/steamclient/SteamClient\n*L\n222#1:285,2\n*E\n"})
public final class SteamClient
extends CMClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<Class<? extends ClientMsgHandler>, ClientMsgHandler> handlers;
    @NotNull
    private final AtomicLong currentJobId;
    @NotNull
    private final Date processStartTime;
    @NotNull
    private final Channel<ICallbackMsg> callbackQueue;
    @NotNull
    private final AsyncJobManager jobManager;
    @NotNull
    private final Lazy authentication$delegate;
    @NotNull
    private static final Logger logger;
    private static final int HANDLERS_COUNT = 13;

    @JvmOverloads
    public SteamClient(@Nullable SteamConfiguration configuration) {
        super(configuration);
        this.handlers = new HashMap(13);
        this.currentJobId = new AtomicLong(0L);
        this.callbackQueue = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        this.authentication$delegate = LazyKt.lazy(() -> SteamClient.authentication_delegate$lambda$0(this));
        this.addHandlerCore(new SteamFriends());
        this.addHandlerCore(new SteamUser());
        this.addHandlerCore(new SteamApps());
        this.addHandlerCore(new SteamGameCoordinator());
        this.addHandlerCore(new SteamGameServer());
        this.addHandlerCore(new SteamMasterServer());
        this.addHandlerCore(new SteamCloud());
        this.addHandlerCore(new SteamWorkshop());
        this.addHandlerCore(new SteamUnifiedMessages());
        this.addHandlerCore(new SteamScreenshots());
        this.addHandlerCore(new SteamNetworking());
        this.addHandlerCore(new SteamNotifications());
        this.addHandlerCore(new SteamUserStats());
        if (this.handlers.size() != 13) {
            logger.error("Handlers size didnt match handlers count (" + this.handlers.size() + ") when initializing");
        }
        this.processStartTime = new Date();
        this.jobManager = new AsyncJobManager();
    }

    public /* synthetic */ SteamClient(SteamConfiguration steamConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            steamConfiguration = SteamConfiguration.Companion.createDefault();
        }
        this(steamConfiguration);
    }

    @NotNull
    public final AsyncJobManager getJobManager$javasteam() {
        return this.jobManager;
    }

    @NotNull
    public final SteamAuthentication getAuthentication() {
        Lazy lazy = this.authentication$delegate;
        return (SteamAuthentication)lazy.getValue();
    }

    public final void addHandler(@NotNull ClientMsgHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        if (!(!this.handlers.containsKey(handler.getClass()))) {
            boolean bl = false;
            String string = "A handler of type " + handler.getClass() + " is already registered.";
            throw new IllegalArgumentException(string.toString());
        }
        this.addHandlerCore(handler);
    }

    private final void addHandlerCore(ClientMsgHandler handler) {
        handler.setup(this);
        ((Map)this.handlers).put(handler.getClass(), handler);
    }

    public final void removeHandler(@NotNull Class<? extends ClientMsgHandler> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.handlers.remove(handler);
    }

    public final void removeHandler(@NotNull ClientMsgHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.removeHandler(handler.getClass());
    }

    @Nullable
    public final <T extends ClientMsgHandler> T getHandler(@NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return (T)this.handlers.get(type);
    }

    @Nullable
    public final ICallbackMsg getCallback() {
        return (ICallbackMsg)ChannelResult.getOrNull-impl((Object)this.callbackQueue.tryReceive-PtdJZtk());
    }

    @NotNull
    public final ICallbackMsg waitForCallback() {
        return (ICallbackMsg)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ICallbackMsg>, Object>(this, null){
            int label;
            final /* synthetic */ SteamClient this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = SteamClient.access$getCallbackQueue$p(this.this$0).receive((Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super ICallbackMsg> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Nullable
    public final Object waitForCallbackAsync(@NotNull Continuation<? super ICallbackMsg> $completion) {
        return this.callbackQueue.receive($completion);
    }

    @Nullable
    public final ICallbackMsg waitForCallback(long timeout) {
        return (ICallbackMsg)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ICallbackMsg>, Object>(timeout, this, null){
            int label;
            final /* synthetic */ long $timeout;
            final /* synthetic */ SteamClient this$0;
            {
                this.$timeout = $timeout;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = TimeoutKt.withTimeoutOrNull((long)this.$timeout, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ICallbackMsg>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ SteamClient this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = SteamClient.access$getCallbackQueue$p(this.this$0).receive((Continuation)this);
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super ICallbackMsg> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super ICallbackMsg> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public final void postCallback(@Nullable CallbackMsg msg) {
        if (msg == null) {
            return;
        }
        this.callbackQueue.trySend-JP2dKIU((Object)msg);
        this.jobManager.tryCompleteJob(msg.getJobID(), msg);
    }

    @NotNull
    public final JobID getNextJobID() {
        JobID jobID;
        JobID $this$getNextJobID_u24lambda_u242 = jobID = new JobID();
        boolean bl = false;
        $this$getNextJobID_u24lambda_u242.setBoxID(0L);
        $this$getNextJobID_u24lambda_u242.setProcessID(0L);
        $this$getNextJobID_u24lambda_u242.setSequentialCount(this.currentJobId.incrementAndGet());
        $this$getNextJobID_u24lambda_u242.setStartTime(this.processStartTime);
        return jobID;
    }

    public final void startJob(@NotNull AsyncJob job) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        this.jobManager.startJob(job);
    }

    @Override
    protected boolean onClientMsgReceived(@NotNull IPacketMsg packetMsg) {
        Intrinsics.checkNotNullParameter((Object)packetMsg, (String)"packetMsg");
        if (!super.onClientMsgReceived(packetMsg)) {
            return false;
        }
        EMsg eMsg = packetMsg.getMsgType();
        switch (eMsg == null ? -1 : WhenMappings.$EnumSwitchMapping$0[eMsg.ordinal()]) {
            case 1: {
                this.handleCMList(packetMsg);
                break;
            }
            case 2: {
                this.handleJobHeartbeat(packetMsg);
                break;
            }
            case 3: {
                this.handleJobFailed(packetMsg);
                break;
            }
        }
        Map $this$forEach$iv = this.handlers;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Class key = (Class)entry.getKey();
            ClientMsgHandler value = (ClientMsgHandler)entry.getValue();
            try {
                value.handleMsg(packetMsg);
            }
            catch (Exception e) {
                logger.debug("Unhandled exception from " + key.getName() + " handlers", e);
                this.disconnect();
                return false;
            }
        }
        return true;
    }

    @Override
    protected void onClientConnected() {
        super.onClientConnected();
        this.jobManager.setTimeoutsEnabled(true);
        ConnectedCallback connectedCallback = new ConnectedCallback();
        CallbackMsg p0 = connectedCallback;
        boolean $i$f$onClientConnected$stub_for_inlining = false;
        boolean bl = false;
        this.postCallback(p0);
    }

    @Override
    protected void onClientDisconnected(boolean userInitiated) {
        super.onClientDisconnected(userInitiated);
        this.jobManager.cancelPendingJobs();
        this.jobManager.setTimeoutsEnabled(false);
        this.postCallback(new DisconnectedCallback(userInitiated));
    }

    private final void handleCMList(IPacketMsg packetMsg) {
        ClientMsgProtobuf cmMsg = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientCMList.class, packetMsg);
        Object BodyType = cmMsg.getBody();
        Intrinsics.checkNotNullExpressionValue(BodyType, (String)"getBody(...)");
        CallbackMsg p0 = new CMListCallback((SteammessagesClientserver.CMsgClientCMList.Builder)BodyType);
        boolean $i$f$handleCMList$stub_for_inlining$4 = false;
        boolean bl = false;
        this.postCallback(p0);
    }

    private final void handleJobHeartbeat(IPacketMsg packetMsg) {
        JobID jobID = new JobID(packetMsg.getTargetJobID());
        AsyncJobManager asyncJobManager = this.jobManager;
        JobID p0 = jobID;
        boolean $i$f$handleJobHeartbeat$stub_for_inlining$5 = false;
        boolean bl = false;
        asyncJobManager.heartbeatJob(p0);
    }

    private final void handleJobFailed(IPacketMsg packetMsg) {
        JobID jobID = new JobID(packetMsg.getTargetJobID());
        AsyncJobManager asyncJobManager = this.jobManager;
        JobID p0 = jobID;
        boolean $i$f$handleJobFailed$stub_for_inlining$6 = false;
        boolean bl = false;
        asyncJobManager.failJob(p0);
    }

    @JvmOverloads
    public SteamClient() {
        this(null, 1, null);
    }

    private static final SteamAuthentication authentication_delegate$lambda$0(SteamClient this$0) {
        return new SteamAuthentication(this$0);
    }

    public static final /* synthetic */ Channel access$getCallbackQueue$p(SteamClient $this) {
        return $this.callbackQueue;
    }

    static {
        Logger logger = LogManager.getLogger(SteamClient.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        SteamClient.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lin/dragonbra/javasteam/steam/steamclient/SteamClient$Companion;", "", "<init>", "()V", "logger", "Lin/dragonbra/javasteam/util/log/Logger;", "HANDLERS_COUNT", "", "javasteam"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EMsg.values().length];
            try {
                nArray[EMsg.ClientCMList.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EMsg.JobHeartbeat.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EMsg.DestJobFailed.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

