/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.steamclient.configuration;

import in.dragonbra.javasteam.enums.EClientPersonaStateFlag;
import in.dragonbra.javasteam.enums.EUniverse;
import in.dragonbra.javasteam.networking.steam3.ProtocolTypes;
import in.dragonbra.javasteam.steam.discovery.IServerListProvider;
import in.dragonbra.javasteam.steam.discovery.SmartCMServerList;
import in.dragonbra.javasteam.steam.steamclient.configuration.ISteamConfigurationBuilder;
import in.dragonbra.javasteam.steam.steamclient.configuration.SteamConfigurationBuilder;
import in.dragonbra.javasteam.steam.steamclient.configuration.SteamConfigurationState;
import in.dragonbra.javasteam.steam.webapi.WebAPI;
import in.dragonbra.javasteam.util.compat.Consumer;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 22\u00020\u0001:\u00012B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0019R\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0013\u0010)\u001a\u0004\u0018\u00010&8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010(R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u00063"}, d2={"Lin/dragonbra/javasteam/steam/steamclient/configuration/SteamConfiguration;", "", "state", "Lin/dragonbra/javasteam/steam/steamclient/configuration/SteamConfigurationState;", "<init>", "(Lin/dragonbra/javasteam/steam/steamclient/configuration/SteamConfigurationState;)V", "isAllowDirectoryFetch", "", "()Z", "cellID", "", "getCellID", "()I", "connectionTimeout", "", "getConnectionTimeout", "()J", "httpClient", "Lokhttp3/OkHttpClient;", "getHttpClient", "()Lokhttp3/OkHttpClient;", "defaultPersonaStateFlags", "Ljava/util/EnumSet;", "Lin/dragonbra/javasteam/enums/EClientPersonaStateFlag;", "getDefaultPersonaStateFlags", "()Ljava/util/EnumSet;", "protocolTypes", "Lin/dragonbra/javasteam/networking/steam3/ProtocolTypes;", "getProtocolTypes", "serverListProvider", "Lin/dragonbra/javasteam/steam/discovery/IServerListProvider;", "getServerListProvider", "()Lin/dragonbra/javasteam/steam/discovery/IServerListProvider;", "universe", "Lin/dragonbra/javasteam/enums/EUniverse;", "getUniverse", "()Lin/dragonbra/javasteam/enums/EUniverse;", "webAPIBaseAddress", "", "getWebAPIBaseAddress", "()Ljava/lang/String;", "webAPIKey", "getWebAPIKey", "serverList", "Lin/dragonbra/javasteam/steam/discovery/SmartCMServerList;", "getServerList", "()Lin/dragonbra/javasteam/steam/discovery/SmartCMServerList;", "getWebAPI", "Lin/dragonbra/javasteam/steam/webapi/WebAPI;", "interface", "Companion", "javasteam"})
public final class SteamConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SteamConfigurationState state;
    @NotNull
    private final SmartCMServerList serverList;

    public SteamConfiguration(@NotNull SteamConfigurationState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
        this.serverList = new SmartCMServerList(this);
    }

    public final boolean isAllowDirectoryFetch() {
        return this.state.isAllowDirectoryFetch();
    }

    public final int getCellID() {
        return this.state.getCellID();
    }

    public final long getConnectionTimeout() {
        return this.state.getConnectionTimeout();
    }

    @NotNull
    public final OkHttpClient getHttpClient() {
        return this.state.getHttpClient();
    }

    @NotNull
    public final EnumSet<EClientPersonaStateFlag> getDefaultPersonaStateFlags() {
        return this.state.getDefaultPersonaStateFlags();
    }

    @NotNull
    public final EnumSet<ProtocolTypes> getProtocolTypes() {
        return this.state.getProtocolTypes();
    }

    @NotNull
    public final IServerListProvider getServerListProvider() {
        return this.state.getServerListProvider();
    }

    @NotNull
    public final EUniverse getUniverse() {
        return this.state.getUniverse();
    }

    @NotNull
    public final String getWebAPIBaseAddress() {
        return this.state.getWebAPIBaseAddress();
    }

    @Nullable
    public final String getWebAPIKey() {
        return this.state.getWebAPIKey();
    }

    @NotNull
    public final SmartCMServerList getServerList() {
        return this.serverList;
    }

    @NotNull
    public final WebAPI getWebAPI(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"interface");
        return new WebAPI(this.getHttpClient(), this.getWebAPIBaseAddress(), string, this.getWebAPIKey());
    }

    @JvmStatic
    @NotNull
    public static final SteamConfiguration create(@NotNull Consumer<ISteamConfigurationBuilder> configurator) {
        return Companion.create(configurator);
    }

    @JvmStatic
    @NotNull
    public static final SteamConfiguration createDefault() {
        return Companion.createDefault();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\b\u0010\t\u001a\u00020\u0005H\u0007\u00a8\u0006\n"}, d2={"Lin/dragonbra/javasteam/steam/steamclient/configuration/SteamConfiguration$Companion;", "", "<init>", "()V", "create", "Lin/dragonbra/javasteam/steam/steamclient/configuration/SteamConfiguration;", "configurator", "Lin/dragonbra/javasteam/util/compat/Consumer;", "Lin/dragonbra/javasteam/steam/steamclient/configuration/ISteamConfigurationBuilder;", "createDefault", "javasteam"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SteamConfiguration create(@NotNull Consumer<ISteamConfigurationBuilder> configurator) {
            Intrinsics.checkNotNullParameter(configurator, (String)"configurator");
            SteamConfigurationBuilder builder = new SteamConfigurationBuilder();
            configurator.accept(builder);
            return builder.build();
        }

        @JvmStatic
        @NotNull
        public final SteamConfiguration createDefault() {
            return new SteamConfiguration(SteamConfigurationBuilder.Companion.createDefaultState());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

