/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.steamclient.configuration;

import in.dragonbra.javasteam.enums.EClientPersonaStateFlag;
import in.dragonbra.javasteam.enums.EUniverse;
import in.dragonbra.javasteam.networking.steam3.ProtocolTypes;
import in.dragonbra.javasteam.steam.discovery.IServerListProvider;
import in.dragonbra.javasteam.steam.discovery.MemoryServerListProvider;
import in.dragonbra.javasteam.steam.steamclient.configuration.ISteamConfigurationBuilder;
import in.dragonbra.javasteam.steam.steamclient.configuration.SteamConfiguration;
import in.dragonbra.javasteam.steam.steamclient.configuration.SteamConfigurationState;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0001&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\u00020\u00012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\u00020\u00012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020#H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lin/dragonbra/javasteam/steam/steamclient/configuration/SteamConfigurationBuilder;", "Lin/dragonbra/javasteam/steam/steamclient/configuration/ISteamConfigurationBuilder;", "<init>", "()V", "state", "Lin/dragonbra/javasteam/steam/steamclient/configuration/SteamConfigurationState;", "build", "Lin/dragonbra/javasteam/steam/steamclient/configuration/SteamConfiguration;", "withCellID", "cellID", "", "withConnectionTimeout", "connectionTimeout", "", "withHttpClient", "httpClient", "Lokhttp3/OkHttpClient;", "withDefaultPersonaStateFlags", "personaStateFlags", "Ljava/util/EnumSet;", "Lin/dragonbra/javasteam/enums/EClientPersonaStateFlag;", "withDirectoryFetch", "allowDirectoryFetch", "", "withProtocolTypes", "protocolTypes", "Lin/dragonbra/javasteam/networking/steam3/ProtocolTypes;", "withServerListProvider", "provider", "Lin/dragonbra/javasteam/steam/discovery/IServerListProvider;", "withUniverse", "universe", "Lin/dragonbra/javasteam/enums/EUniverse;", "withWebAPIBaseAddress", "baseAddress", "", "withWebAPIKey", "webApiKey", "Companion", "javasteam"})
public final class SteamConfigurationBuilder
implements ISteamConfigurationBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SteamConfigurationState state = Companion.createDefaultState();

    @NotNull
    public final SteamConfiguration build() {
        return new SteamConfiguration(this.state);
    }

    @Override
    @NotNull
    public ISteamConfigurationBuilder withCellID(int cellID) {
        this.state.setCellID(cellID);
        return this;
    }

    @Override
    @NotNull
    public ISteamConfigurationBuilder withConnectionTimeout(long connectionTimeout) {
        this.state.setConnectionTimeout(connectionTimeout);
        return this;
    }

    @Override
    @NotNull
    public ISteamConfigurationBuilder withHttpClient(@NotNull OkHttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        this.state.setHttpClient(httpClient);
        return this;
    }

    @Override
    @NotNull
    public ISteamConfigurationBuilder withDefaultPersonaStateFlags(@NotNull EnumSet<EClientPersonaStateFlag> personaStateFlags) {
        Intrinsics.checkNotNullParameter(personaStateFlags, (String)"personaStateFlags");
        this.state.setDefaultPersonaStateFlags(personaStateFlags);
        return this;
    }

    @Override
    @NotNull
    public ISteamConfigurationBuilder withDefaultPersonaStateFlags(@NotNull EClientPersonaStateFlag personaStateFlags) {
        Intrinsics.checkNotNullParameter((Object)((Object)personaStateFlags), (String)"personaStateFlags");
        this.state.setDefaultPersonaStateFlags(EnumSet.of((Enum)personaStateFlags));
        return this;
    }

    @Override
    @NotNull
    public ISteamConfigurationBuilder withDirectoryFetch(boolean allowDirectoryFetch) {
        this.state.setAllowDirectoryFetch(allowDirectoryFetch);
        return this;
    }

    @Override
    @NotNull
    public ISteamConfigurationBuilder withProtocolTypes(@NotNull EnumSet<ProtocolTypes> protocolTypes) {
        Intrinsics.checkNotNullParameter(protocolTypes, (String)"protocolTypes");
        this.state.setProtocolTypes(protocolTypes);
        return this;
    }

    @Override
    @NotNull
    public ISteamConfigurationBuilder withProtocolTypes(@NotNull ProtocolTypes protocolTypes) {
        Intrinsics.checkNotNullParameter((Object)((Object)protocolTypes), (String)"protocolTypes");
        this.state.setProtocolTypes(EnumSet.of((Enum)protocolTypes));
        return this;
    }

    @Override
    @NotNull
    public ISteamConfigurationBuilder withServerListProvider(@NotNull IServerListProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.state.setServerListProvider(provider);
        return this;
    }

    @Override
    @NotNull
    public ISteamConfigurationBuilder withUniverse(@NotNull EUniverse universe) {
        Intrinsics.checkNotNullParameter((Object)((Object)universe), (String)"universe");
        this.state.setUniverse(universe);
        return this;
    }

    @Override
    @NotNull
    public ISteamConfigurationBuilder withWebAPIBaseAddress(@NotNull String baseAddress) {
        Intrinsics.checkNotNullParameter((Object)baseAddress, (String)"baseAddress");
        this.state.setWebAPIBaseAddress(baseAddress);
        return this;
    }

    @Override
    @NotNull
    public ISteamConfigurationBuilder withWebAPIKey(@NotNull String webApiKey) {
        Intrinsics.checkNotNullParameter((Object)webApiKey, (String)"webApiKey");
        this.state.setWebAPIKey(webApiKey);
        return this;
    }

    @JvmStatic
    @NotNull
    public static final SteamConfigurationState createDefaultState() {
        return Companion.createDefaultState();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lin/dragonbra/javasteam/steam/steamclient/configuration/SteamConfigurationBuilder$Companion;", "", "<init>", "()V", "createDefaultState", "Lin/dragonbra/javasteam/steam/steamclient/configuration/SteamConfigurationState;", "javasteam"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SteamConfigurationState createDefaultState() {
            EnumSet<Enum> enumSet = EnumSet.of((Enum)EClientPersonaStateFlag.PlayerName, (Enum)EClientPersonaStateFlag.Presence, (Enum)EClientPersonaStateFlag.SourceID, (Enum)EClientPersonaStateFlag.GameExtraInfo, (Enum)EClientPersonaStateFlag.LastSeen);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
            EnumSet<Enum> enumSet2 = enumSet;
            OkHttpClient okHttpClient = new OkHttpClient();
            EnumSet<Enum> enumSet3 = EnumSet.of((Enum)ProtocolTypes.TCP);
            Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"of(...)");
            EnumSet<Enum> enumSet4 = enumSet3;
            MemoryServerListProvider memoryServerListProvider = new MemoryServerListProvider();
            EUniverse eUniverse = EUniverse.Public;
            return new SteamConfigurationState(true, 0, 5000L, enumSet2, okHttpClient, enumSet4, memoryServerListProvider, eUniverse, "https://api.steampowered.com/", null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

