/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.webapi;

import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.steam.discovery.ServerRecord;
import in.dragonbra.javasteam.steam.steamclient.configuration.SteamConfiguration;
import in.dragonbra.javasteam.steam.webapi.WebAPI;
import in.dragonbra.javasteam.types.KeyValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SteamDirectory {
    public static List<ServerRecord> load(SteamConfiguration configuration) throws IOException {
        return SteamDirectory.load(configuration, -1);
    }

    public static List<ServerRecord> load(SteamConfiguration configuration, int maxServers) throws IOException {
        KeyValue response;
        EResult result;
        if (configuration == null) {
            throw new IllegalArgumentException("configuration null");
        }
        WebAPI api = configuration.getWebAPI("ISteamDirectory");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cellid", String.valueOf(configuration.getCellID()));
        if (maxServers >= 0) {
            params.put("maxcount", String.valueOf(maxServers));
        }
        if ((result = EResult.from((response = api.call("GetCMList", params)).get("result").asInteger(EResult.Invalid.code()))) != EResult.OK) {
            throw new IllegalStateException("Steam Web API returned EResult." + result);
        }
        KeyValue socketList = response.get("serverlist");
        KeyValue webSocketList = response.get("serverlist_websockets");
        ArrayList<ServerRecord> records = new ArrayList<ServerRecord>();
        for (KeyValue socket : socketList.getChildren()) {
            ServerRecord record = ServerRecord.tryCreateSocketServer(socket.getValue());
            if (record == null) continue;
            records.add(record);
        }
        for (KeyValue socket : webSocketList.getChildren()) {
            records.add(ServerRecord.createWebSocketServer(socket.getValue()));
        }
        return records;
    }
}

