/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.webapi;

import in.dragonbra.javasteam.types.KeyValue;
import in.dragonbra.javasteam.util.Versions;
import in.dragonbra.javasteam.util.WebHelpers;
import in.dragonbra.javasteam.util.compat.Consumer;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class WebAPI {
    public static final String DEFAULT_BASE_ADDRESS = "https://api.steampowered.com/";
    private final OkHttpClient client;
    private final HttpUrl baseAddress;
    private final String _interface;
    private final String webAPIKey;

    public WebAPI(OkHttpClient httpClient, String baseAddress, String _interface, String webAPIKey) {
        this.baseAddress = HttpUrl.parse((String)baseAddress);
        if (this.baseAddress == null) {
            throw new IllegalArgumentException();
        }
        this._interface = _interface;
        this.webAPIKey = webAPIKey;
        this.client = httpClient;
    }

    public KeyValue call(String httpMethod, String function, int version, Map<String, String> parameters) throws IOException, WebAPIRequestException {
        Request request = this.buildRequest(httpMethod, function, version, parameters);
        Response response = this.client.newCall(request).execute();
        if (!response.isSuccessful()) {
            throw new WebAPIRequestException(response);
        }
        return this.parseResponse(response);
    }

    public KeyValue call(String function, int version, Map<String, String> parameters) throws IOException {
        return this.call("GET", function, version, parameters);
    }

    public KeyValue call(String httpMethod, String function, Map<String, String> parameters) throws IOException {
        return this.call(httpMethod, function, 1, parameters);
    }

    public KeyValue call(String function, Map<String, String> parameters) throws IOException {
        return this.call("GET", function, 1, parameters);
    }

    public KeyValue call(String httpMethod, String function, int version) throws IOException {
        return this.call(httpMethod, function, version, null);
    }

    public KeyValue call(String function, int version) throws IOException {
        return this.call("GET", function, version, null);
    }

    public KeyValue call(String httpMethod, String function) throws IOException {
        return this.call(httpMethod, function, 1, null);
    }

    public KeyValue call(String function) throws IOException {
        return this.call("GET", function, 1, null);
    }

    public void call(String httpMethod, String function, int version, Map<String, String> parameters, final Consumer<KeyValue> callback, final Consumer<WebAPIRequestException> error) {
        Request request = this.buildRequest(httpMethod, function, version, parameters);
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                throw new IllegalStateException("request unsuccessful", e);
            }

            public void onResponse(Call call, Response response) {
                if (!response.isSuccessful()) {
                    error.accept(new WebAPIRequestException(response));
                } else {
                    callback.accept(WebAPI.this.parseResponse(response));
                }
            }
        });
    }

    public void call(String httpMethod, String function, int version, Consumer<KeyValue> callback, Consumer<WebAPIRequestException> error) throws IOException {
        this.call(httpMethod, function, version, null, callback, error);
    }

    public void call(String httpMethod, String function, Map<String, String> parameters, Consumer<KeyValue> callback, Consumer<WebAPIRequestException> error) throws IOException {
        this.call(httpMethod, function, 1, parameters, callback, error);
    }

    public void call(String httpMethod, String function, Consumer<KeyValue> callback, Consumer<WebAPIRequestException> error) throws IOException {
        this.call(httpMethod, function, 1, null, callback, error);
    }

    public void call(String function, int version, Consumer<KeyValue> callback, Consumer<WebAPIRequestException> error) throws IOException {
        this.call("GET", function, version, null, callback, error);
    }

    public void call(String function, Map<String, String> parameters, Consumer<KeyValue> callback, Consumer<WebAPIRequestException> error) throws IOException {
        this.call("GET", function, 1, parameters, callback, error);
    }

    public void call(String function, Consumer<KeyValue> callback, Consumer<WebAPIRequestException> error) throws IOException {
        this.call("GET", function, 1, null, callback, error);
    }

    private KeyValue parseResponse(Response response) {
        KeyValue kv = new KeyValue();
        try (InputStream is = response.body().byteStream();){
            kv.readAsText(is);
        }
        catch (Exception e) {
            throw new IllegalStateException("An internal error occurred when attempting to parse the response from the WebAPI server. This can indicate a change in the VDF format.", e);
        }
        return kv;
    }

    private Request buildRequest(String httpMethod, String function, int version, Map<String, String> parameters) {
        if (httpMethod == null) {
            throw new IllegalArgumentException("httpMethod is null");
        }
        if (!httpMethod.equalsIgnoreCase("GET") && !httpMethod.equalsIgnoreCase("POST")) {
            throw new IllegalArgumentException("only GET and POST is supported right now");
        }
        if (function == null) {
            throw new IllegalArgumentException("function is null");
        }
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        parameters.put("format", "vdf");
        if (this.webAPIKey != null) {
            parameters.put("key", this.webAPIKey);
        }
        Request.Builder builder = new Request.Builder();
        builder.header("User-Agent", "JavaSteam-" + Versions.getVersion());
        HttpUrl.Builder urlBuilder = this.baseAddress.newBuilder().addPathSegment(this._interface).addPathSegment(function).addPathSegment("v" + version);
        if (httpMethod.equalsIgnoreCase("GET")) {
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                urlBuilder.addEncodedQueryParameter(WebHelpers.urlEncode(param.getKey()), param.getValue());
            }
            builder.get();
        } else {
            FormBody.Builder bodyBuilder = new FormBody.Builder();
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                bodyBuilder.addEncoded(WebHelpers.urlEncode(param.getKey()), param.getValue());
            }
            builder.post((RequestBody)bodyBuilder.build());
        }
        HttpUrl url = urlBuilder.build();
        return builder.url(url).build();
    }

    public HttpUrl getBaseAddress() {
        return this.baseAddress;
    }

    public String getInterface() {
        return this._interface;
    }

    public String getWebAPIKey() {
        return this.webAPIKey;
    }

    public static class WebAPIRequestException
    extends IOException {
        private final int statusCode;
        private final Map<String, List<String>> headers;

        WebAPIRequestException(Response response) {
            super(response.message());
            this.statusCode = response.code();
            this.headers = response.headers().toMultimap();
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }
    }
}

