/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.types;

import in.dragonbra.javasteam.steam.steamclient.SteamClient;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.JobID;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0004J\u0012\u0010\u001b\u001a\u00020\u00172\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH&J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0017H&J\u0006\u0010 \u001a\u00020\u001aR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018\u00a8\u0006!"}, d2={"Lin/dragonbra/javasteam/types/AsyncJob;", "", "client", "Lin/dragonbra/javasteam/steam/steamclient/SteamClient;", "jobID", "Lin/dragonbra/javasteam/types/JobID;", "<init>", "(Lin/dragonbra/javasteam/steam/steamclient/SteamClient;Lin/dragonbra/javasteam/types/JobID;)V", "getClient", "()Lin/dragonbra/javasteam/steam/steamclient/SteamClient;", "getJobID", "()Lin/dragonbra/javasteam/types/JobID;", "jobStart", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "Ljava/time/Instant;", "timeout", "", "getTimeout", "()J", "setTimeout", "(J)V", "isTimedOut", "", "()Z", "registerJob", "", "addResult", "callback", "Lin/dragonbra/javasteam/steam/steamclient/callbackmgr/CallbackMsg;", "setFailed", "dueToRemoteFailure", "heartbeat", "javasteam"})
@SourceDebugExtension(value={"SMAP\nAsyncJob.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncJob.kt\nin/dragonbra/javasteam/types/AsyncJob\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,41:1\n1#2:42\n*E\n"})
public abstract class AsyncJob {
    @Nullable
    private final SteamClient client;
    @Nullable
    private final JobID jobID;
    private Instant jobStart;
    private long timeout;

    public AsyncJob(@Nullable SteamClient client, @Nullable JobID jobID) {
        this.client = client;
        this.jobID = jobID;
        this.jobStart = Instant.now();
        this.timeout = 10000L;
        if (this.client == null) {
            boolean $i$a$-requireNotNull-AsyncJob$32 = false;
            String $i$a$-requireNotNull-AsyncJob$32 = "client must not be null";
            throw new IllegalArgumentException($i$a$-requireNotNull-AsyncJob$32.toString());
        }
        if (this.jobID == null) {
            boolean bl = false;
            String string = "jobId must not be null";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Nullable
    public final SteamClient getClient() {
        return this.client;
    }

    @Nullable
    public final JobID getJobID() {
        return this.jobID;
    }

    public final long getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(long l) {
        this.timeout = l;
    }

    public final boolean isTimedOut() {
        return Instant.now().compareTo(this.jobStart.plusMillis(this.timeout)) >= 0;
    }

    protected final void registerJob(@NotNull SteamClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        client.startJob(this);
    }

    public abstract boolean addResult(@Nullable CallbackMsg var1);

    public abstract void setFailed(boolean var1);

    public final void heartbeat() {
        System.out.println((Object)"heartbeat");
        this.timeout += (long)10000;
    }
}

