/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.types;

import in.dragonbra.javasteam.types.KeyValue;
import in.dragonbra.javasteam.util.Passable;
import in.dragonbra.javasteam.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class KVTextReader
extends PushbackInputStream {
    public static final Map<Character, Character> ESCAPED_MAPPING;

    KVTextReader(KeyValue kv, InputStream is) throws IOException {
        super(is);
        String s;
        Passable<Boolean> wasQuoted = new Passable<Boolean>(false);
        Passable<Boolean> wasConditional = new Passable<Boolean>(false);
        KeyValue currentKey = kv;
        while (!Strings.isNullOrEmpty(s = this.readToken(wasQuoted, wasConditional))) {
            if (currentKey == null) {
                currentKey = new KeyValue(s);
            } else {
                currentKey.setName(s);
            }
            s = this.readToken(wasQuoted, wasConditional);
            if (wasConditional.getValue().booleanValue()) {
                s = this.readToken(wasQuoted, wasConditional);
            }
            if (!s.startsWith("{") || wasQuoted.getValue().booleanValue()) {
                throw new IllegalStateException("LoadFromBuffer: missing {");
            }
            currentKey.recursiveLoadFromBuffer(this);
            currentKey = null;
            if (!this.endOfStream()) continue;
        }
    }

    private void eatWhiteSpace() throws IOException {
        while (!this.endOfStream() && Character.isWhitespace((char)this.peek())) {
            this.read();
        }
    }

    private boolean eatCPPComment() throws IOException {
        if (!this.endOfStream()) {
            char next = (char)this.peek();
            if (next == '/') {
                this.readLine();
                return true;
            }
            return false;
        }
        return false;
    }

    private void readLine() throws IOException {
        char c;
        while ((c = (char)this.read()) != '\n' && !this.endOfStream()) {
        }
    }

    private byte peek() throws IOException {
        int p = this.read();
        if (p >= 0) {
            this.unread(p);
        }
        return (byte)p;
    }

    public String readToken(Passable<Boolean> wasQuoted, Passable<Boolean> wasConditional) throws IOException {
        wasQuoted.setValue(false);
        wasConditional.setValue(false);
        do {
            this.eatWhiteSpace();
            if (!this.endOfStream()) continue;
            return null;
        } while (this.eatCPPComment());
        if (this.endOfStream()) {
            return null;
        }
        char next = (char)this.peek();
        if (next == '\"') {
            wasQuoted.setValue(true);
            this.read();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while (!this.endOfStream()) {
                if (this.peek() == 92) {
                    this.read();
                    char escapedChar = (char)this.read();
                    Character replacedChar = ESCAPED_MAPPING.get(Character.valueOf(escapedChar));
                    if (replacedChar == null) {
                        replacedChar = Character.valueOf(escapedChar);
                    }
                    baos.write(replacedChar.charValue());
                    continue;
                }
                if (this.peek() == 34) break;
                baos.write(this.read());
            }
            this.read();
            return baos.toString(StandardCharsets.UTF_8);
        }
        if (next == '{' || next == '}') {
            this.read();
            return String.valueOf(next);
        }
        boolean bConditionalStart = false;
        int count = 0;
        StringBuilder ret = new StringBuilder();
        while (!this.endOfStream() && (next = (char)this.peek()) != '\"' && next != '{' && next != '}') {
            if (next == '[') {
                bConditionalStart = true;
            }
            if (next == ']' && bConditionalStart) {
                wasConditional.setValue(true);
            }
            if (Character.isWhitespace(next)) break;
            if (count >= 1023) {
                throw new IOException("ReadToken overflow");
            }
            ret.append(next);
            this.read();
        }
        return ret.toString();
    }

    private boolean endOfStream() {
        try {
            return this.peek() == -1;
        }
        catch (IOException e) {
            return true;
        }
    }

    static {
        TreeMap<Character, Character> escapedMapping = new TreeMap<Character, Character>();
        escapedMapping.put(Character.valueOf('n'), Character.valueOf('\n'));
        escapedMapping.put(Character.valueOf('r'), Character.valueOf('\r'));
        escapedMapping.put(Character.valueOf('t'), Character.valueOf('\t'));
        escapedMapping.put(Character.valueOf('\\'), Character.valueOf('\\'));
        ESCAPED_MAPPING = Collections.unmodifiableMap(escapedMapping);
    }
}

