/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.types;

import in.dragonbra.javasteam.types.KVTextReader;
import in.dragonbra.javasteam.util.Passable;
import in.dragonbra.javasteam.util.Strings;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import in.dragonbra.javasteam.util.stream.BinaryReader;
import in.dragonbra.javasteam.util.stream.MemoryStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class KeyValue {
    private static final Logger logger = LogManager.getLogger(KeyValue.class);
    public static final KeyValue INVALID = new KeyValue();
    private String name;
    private String value;
    private List<KeyValue> children = new ArrayList<KeyValue>();

    public KeyValue() {
        this(null);
    }

    public KeyValue(String name) {
        this(name, null);
    }

    public KeyValue(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public KeyValue get(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        for (KeyValue c : this.children) {
            if (!key.equalsIgnoreCase(c.name)) continue;
            return c;
        }
        return INVALID;
    }

    public void set(String key, KeyValue value) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        this.children.removeIf(keyValue -> key.equalsIgnoreCase(keyValue.name));
        value.setName(key);
        this.children.add(value);
    }

    public String asString() {
        return this.value;
    }

    public byte asByte(byte defaultValue) {
        try {
            return Byte.parseByte(this.value);
        }
        catch (NullPointerException | NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public byte asByte() {
        return this.asByte((byte)0);
    }

    public short asShort(short defaultValue) {
        try {
            return Short.parseShort(this.value);
        }
        catch (NullPointerException | NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public short asShort() {
        return this.asShort((short)0);
    }

    public int asInteger(int defaultValue) {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NullPointerException | NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public int asInteger() {
        return this.asInteger(0);
    }

    public long asLong(long defaultValue) {
        try {
            return Long.parseLong(this.value);
        }
        catch (NullPointerException | NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public long asLong() {
        return this.asLong(0L);
    }

    public float asFloat(float defaultValue) {
        try {
            return Float.parseFloat(this.value);
        }
        catch (NullPointerException | NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public float asFloat() {
        return this.asFloat(0.0f);
    }

    public boolean asBoolean(boolean defaultValue) {
        try {
            return Integer.parseInt(this.value) != 0;
        }
        catch (NullPointerException | NumberFormatException e) {
            try {
                return Boolean.parseBoolean(this.value);
            }
            catch (NullPointerException | NumberFormatException e1) {
                return defaultValue;
            }
        }
    }

    public boolean asBoolean() {
        return this.asBoolean(false);
    }

    public <T extends Enum<T>> EnumSet<T> asEnum(Class<T> enumClass, T defaultValue) {
        return this.asEnum(enumClass, EnumSet.of(defaultValue));
    }

    public <T extends Enum<T>> EnumSet<T> asEnum(Class<T> enumClass, EnumSet<T> defaultValue) {
        try {
            int code = Integer.parseInt(this.value);
            Field codeField = enumClass.getDeclaredField("code");
            Method from = enumClass.getMethod("from", codeField.getType());
            Object res = from.invoke(null, code);
            if (res instanceof EnumSet) {
                return (EnumSet)res;
            }
            return EnumSet.of((Enum)enumClass.cast(res));
        }
        catch (NullPointerException | NumberFormatException code) {
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
        try {
            return EnumSet.of(Enum.valueOf(enumClass, this.value));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            try {
                for (Field field : enumClass.getDeclaredFields()) {
                    if (!Modifier.isStatic(field.getModifiers()) || !field.getName().equals(this.value) || !field.getType().isAssignableFrom(EnumSet.class)) continue;
                    return (EnumSet)field.get(null);
                }
            }
            catch (IllegalAccessException e2) {
                e2.printStackTrace();
            }
            return defaultValue;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<KeyValue> getChildren() {
        return this.children;
    }

    public boolean readAsText(InputStream is) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("input stream is null");
        }
        this.children = new ArrayList<KeyValue>();
        new KVTextReader(this, is);
        return true;
    }

    public boolean readFileAsText(String filename) throws IOException {
        try (FileInputStream fis = new FileInputStream(filename);){
            boolean bl = this.readAsText(fis);
            return bl;
        }
    }

    void recursiveLoadFromBuffer(KVTextReader kvr) throws IOException {
        Passable<Boolean> wasQuoted = new Passable<Boolean>(false);
        Passable<Boolean> wasConditional = new Passable<Boolean>(false);
        while (true) {
            String name;
            if (Strings.isNullOrEmpty(name = kvr.readToken(wasQuoted, wasConditional))) {
                throw new IllegalStateException("RecursiveLoadFromBuffer: got EOF or empty keyname");
            }
            if (name.startsWith("}") && !wasQuoted.getValue().booleanValue()) break;
            KeyValue dat = new KeyValue(name);
            dat.children = new ArrayList<KeyValue>();
            this.children.add(dat);
            String value = kvr.readToken(wasQuoted, wasConditional);
            if (value == null) {
                throw new IllegalStateException("RecursiveLoadFromBuffer:  got NULL key");
            }
            if (value.startsWith("}") && !wasQuoted.getValue().booleanValue()) {
                throw new IllegalStateException("RecursiveLoadFromBuffer:  got } in key");
            }
            if (value.startsWith("{") && !wasQuoted.getValue().booleanValue()) {
                dat.recursiveLoadFromBuffer(kvr);
                continue;
            }
            if (wasConditional.getValue().booleanValue()) {
                throw new IllegalStateException("RecursiveLoadFromBuffer:  got conditional between key and value");
            }
            dat.setValue(value);
        }
    }

    public static KeyValue loadAsText(String path) {
        return KeyValue.loadFromFile(path, false);
    }

    public static KeyValue tryLoadAsBinary(String path) {
        return KeyValue.loadFromFile(path, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static KeyValue loadFromFile(String path, boolean asBinary) {
        File file = new File(path);
        if (!file.exists()) return null;
        if (file.isDirectory()) {
            return null;
        }
        try (FileInputStream fis = new FileInputStream(file);){
            String fisString = IOUtils.toString((InputStream)fis, (Charset)Charset.defaultCharset());
            byte[] fisStringToBytes = fisString.getBytes(StandardCharsets.UTF_8);
            MemoryStream ms = new MemoryStream(fisStringToBytes, 0, fisStringToBytes.length - 1);
            KeyValue kv = new KeyValue();
            if (asBinary) {
                if (!kv.tryReadAsBinary(ms)) {
                    KeyValue keyValue = null;
                    return keyValue;
                }
            } else if (!kv.readAsText(ms)) {
                KeyValue keyValue = null;
                return keyValue;
            }
            KeyValue keyValue = kv;
            return keyValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyValue loadFromString(String input) {
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        byte[] bytes = input.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            KeyValue kv = new KeyValue();
            if (!kv.readAsText(bais)) {
                KeyValue keyValue = null;
                return keyValue;
            }
            KeyValue keyValue = kv;
            return keyValue;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void saveToFile(File path, boolean binary) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(path, false);){
            this.saveToStream(fos, binary);
        }
    }

    public void saveToStream(OutputStream os, boolean binary) throws IOException {
        if (os == null) {
            throw new IllegalArgumentException("output stream is null");
        }
        if (binary) {
            this.recursiveSaveBinaryToStream(os);
        } else {
            this.recursiveSaveTextToFile(os);
        }
    }

    private void recursiveSaveBinaryToStream(OutputStream os) throws IOException {
        this.recursiveSaveBinaryToStreamCore(os);
        os.write(Type.END.code());
    }

    private void recursiveSaveBinaryToStreamCore(OutputStream os) throws IOException {
        if (this.value == null) {
            os.write(Type.NONE.code());
            os.write(this.name.getBytes(StandardCharsets.UTF_8));
            os.write(0);
            for (KeyValue child : this.children) {
                child.recursiveSaveBinaryToStreamCore(os);
            }
            os.write(Type.END.code());
        } else {
            os.write(Type.STRING.code());
            os.write(this.name.getBytes(StandardCharsets.UTF_8));
            os.write(0);
            os.write(this.value.getBytes(StandardCharsets.UTF_8));
            os.write(0);
        }
    }

    private void recursiveSaveTextToFile(OutputStream os) throws IOException {
        this.recursiveSaveTextToFile(os, 0);
    }

    private void recursiveSaveTextToFile(OutputStream os, int indentLevel) throws IOException {
        this.writeIndents(os, indentLevel);
        KeyValue.writeString(os, this.name, true);
        KeyValue.writeString(os, "\n");
        this.writeIndents(os, indentLevel);
        KeyValue.writeString(os, "{\n");
        for (KeyValue child : this.children) {
            if (child.getValue() == null) {
                child.recursiveSaveTextToFile(os, indentLevel + 1);
                continue;
            }
            this.writeIndents(os, indentLevel + 1);
            KeyValue.writeString(os, child.getName(), true);
            KeyValue.writeString(os, "\t\t");
            KeyValue.writeString(os, KeyValue.escapeText(child.asString()), true);
            KeyValue.writeString(os, "\n");
        }
        this.writeIndents(os, indentLevel);
        KeyValue.writeString(os, "}\n");
    }

    private static String escapeText(String value) {
        for (Map.Entry<Character, Character> entry : KVTextReader.ESCAPED_MAPPING.entrySet()) {
            String textToReplace = String.valueOf(entry.getValue());
            String escapedReplacement = "\\" + entry.getKey();
            value = value.replace(textToReplace, escapedReplacement);
        }
        return value;
    }

    private void writeIndents(OutputStream os, int indentLevel) throws IOException {
        KeyValue.writeString(os, new String(new char[indentLevel]).replace('\u0000', '\t'));
    }

    private static void writeString(OutputStream os, String str) throws IOException {
        KeyValue.writeString(os, str, false);
    }

    private static void writeString(OutputStream os, String str, boolean quote) throws IOException {
        str = ((String)str).replaceAll("\"", "\\\"");
        if (quote) {
            str = "\"" + (String)str + "\"";
        }
        byte[] bytes = ((String)str).getBytes(StandardCharsets.UTF_8);
        os.write(bytes);
    }

    public boolean tryReadAsBinary(InputStream is) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("input stream is null");
        }
        return KeyValue.tryReadAsBinaryCore(is, this, null);
    }

    private static boolean tryReadAsBinaryCore(InputStream is, KeyValue current, KeyValue parent) throws IOException {
        Type type;
        current.children = new ArrayList<KeyValue>();
        BinaryReader br = new BinaryReader(is);
        while ((type = Type.from(br.readByte())) != Type.END) {
            current.setName(br.readNullTermString(StandardCharsets.UTF_8));
            switch (type) {
                case NONE: {
                    KeyValue child = new KeyValue();
                    boolean didReadChild = KeyValue.tryReadAsBinaryCore(is, child, current);
                    if (didReadChild) break;
                    return false;
                }
                case STRING: {
                    current.setValue(br.readNullTermString(StandardCharsets.UTF_8));
                    break;
                }
                case WIDESTRING: {
                    logger.debug("Encountered WideString type when parsing binary KeyValue, which is unsupported. Returning false.");
                    return false;
                }
                case INT32: 
                case COLOR: 
                case POINTER: {
                    current.setValue(String.valueOf(br.readInt()));
                    break;
                }
                case UINT64: {
                    current.setValue(String.valueOf(br.readLong()));
                    break;
                }
                case FLOAT32: {
                    current.setValue(String.valueOf(br.readFloat()));
                    break;
                }
                case INT64: {
                    current.setValue(String.valueOf(br.readLong()));
                    break;
                }
                default: {
                    return false;
                }
            }
            if (parent != null) {
                parent.getChildren().add(current);
            }
            current = new KeyValue();
        }
        return true;
    }

    public String toString() {
        return String.format("%s = %s", this.name, this.value);
    }

    public static enum Type {
        NONE(0),
        STRING(1),
        INT32(2),
        FLOAT32(3),
        POINTER(4),
        WIDESTRING(5),
        COLOR(6),
        UINT64(7),
        END(8),
        INT64(10);

        private final byte code;

        private Type(byte code) {
            this.code = code;
        }

        public byte code() {
            return this.code;
        }

        public static Type from(byte code) {
            for (Type e : Type.values()) {
                if (e.code != code) continue;
                return e;
            }
            return null;
        }
    }
}

