/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.util;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.apache.commons.validator.routines.InetAddressValidator;

public class NetHelpers {
    public static InetAddress getIPAddress(int ipAddr) {
        ByteBuffer b = ByteBuffer.allocate(4);
        b.putInt(ipAddr);
        byte[] result = b.array();
        try {
            return InetAddress.getByAddress(result);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static int getIPAddress(InetAddress ip) {
        ByteBuffer buff = ByteBuffer.wrap(ip.getAddress());
        return (int)((long)buff.getInt() & 0xFFFFFFFFL);
    }

    public static InetSocketAddress tryParseIPEndPoint(String address) {
        if (address == null) {
            return null;
        }
        String[] split = address.split(":");
        if (!InetAddressValidator.getInstance().isValidInet4Address(split[0])) {
            return null;
        }
        try {
            if (split.length > 1) {
                return new InetSocketAddress(split[0], Integer.parseInt(split[1]));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }
}

