/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.util.crypto;

import in.dragonbra.javasteam.enums.EOSType;
import in.dragonbra.javasteam.util.Passable;
import in.dragonbra.javasteam.util.Utils;
import in.dragonbra.javasteam.util.crypto.CryptoException;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import in.dragonbra.javasteam.util.stream.BinaryWriter;
import in.dragonbra.javasteam.util.stream.MemoryStream;
import in.dragonbra.javasteam.util.stream.SeekOrigin;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import java.util.zip.CRC32;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptoHelper {
    private static final Logger logger = LogManager.getLogger(CryptoHelper.class);
    public static final String SEC_PROV;

    public static byte[] shaHash(byte[] input) throws NoSuchAlgorithmException {
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        MessageDigest sha = MessageDigest.getInstance("SHA-1");
        return sha.digest(input);
    }

    public static byte[] generateRandomBlock(int size) {
        SecureRandom random = new SecureRandom();
        byte[] b = new byte[size];
        random.nextBytes(b);
        return b;
    }

    public static byte[] crcHash(byte[] input) {
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        CRC32 crc = new CRC32();
        crc.update(input, 0, input.length);
        long hash = crc.getValue();
        MemoryStream ms = new MemoryStream(4);
        try {
            BinaryWriter bw = new BinaryWriter(ms.asOutputStream());
            try {
                bw.writeInt((int)hash);
            }
            catch (IOException e) {
                logger.debug(e);
            }
            byte[] byArray = ms.toByteArray();
            ms.close();
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ms.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("MemoryStream closed");
            }
        }
    }

    public static byte[] symmetricDecrypt(byte[] input, byte[] key) throws CryptoException {
        return CryptoHelper.symmetricDecrypt(input, key, new Passable<byte[]>());
    }

    public static byte[] symmetricDecrypt(byte[] input, byte[] key, Passable<byte[]> iv) throws CryptoException {
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        try {
            if (key.length != 32) {
                logger.debug("SymmetricDecrypt used with non 32 byte key!");
            }
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding", SEC_PROV);
            iv.setValue(new byte[16]);
            byte[] cryptedIv = Arrays.copyOfRange(input, 0, 16);
            byte[] cipherText = new byte[input.length - cryptedIv.length];
            cipherText = Arrays.copyOfRange(input, cryptedIv.length, cryptedIv.length + cipherText.length);
            cipher.init(2, new SecretKeySpec(key, "AES"));
            iv.setValue(cipher.doFinal(cryptedIv));
            cipher = Cipher.getInstance("AES/CBC/PKCS7Padding", SEC_PROV);
            cipher.init(2, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv.getValue()));
            return cipher.doFinal(cipherText);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoException("failed to symmetric decrypt", e);
        }
    }

    public static byte[] symmetricEncryptWithIV(byte[] input, byte[] key, byte[] iv) throws CryptoException {
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (iv == null) {
            throw new IllegalArgumentException("iv is null");
        }
        try {
            if (key.length != 32) {
                logger.debug("SymmetricEncrypt used with non 32 byte key!");
            }
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding", SEC_PROV);
            cipher.init(1, new SecretKeySpec(key, "AES"));
            byte[] cryptedIv = cipher.doFinal(iv);
            cipher = Cipher.getInstance("AES/CBC/PKCS7Padding", SEC_PROV);
            cipher.init(1, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv));
            byte[] cipherText = cipher.doFinal(input);
            byte[] output = new byte[cryptedIv.length + cipherText.length];
            System.arraycopy(cryptedIv, 0, output, 0, cryptedIv.length);
            System.arraycopy(cipherText, 0, output, cryptedIv.length, cipherText.length);
            return output;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoException("failed to symmetric encrypt", e);
        }
    }

    public static byte[] symmetricEncrypt(byte[] input, byte[] key) throws CryptoException {
        return CryptoHelper.symmetricEncryptWithIV(input, key, CryptoHelper.generateRandomBlock(16));
    }

    public static byte[] symmetricDecryptHMACIV(byte[] input, byte[] key, byte[] hmacSecret) throws CryptoException {
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (hmacSecret == null) {
            throw new IllegalArgumentException("hmacSecret is null");
        }
        if (key.length < 16) {
            logger.debug("symmetricDecryptHMACIV used with shorter than 16 byte key!");
        }
        byte[] truncatedKeyForHmac = new byte[16];
        System.arraycopy(key, 0, truncatedKeyForHmac, 0, truncatedKeyForHmac.length);
        Passable<byte[]> iv = new Passable<byte[]>(new byte[16]);
        byte[] plaintextData = CryptoHelper.symmetricDecrypt(input, key, iv);
        MemoryStream ms = new MemoryStream();
        try {
            ms.write(iv.getValue(), iv.getValue().length - 3, 3);
            ms.write(plaintextData, 0, plaintextData.length);
            ms.seek(0L, SeekOrigin.BEGIN);
            try {
                Mac mac = Mac.getInstance("HmacSHA1");
                mac.init(new SecretKeySpec(hmacSecret, "HmacSHA1"));
                byte[] hmacBytes = mac.doFinal(ms.toByteArray());
                for (int i = 0; i < iv.getValue().length - 3; ++i) {
                    if (hmacBytes[i] == iv.getValue()[i]) continue;
                    throw new CryptoException("NetFilterEncryption was unable to decrypt packet: HMAC from server did not match computed HMAC.");
                }
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new CryptoException("NetFilterEncryption was unable to decrypt packet", e);
            }
            byte[] byArray = plaintextData;
            ms.close();
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ms.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("MemoryStream closed");
            }
        }
    }

    public static byte[] symmetricEncryptWithHMACIV(byte[] input, byte[] key, byte[] hmacSecret) throws CryptoException {
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (hmacSecret == null) {
            throw new IllegalArgumentException("hmacSecret is null");
        }
        byte[] iv = new byte[16];
        byte[] random = CryptoHelper.generateRandomBlock(3);
        System.arraycopy(random, 0, iv, iv.length - random.length, random.length);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(random, 0, random.length);
        baos.write(input, 0, input.length);
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(hmacSecret, "HmacSHA1"));
            byte[] hash = mac.doFinal(baos.toByteArray());
            System.arraycopy(hash, 0, iv, 0, iv.length - random.length);
            return CryptoHelper.symmetricEncryptWithIV(input, key, iv);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new CryptoException("NetFilterEncryption was unable to decrypt packet", e);
        }
    }

    static {
        try {
            if (Utils.getOSType() == EOSType.AndroidUnknown) {
                Class<?> provider = Class.forName("org.spongycastle.jce.provider.BouncyCastleProvider");
                Security.insertProviderAt((Provider)provider.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), 1);
                SEC_PROV = "SC";
            } else {
                Class<?> provider = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                Security.addProvider((Provider)provider.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                SEC_PROV = "BC";
            }
        }
        catch (Exception e) {
            throw new SecurityException("Couldn't create security provider", e);
        }
    }
}

