package in.dragonbra.javasteam.generated;

import in.dragonbra.javasteam.base.ISteamSerializable;
import in.dragonbra.javasteam.util.stream.BinaryReader;
import in.dragonbra.javasteam.util.stream.BinaryWriter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ChallengeData implements ISteamSerializable {

    public static final int CHALLENGE_MASK = 0xA426DF2B;

    private int challengeValue = 0;

    private int serverLoad = 0;

    public int getChallengeValue() {
        return this.challengeValue;
    }

    public void setChallengeValue(int challengeValue) {
        this.challengeValue = challengeValue;
    }

    public int getServerLoad() {
        return this.serverLoad;
    }

    public void setServerLoad(int serverLoad) {
        this.serverLoad = serverLoad;
    }

    @Override
    public void serialize(OutputStream stream) throws IOException {
        try (var bw = new BinaryWriter(stream)) {
            bw.writeInt(challengeValue);
            bw.writeInt(serverLoad);
        }
    }

    @Override
    public void deserialize(InputStream stream) throws IOException {
        try (var br = new BinaryReader(stream)) {
            challengeValue = br.readInt();
            serverLoad = br.readInt();
        }
    }
}
