package `in`.dragonbra.javasteam.rpc.service

import `in`.dragonbra.javasteam.base.PacketClientMsgProtobuf
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesCloudSteamclient.CCloud_AppCloudStateChange_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesCloudSteamclient.CCloud_ClientLogUploadRequest_Notification
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.SteamUnifiedMessages
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.UnifiedService
import kotlin.String
import kotlin.Suppress

/**
 * This class is auto-generated
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public class CloudClient : UnifiedService {
  override val serviceName: String
    get() = "CloudClient"

  public constructor(unifiedMessages: SteamUnifiedMessages) : super(unifiedMessages)

  override fun handleResponseMsg(methodName: String, packetMsg: PacketClientMsgProtobuf) {
  }

  override fun handleNotificationMsg(methodName: String, packetMsg: PacketClientMsgProtobuf) {
    when (methodName) {
      "NotifyAppStateChange" -> postNotificationMsg<CCloud_AppCloudStateChange_Notification.Builder>(
          CCloud_AppCloudStateChange_Notification::class.java,
          packetMsg
          )
      "ClientLogUploadRequest" -> postNotificationMsg<CCloud_ClientLogUploadRequest_Notification.Builder>(
          CCloud_ClientLogUploadRequest_Notification::class.java,
          packetMsg
          )
    }
  }

  /**
   * @param request The request.
   * @see [CCloud_AppCloudStateChange_Notification]
   * @returns [AsyncJobSingle]<[ServiceMethodResponse]<[NoResponse]>>
   */
  public fun notifyAppStateChange(request: CCloud_AppCloudStateChange_Notification) {
    unifiedMessages!!.sendNotification<CCloud_AppCloudStateChange_Notification.Builder>(
        "CloudClient.NotifyAppStateChange#1",
        request
        )
  }

  /**
   * @param request The request.
   * @see [CCloud_ClientLogUploadRequest_Notification]
   * @returns [AsyncJobSingle]<[ServiceMethodResponse]<[NoResponse]>>
   */
  public fun clientLogUploadRequest(request: CCloud_ClientLogUploadRequest_Notification) {
    unifiedMessages!!.sendNotification<CCloud_ClientLogUploadRequest_Notification.Builder>(
        "CloudClient.ClientLogUploadRequest#1",
        request
        )
  }
}
