package `in`.dragonbra.javasteam.rpc.service

import `in`.dragonbra.javasteam.base.PacketClientMsgProtobuf
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_AllocateRelayServer_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_AllocateRelayServer_Response
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_AllocateSDR_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_AllocateSDR_Response
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_CreateRemotePlayTogetherInvitation_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_CreateRemotePlayTogetherInvitation_Response
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_DeleteRemotePlayTogetherInvitation_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_DeleteRemotePlayTogetherInvitation_Response
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_GetPairingInfo_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_GetPairingInfo_Response
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_GetRecentClients_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_GetRecentClients_Response
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_MarkTaskComplete_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_MarkTaskComplete_Response
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_Online_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_ReplyPacket_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_SteamBroadcast_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_SteamToSteam_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemotePlayTogether_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemotePlay_SessionStarted_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemotePlay_SessionStarted_Response
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemotePlay_SessionStopped_Notification
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.SteamUnifiedMessages
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.UnifiedService
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse
import `in`.dragonbra.javasteam.types.AsyncJobSingle
import kotlin.String
import kotlin.Suppress

/**
 * This class is auto-generated
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public class RemoteClient : UnifiedService {
  override val serviceName: String
    get() = "RemoteClient"

  public constructor(unifiedMessages: SteamUnifiedMessages) : super(unifiedMessages)

  override fun handleResponseMsg(methodName: String, packetMsg: PacketClientMsgProtobuf) {
    when (methodName) {
      "GetPairingInfo" -> postResponseMsg<CRemoteClient_GetPairingInfo_Response.Builder>(
          CRemoteClient_GetPairingInfo_Response::class.java,
          packetMsg
          )
      "GetRecentClients" -> postResponseMsg<CRemoteClient_GetRecentClients_Response.Builder>(
          CRemoteClient_GetRecentClients_Response::class.java,
          packetMsg
          )
      "MarkTaskComplete" -> postResponseMsg<CRemoteClient_MarkTaskComplete_Response.Builder>(
          CRemoteClient_MarkTaskComplete_Response::class.java,
          packetMsg
          )
      "AllocateRelayServer" -> postResponseMsg<CRemoteClient_AllocateRelayServer_Response.Builder>(
          CRemoteClient_AllocateRelayServer_Response::class.java,
          packetMsg
          )
      "AllocateSDR" -> postResponseMsg<CRemoteClient_AllocateSDR_Response.Builder>(
          CRemoteClient_AllocateSDR_Response::class.java,
          packetMsg
          )
      "SendRemotePlaySessionStarted" -> postResponseMsg<CRemotePlay_SessionStarted_Response.Builder>(
          CRemotePlay_SessionStarted_Response::class.java,
          packetMsg
          )
      "CreateRemotePlayTogetherInvitation" -> postResponseMsg<CRemoteClient_CreateRemotePlayTogetherInvitation_Response.Builder>(
          CRemoteClient_CreateRemotePlayTogetherInvitation_Response::class.java,
          packetMsg
          )
      "DeleteRemotePlayTogetherInvitation" -> postResponseMsg<CRemoteClient_DeleteRemotePlayTogetherInvitation_Response.Builder>(
          CRemoteClient_DeleteRemotePlayTogetherInvitation_Response::class.java,
          packetMsg
          )
    }
  }

  override fun handleNotificationMsg(methodName: String, packetMsg: PacketClientMsgProtobuf) {
    when (methodName) {
      "NotifyOnline" -> postNotificationMsg<CRemoteClient_Online_Notification.Builder>(
          CRemoteClient_Online_Notification::class.java,
          packetMsg
          )
      "NotifyReplyPacket" -> postNotificationMsg<CRemoteClient_ReplyPacket_Notification.Builder>(
          CRemoteClient_ReplyPacket_Notification::class.java,
          packetMsg
          )
      "SendSteamBroadcastPacket" -> postNotificationMsg<CRemoteClient_SteamBroadcast_Notification.Builder>(
          CRemoteClient_SteamBroadcast_Notification::class.java,
          packetMsg
          )
      "SendSteamToSteamPacket" -> postNotificationMsg<CRemoteClient_SteamToSteam_Notification.Builder>(
          CRemoteClient_SteamToSteam_Notification::class.java,
          packetMsg
          )
      "SendRemotePlaySessionStopped" -> postNotificationMsg<CRemotePlay_SessionStopped_Notification.Builder>(
          CRemotePlay_SessionStopped_Notification::class.java,
          packetMsg
          )
      "SendRemotePlayTogetherPacket" -> postNotificationMsg<CRemotePlayTogether_Notification.Builder>(
          CRemotePlayTogether_Notification::class.java,
          packetMsg
          )
    }
  }

  /**
   * @param request The request.
   * @see [CRemoteClient_GetPairingInfo_Request]
   * @returns [AsyncJobSingle]<[ServiceMethodResponse]<[CRemoteClient_GetPairingInfo_Response]>>
   */
  public fun getPairingInfo(request: CRemoteClient_GetPairingInfo_Request): AsyncJobSingle<ServiceMethodResponse<SteammessagesRemoteclientServiceMessages.CRemoteClient_GetPairingInfo_Response.Builder>> = unifiedMessages!!.sendMessage(
  CRemoteClient_GetPairingInfo_Response.Builder::class.java,
  "RemoteClient.GetPairingInfo#1",
  request
  )

  /**
   * @param request The request.
   * @see [CRemoteClient_Online_Notification]
   * @returns [AsyncJobSingle]<[ServiceMethodResponse]<[NoResponse]>>
   */
  public fun notifyOnline(request: CRemoteClient_Online_Notification) {
    unifiedMessages!!.sendNotification<CRemoteClient_Online_Notification.Builder>(
        "RemoteClient.NotifyOnline#1",
        request
        )
  }

  /**
   * @param request The request.
   * @see [CRemoteClient_GetRecentClients_Request]
   * @returns [AsyncJobSingle]<[ServiceMethodResponse]<[CRemoteClient_GetRecentClients_Response]>>
   */
  public fun getRecentClients(request: CRemoteClient_GetRecentClients_Request): AsyncJobSingle<ServiceMethodResponse<SteammessagesRemoteclientServiceMessages.CRemoteClient_GetRecentClients_Response.Builder>> = unifiedMessages!!.sendMessage(
  CRemoteClient_GetRecentClients_Response.Builder::class.java,
  "RemoteClient.GetRecentClients#1",
  request
  )

  /**
   * @param request The request.
   * @see [CRemoteClient_MarkTaskComplete_Request]
   * @returns [AsyncJobSingle]<[ServiceMethodResponse]<[CRemoteClient_MarkTaskComplete_Response]>>
   */
  public fun markTaskComplete(request: CRemoteClient_MarkTaskComplete_Request): AsyncJobSingle<ServiceMethodResponse<SteammessagesRemoteclientServiceMessages.CRemoteClient_MarkTaskComplete_Response.Builder>> = unifiedMessages!!.sendMessage(
  CRemoteClient_MarkTaskComplete_Response.Builder::class.java,
  "RemoteClient.MarkTaskComplete#1",
  request
  )

  /**
   * @param request The request.
   * @see [CRemoteClient_ReplyPacket_Notification]
   * @returns [AsyncJobSingle]<[ServiceMethodResponse]<[NoResponse]>>
   */
  public fun notifyReplyPacket(request: CRemoteClient_ReplyPacket_Notification) {
    unifiedMessages!!.sendNotification<CRemoteClient_ReplyPacket_Notification.Builder>(
        "RemoteClient.NotifyReplyPacket#1",
        request
        )
  }

  /**
   * @param request The request.
   * @see [CRemoteClient_AllocateRelayServer_Request]
   * @returns [AsyncJobSingle]<[ServiceMethodResponse]<[CRemoteClient_AllocateRelayServer_Response]>>
   */
  public fun allocateRelayServer(request: CRemoteClient_AllocateRelayServer_Request): AsyncJobSingle<ServiceMethodResponse<SteammessagesRemoteclientServiceMessages.CRemoteClient_AllocateRelayServer_Response.Builder>> = unifiedMessages!!.sendMessage(
  CRemoteClient_AllocateRelayServer_Response.Builder::class.java,
  "RemoteClient.AllocateRelayServer#1",
  request
  )

  /**
   * @param request The request.
   * @see [CRemoteClient_AllocateSDR_Request]
   * @returns [AsyncJobSingle]<[ServiceMethodResponse]<[CRemoteClient_AllocateSDR_Response]>>
   */
  public fun allocateSDR(request: CRemoteClient_AllocateSDR_Request): AsyncJobSingle<ServiceMethodResponse<SteammessagesRemoteclientServiceMessages.CRemoteClient_AllocateSDR_Response.Builder>> = unifiedMessages!!.sendMessage(
  CRemoteClient_AllocateSDR_Response.Builder::class.java,
  "RemoteClient.AllocateSDR#1",
  request
  )

  /**
   * @param request The request.
   * @see [CRemoteClient_SteamBroadcast_Notification]
   * @returns [AsyncJobSingle]<[ServiceMethodResponse]<[NoResponse]>>
   */
  public fun sendSteamBroadcastPacket(request: CRemoteClient_SteamBroadcast_Notification) {
    unifiedMessages!!.sendNotification<CRemoteClient_SteamBroadcast_Notification.Builder>(
        "RemoteClient.SendSteamBroadcastPacket#1",
        request
        )
  }

  /**
   * @param request The request.
   * @see [CRemoteClient_SteamToSteam_Notification]
   * @returns [AsyncJobSingle]<[ServiceMethodResponse]<[NoResponse]>>
   */
  public fun sendSteamToSteamPacket(request: CRemoteClient_SteamToSteam_Notification) {
    unifiedMessages!!.sendNotification<CRemoteClient_SteamToSteam_Notification.Builder>(
        "RemoteClient.SendSteamToSteamPacket#1",
        request
        )
  }

  /**
   * @param request The request.
   * @see [CRemotePlay_SessionStarted_Request]
   * @returns [AsyncJobSingle]<[ServiceMethodResponse]<[CRemotePlay_SessionStarted_Response]>>
   */
  public fun sendRemotePlaySessionStarted(request: CRemotePlay_SessionStarted_Request): AsyncJobSingle<ServiceMethodResponse<SteammessagesRemoteclientServiceMessages.CRemotePlay_SessionStarted_Response.Builder>> = unifiedMessages!!.sendMessage(
  CRemotePlay_SessionStarted_Response.Builder::class.java,
  "RemoteClient.SendRemotePlaySessionStarted#1",
  request
  )

  /**
   * @param request The request.
   * @see [CRemotePlay_SessionStopped_Notification]
   * @returns [AsyncJobSingle]<[ServiceMethodResponse]<[NoResponse]>>
   */
  public fun sendRemotePlaySessionStopped(request: CRemotePlay_SessionStopped_Notification) {
    unifiedMessages!!.sendNotification<CRemotePlay_SessionStopped_Notification.Builder>(
        "RemoteClient.SendRemotePlaySessionStopped#1",
        request
        )
  }

  /**
   * @param request The request.
   * @see [CRemotePlayTogether_Notification]
   * @returns [AsyncJobSingle]<[ServiceMethodResponse]<[NoResponse]>>
   */
  public fun sendRemotePlayTogetherPacket(request: CRemotePlayTogether_Notification) {
    unifiedMessages!!.sendNotification<CRemotePlayTogether_Notification.Builder>(
        "RemoteClient.SendRemotePlayTogetherPacket#1",
        request
        )
  }

  /**
   * @param request The request.
   * @see [CRemoteClient_CreateRemotePlayTogetherInvitation_Request]
   * @returns [AsyncJobSingle]<[ServiceMethodResponse]<[CRemoteClient_CreateRemotePlayTogetherInvitation_Response]>>
   */
  public fun createRemotePlayTogetherInvitation(request: CRemoteClient_CreateRemotePlayTogetherInvitation_Request): AsyncJobSingle<ServiceMethodResponse<SteammessagesRemoteclientServiceMessages.CRemoteClient_CreateRemotePlayTogetherInvitation_Response.Builder>> = unifiedMessages!!.sendMessage(
  CRemoteClient_CreateRemotePlayTogetherInvitation_Response.Builder::class.java,
  "RemoteClient.CreateRemotePlayTogetherInvitation#1",
  request
  )

  /**
   * @param request The request.
   * @see [CRemoteClient_DeleteRemotePlayTogetherInvitation_Request]
   * @returns [AsyncJobSingle]<[ServiceMethodResponse]<[CRemoteClient_DeleteRemotePlayTogetherInvitation_Response]>>
   */
  public fun deleteRemotePlayTogetherInvitation(request: CRemoteClient_DeleteRemotePlayTogetherInvitation_Request): AsyncJobSingle<ServiceMethodResponse<SteammessagesRemoteclientServiceMessages.CRemoteClient_DeleteRemotePlayTogetherInvitation_Response.Builder>> = unifiedMessages!!.sendMessage(
  CRemoteClient_DeleteRemotePlayTogetherInvitation_Response.Builder::class.java,
  "RemoteClient.DeleteRemotePlayTogetherInvitation#1",
  request
  )
}
