/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.base;

import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.base.MsgBase;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.generated.MsgHdrProtoBuf;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesBase;
import in.dragonbra.javasteam.types.JobID;
import in.dragonbra.javasteam.types.SteamID;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class AClientMsgProtobuf
extends MsgBase<MsgHdrProtoBuf> {
    private static final Logger logger = LogManager.getLogger(AClientMsgProtobuf.class);

    public AClientMsgProtobuf(IPacketMsg msg) {
        this(msg.getMsgType());
        if (!msg.isProto()) {
            logger.debug("ClientMsgProtobuf used for non-proto message!");
        }
        this.deserialize(msg.getData());
    }

    private AClientMsgProtobuf() {
        this(0);
    }

    AClientMsgProtobuf(int payloadReserve) {
        super(MsgHdrProtoBuf.class, payloadReserve);
    }

    private AClientMsgProtobuf(EMsg eMsg) {
        this(eMsg, 0);
    }

    private AClientMsgProtobuf(EMsg eMsg, int payloadReserve) {
        super(MsgHdrProtoBuf.class, payloadReserve);
        ((MsgHdrProtoBuf)this.getHeader()).setEMsg(eMsg);
    }

    public SteammessagesBase.CMsgProtoBufHeader.Builder getProtoHeader() {
        return ((MsgHdrProtoBuf)this.getHeader()).getProto();
    }

    @Override
    public boolean isProto() {
        return true;
    }

    @Override
    public EMsg getMsgType() {
        return ((MsgHdrProtoBuf)this.getHeader()).getMsg();
    }

    @Override
    public int getSessionID() {
        return this.getProtoHeader().getClientSessionid();
    }

    @Override
    public void setSessionID(int sessionID) {
        this.getProtoHeader().setClientSessionid(sessionID);
    }

    @Override
    public SteamID getSteamID() {
        return new SteamID(this.getProtoHeader().getSteamid());
    }

    @Override
    public void setSteamID(SteamID steamID) {
        if (steamID == null) {
            throw new IllegalArgumentException("steamID is null");
        }
        this.getProtoHeader().setSteamid(steamID.convertToUInt64());
    }

    @Override
    public JobID getTargetJobID() {
        return new JobID(this.getProtoHeader().getJobidTarget());
    }

    @Override
    public void setTargetJobID(JobID jobID) {
        if (jobID == null) {
            throw new IllegalArgumentException("jobID is null");
        }
        this.getProtoHeader().setJobidTarget(jobID.getValue());
    }

    @Override
    public JobID getSourceJobID() {
        return new JobID(this.getProtoHeader().getJobidSource());
    }

    @Override
    public void setSourceJobID(JobID jobID) {
        if (jobID == null) {
            throw new IllegalArgumentException("jobID is null");
        }
        this.getProtoHeader().setJobidSource(jobID.getValue());
    }

    @Override
    public byte[] serialize() {
        throw new UnsupportedOperationException("ClientMsgProtobuf is for reading only. Use ClientMsgProtobuf<T> for serializing messages.");
    }

    @Override
    public void deserialize(byte[] data) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
            ((MsgHdrProtoBuf)this.getHeader()).deserialize(bais);
        }
        catch (IOException e) {
            logger.debug(e);
        }
    }
}

