/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.base;

import in.dragonbra.javasteam.util.stream.BinaryReader;
import in.dragonbra.javasteam.util.stream.BinaryWriter;
import in.dragonbra.javasteam.util.stream.MemoryStream;
import in.dragonbra.javasteam.util.stream.SeekOrigin;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public abstract class AbstractMsgBase {
    protected MemoryStream payload;
    private final BinaryReader reader;
    private final BinaryWriter writer;

    public AbstractMsgBase() {
        this(0);
    }

    public AbstractMsgBase(int payloadReserve) {
        this.payload = new MemoryStream(payloadReserve);
        this.reader = new BinaryReader(this.payload);
        this.writer = new BinaryWriter(this.payload.asOutputStream());
    }

    public long seek(long offset, SeekOrigin seekOrigin) {
        return this.payload.seek(offset, seekOrigin);
    }

    public void writeByte(byte data) throws IOException {
        this.writer.write(data);
    }

    public byte readByte() throws IOException {
        return this.reader.readByte();
    }

    public void writeBytes(byte[] data) throws IOException {
        this.writer.write(data);
    }

    public byte[] readBytes(int numBytes) throws IOException {
        return this.reader.readBytes(numBytes);
    }

    public void writeShort(short data) throws IOException {
        this.writer.writeShort(data);
    }

    public short readShort() throws IOException {
        return this.reader.readShort();
    }

    public void writeInt(int data) throws IOException {
        this.writer.writeInt(data);
    }

    public int readInt() throws IOException {
        return this.reader.readInt();
    }

    public void writeLong(long data) throws IOException {
        this.writer.writeLong(data);
    }

    public long readLong() throws IOException {
        return this.reader.readLong();
    }

    public void writeFloat(float data) throws IOException {
        this.writer.writeFloat(data);
    }

    public float readFloat() throws IOException {
        return this.reader.readFloat();
    }

    public void writeDouble(double data) throws IOException {
        this.writer.writeDouble(data);
    }

    public double readDouble() throws IOException {
        return this.reader.readDouble();
    }

    public void writeString(String data) throws IOException {
        this.writeString(data, StandardCharsets.UTF_8);
    }

    public void writeString(String data, Charset charset) throws IOException {
        if (data == null) {
            return;
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset is null");
        }
        this.writeBytes(data.getBytes(charset));
    }

    public void writeNullTermString(String data) throws IOException {
        this.writeNullTermString(data, StandardCharsets.UTF_8);
    }

    public void writeNullTermString(String data, Charset charset) throws IOException {
        this.writeString(data, charset);
        this.writeString("\u0000", charset);
    }

    public String readNullTermString() throws IOException {
        return this.readNullTermString(StandardCharsets.UTF_8);
    }

    public String readNullTermString(Charset charset) throws IOException {
        return this.reader.readNullTermString(charset);
    }

    public MemoryStream getPayload() {
        return this.payload;
    }
}

