/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.base;

import in.dragonbra.javasteam.base.GCMsgBase;
import in.dragonbra.javasteam.base.IGCSerializableMessage;
import in.dragonbra.javasteam.base.IPacketGCMsg;
import in.dragonbra.javasteam.generated.MsgGCHdr;
import in.dragonbra.javasteam.types.JobID;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import in.dragonbra.javasteam.util.stream.MemoryStream;
import in.dragonbra.javasteam.util.stream.SeekOrigin;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public class ClientGCMsg<BodyType extends IGCSerializableMessage>
extends GCMsgBase<MsgGCHdr> {
    private static final Logger logger = LogManager.getLogger(ClientGCMsg.class);
    private final int msgType;
    private BodyType body;

    public ClientGCMsg(Class<? extends BodyType> bodyType) {
        this(bodyType, 64);
    }

    public ClientGCMsg(Class<? extends BodyType> bodyType, int payloadReserve) {
        super(MsgGCHdr.class, payloadReserve);
        try {
            this.body = (IGCSerializableMessage)bodyType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.debug(e);
        }
        this.msgType = this.body.getEMsg();
    }

    public ClientGCMsg(Class<? extends BodyType> bodyType, GCMsgBase<MsgGCHdr> msg) {
        this(bodyType, msg, 64);
    }

    public ClientGCMsg(Class<? extends BodyType> bodyType, GCMsgBase<MsgGCHdr> msg, int payloadReserve) {
        this((Class<BodyType>)bodyType, payloadReserve);
        if (msg == null) {
            throw new IllegalArgumentException("msg is null");
        }
        ((MsgGCHdr)this.getHeader()).setTargetJobID(msg.getHeader().getSourceJobID());
    }

    public ClientGCMsg(Class<? extends BodyType> bodyType, IPacketGCMsg msg) {
        this(bodyType);
        if (msg == null) {
            throw new IllegalArgumentException("msg is null");
        }
        if (msg.isProto()) {
            logger.debug("ClientMsg<" + bodyType.getName() + "> used for proto message!");
        }
        this.deserialize(msg.getData());
    }

    @Override
    public boolean isProto() {
        return false;
    }

    @Override
    public int getMsgType() {
        return this.msgType;
    }

    @Override
    public JobID getTargetJobID() {
        return new JobID(((MsgGCHdr)this.getHeader()).getTargetJobID());
    }

    @Override
    public void setTargetJobID(JobID jobID) {
        if (jobID == null) {
            throw new IllegalArgumentException("jobID is null");
        }
        ((MsgGCHdr)this.getHeader()).setTargetJobID(jobID.getValue());
    }

    @Override
    public JobID getSourceJobID() {
        return new JobID(((MsgGCHdr)this.getHeader()).getSourceJobID());
    }

    @Override
    public void setSourceJobID(JobID jobID) {
        if (jobID == null) {
            throw new IllegalArgumentException("jobID is null");
        }
        ((MsgGCHdr)this.getHeader()).setSourceJobID(jobID.getValue());
    }

    @Override
    public byte[] serialize() {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(0);
        try {
            ((MsgGCHdr)this.getHeader()).serialize(baos);
            this.body.serialize(baos);
            baos.write(this.payload.toByteArray());
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.debug(e);
                return new byte[0];
            }
        }
        baos.close();
        return byArray;
    }

    @Override
    public void deserialize(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data is null");
        }
        MemoryStream ms = new MemoryStream(data);
        try {
            ((MsgGCHdr)this.getHeader()).deserialize(ms);
            this.body.deserialize(ms);
        }
        catch (IOException e) {
            logger.debug(e);
        }
        this.payload.write(data, (int)ms.getPosition(), ms.available());
        this.payload.seek(0L, SeekOrigin.BEGIN);
        ms.close();
    }
}

