/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.enums;

import java.util.EnumSet;

public enum EAccountFlags {
    NormalUser(0),
    PersonaNameSet(1),
    Unbannable(2),
    PasswordSet(4),
    Support(8),
    Admin(16),
    Supervisor(32),
    AppEditor(64),
    HWIDSet(128),
    PersonalQASet(256),
    VacBeta(512),
    Debug(1024),
    Disabled(2048),
    LimitedUser(4096),
    LimitedUserForce(8192),
    EmailValidated(16384),
    MarketingTreatment(32768),
    OGGInviteOptOut(65536),
    ForcePasswordChange(131072),
    ForceEmailVerification(262144),
    LogonExtraSecurity(524288),
    LogonExtraSecurityDisabled(0x100000),
    Steam2MigrationComplete(0x200000),
    NeedLogs(0x400000),
    Lockdown(0x800000),
    MasterAppEditor(0x1000000),
    BannedFromWebAPI(0x2000000),
    PartnerMember(0x4000000),
    GlobalModerator(0x8000000),
    ParentalSettings(0x10000000),
    ThirdPartySupport(0x20000000),
    NeedsSSANextSteamLogon(0x40000000);

    private final int code;

    private EAccountFlags(int code) {
        this.code = code;
    }

    public int code() {
        return this.code;
    }

    public static EnumSet<EAccountFlags> from(int code) {
        EnumSet<EAccountFlags> set = EnumSet.noneOf(EAccountFlags.class);
        for (EAccountFlags e : EAccountFlags.values()) {
            if ((e.code & code) != e.code) continue;
            set.add(e);
        }
        return set;
    }

    public static int code(EnumSet<EAccountFlags> flags) {
        int code = 0;
        for (EAccountFlags flag : flags) {
            code |= flag.code;
        }
        return code;
    }
}

