/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.generated;

import in.dragonbra.javasteam.base.ISteamSerializable;
import in.dragonbra.javasteam.enums.EUdpPacketType;
import in.dragonbra.javasteam.util.stream.BinaryReader;
import in.dragonbra.javasteam.util.stream.BinaryWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class UdpHeader
implements ISteamSerializable {
    public static final int MAGIC = 825250646;
    private int magic = 825250646;
    private short payloadSize = 0;
    private EUdpPacketType packetType = EUdpPacketType.Invalid;
    private byte flags = 0;
    private int sourceConnID = 512;
    private int destConnID = 0;
    private int seqThis = 0;
    private int seqAck = 0;
    private int packetsInMsg = 0;
    private int msgStartSeq = 0;
    private int msgSize = 0;

    public int getMagic() {
        return this.magic;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public short getPayloadSize() {
        return this.payloadSize;
    }

    public void setPayloadSize(short payloadSize) {
        this.payloadSize = payloadSize;
    }

    public EUdpPacketType getPacketType() {
        return this.packetType;
    }

    public void setPacketType(EUdpPacketType packetType) {
        this.packetType = packetType;
    }

    public byte getFlags() {
        return this.flags;
    }

    public void setFlags(byte flags) {
        this.flags = flags;
    }

    public int getSourceConnID() {
        return this.sourceConnID;
    }

    public void setSourceConnID(int sourceConnID) {
        this.sourceConnID = sourceConnID;
    }

    public int getDestConnID() {
        return this.destConnID;
    }

    public void setDestConnID(int destConnID) {
        this.destConnID = destConnID;
    }

    public int getSeqThis() {
        return this.seqThis;
    }

    public void setSeqThis(int seqThis) {
        this.seqThis = seqThis;
    }

    public int getSeqAck() {
        return this.seqAck;
    }

    public void setSeqAck(int seqAck) {
        this.seqAck = seqAck;
    }

    public int getPacketsInMsg() {
        return this.packetsInMsg;
    }

    public void setPacketsInMsg(int packetsInMsg) {
        this.packetsInMsg = packetsInMsg;
    }

    public int getMsgStartSeq() {
        return this.msgStartSeq;
    }

    public void setMsgStartSeq(int msgStartSeq) {
        this.msgStartSeq = msgStartSeq;
    }

    public int getMsgSize() {
        return this.msgSize;
    }

    public void setMsgSize(int msgSize) {
        this.msgSize = msgSize;
    }

    @Override
    public void serialize(OutputStream stream) throws IOException {
        try (BinaryWriter bw = new BinaryWriter(stream);){
            bw.writeInt(this.magic);
            bw.writeShort(this.payloadSize);
            bw.writeByte(this.packetType.code());
            bw.writeByte(this.flags);
            bw.writeInt(this.sourceConnID);
            bw.writeInt(this.destConnID);
            bw.writeInt(this.seqThis);
            bw.writeInt(this.seqAck);
            bw.writeInt(this.packetsInMsg);
            bw.writeInt(this.msgStartSeq);
            bw.writeInt(this.msgSize);
        }
    }

    @Override
    public void deserialize(InputStream stream) throws IOException {
        try (BinaryReader br = new BinaryReader(stream);){
            this.magic = br.readInt();
            this.payloadSize = br.readShort();
            this.packetType = EUdpPacketType.from(br.readByte());
            this.flags = br.readByte();
            this.sourceConnID = br.readInt();
            this.destConnID = br.readInt();
            this.seqThis = br.readInt();
            this.seqAck = br.readInt();
            this.packetsInMsg = br.readInt();
            this.msgStartSeq = br.readInt();
            this.msgSize = br.readInt();
        }
    }
}

