/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.networking.steam3;

import in.dragonbra.javasteam.networking.steam3.Connection;
import in.dragonbra.javasteam.networking.steam3.EnvelopeEncryptedConnection;
import in.dragonbra.javasteam.networking.steam3.ProtocolTypes;
import in.dragonbra.javasteam.networking.steam3.TcpConnection;
import in.dragonbra.javasteam.networking.steam3.UdpConnection;
import in.dragonbra.javasteam.networking.steam3.WebSocketConnection;
import in.dragonbra.javasteam.steam.steamclient.configuration.SteamConfiguration;
import java.util.EnumSet;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface IConnectionFactory {
    public static final IConnectionFactory DEFAULT = (configuration, protocol) -> {
        if (protocol.contains((Object)ProtocolTypes.WEB_SOCKET)) {
            return new WebSocketConnection();
        }
        if (protocol.contains((Object)ProtocolTypes.TCP)) {
            return new EnvelopeEncryptedConnection(new TcpConnection(), configuration.getUniverse());
        }
        if (protocol.contains((Object)ProtocolTypes.UDP)) {
            return new EnvelopeEncryptedConnection(new UdpConnection(), configuration.getUniverse());
        }
        return null;
    };

    @Nullable
    public Connection createConnection(SteamConfiguration var1, EnumSet<ProtocolTypes> var2);

    default public IConnectionFactory thenResolve(IConnectionFactory subConnectionFactory) {
        Objects.requireNonNull(subConnectionFactory);
        return (configuration, protocol) -> {
            Connection connection = this.createConnection(configuration, protocol);
            if (connection == null) {
                return subConnectionFactory.createConnection(configuration, protocol);
            }
            return connection;
        };
    }
}

