/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.networking.steam3;

import java.util.EnumSet;

public enum ProtocolTypes {
    TCP(1),
    UDP(2),
    WEB_SOCKET(4);

    public static final EnumSet<ProtocolTypes> ALL;
    private final int code;

    private ProtocolTypes(int code) {
        this.code = code;
    }

    public int code() {
        return this.code;
    }

    public static EnumSet<ProtocolTypes> from(int code) {
        EnumSet<ProtocolTypes> set = EnumSet.noneOf(ProtocolTypes.class);
        for (ProtocolTypes e : ProtocolTypes.values()) {
            if ((e.code & code) != e.code) continue;
            set.add(e);
        }
        return set;
    }

    public static int code(EnumSet<ProtocolTypes> flags) {
        int code = 0;
        for (ProtocolTypes flag : flags) {
            code |= flag.code;
        }
        return code;
    }

    static {
        ALL = EnumSet.of(TCP, UDP, WEB_SOCKET);
    }
}

