/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.networking.steam3;

import in.dragonbra.javasteam.networking.steam3.Connection;
import in.dragonbra.javasteam.networking.steam3.NetMsgEventArgs;
import in.dragonbra.javasteam.networking.steam3.ProtocolTypes;
import in.dragonbra.javasteam.util.NetHelpers;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import in.dragonbra.javasteam.util.stream.BinaryReader;
import in.dragonbra.javasteam.util.stream.BinaryWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

public class TcpConnection
extends Connection {
    private static final Logger logger = LogManager.getLogger(TcpConnection.class);
    private static final int MAGIC = 825250902;
    private Socket socket;
    private InetSocketAddress currentEndPoint;
    private BinaryWriter netWriter;
    private BinaryReader netReader;
    private Thread netThread;
    private NetLoop netLoop;
    private final Object netLock = new Object();

    private void shutdown() {
        try {
            if (this.socket.isConnected()) {
                this.socket.shutdownInput();
                this.socket.shutdownOutput();
            }
        }
        catch (IOException e) {
            logger.debug(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionCompleted(boolean success) {
        if (!success) {
            logger.debug("Timed out while connecting to " + String.valueOf(this.currentEndPoint));
            this.release(false);
            return;
        }
        logger.debug("Connected to " + String.valueOf(this.currentEndPoint));
        try {
            Object object = this.netLock;
            synchronized (object) {
                this.netReader = new BinaryReader(this.socket.getInputStream());
                this.netWriter = new BinaryWriter(this.socket.getOutputStream());
                this.netLoop = new NetLoop();
                this.netThread = new Thread((Runnable)this.netLoop, "TcpConnection Thread");
                this.currentEndPoint = new InetSocketAddress(this.socket.getInetAddress(), this.socket.getPort());
            }
            this.netThread.start();
            this.onConnected();
        }
        catch (IOException e) {
            logger.debug("Exception while setting up connection to " + String.valueOf(this.currentEndPoint), e);
            this.release(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(boolean userRequestedDisconnect) {
        Object object = this.netLock;
        synchronized (object) {
            if (this.netWriter != null) {
                try {
                    this.netWriter.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.netWriter = null;
            }
            if (this.netReader != null) {
                try {
                    this.netReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.netReader = null;
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.socket = null;
            }
        }
        this.onDisconnected(userRequestedDisconnect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(InetSocketAddress endPoint, int timeout) {
        Object object = this.netLock;
        synchronized (object) {
            this.currentEndPoint = endPoint;
            try {
                logger.debug("Connecting to " + String.valueOf(this.currentEndPoint) + "...");
                this.socket = new Socket();
                this.socket.connect(endPoint, timeout);
                this.connectionCompleted(true);
            }
            catch (IOException e) {
                logger.debug("Socket exception while completing connection request to " + String.valueOf(this.currentEndPoint), e);
                this.connectionCompleted(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(boolean userInitiated) {
        Object object = this.netLock;
        synchronized (object) {
            if (this.netLoop != null) {
                this.netLoop.stop(userInitiated);
            }
        }
    }

    private byte[] readPacket() throws IOException {
        int packetLen = this.netReader.readInt();
        int packetMagic = this.netReader.readInt();
        if (packetMagic != 825250902) {
            throw new IOException("Got a packet with invalid magic!");
        }
        return this.netReader.readBytes(packetLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(byte[] data) {
        Object object = this.netLock;
        synchronized (object) {
            block6: {
                if (this.socket == null) {
                    logger.debug("Attempting to send client data when not connected.");
                    return;
                }
                try {
                    this.netWriter.writeInt(data.length);
                    this.netWriter.writeInt(825250902);
                    this.netWriter.write(data);
                }
                catch (IOException e) {
                    logger.debug("Socket exception while writing data.", e);
                    if (this.netLoop == null) break block6;
                    this.netLoop.stop(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetAddress getLocalIP() {
        Object object = this.netLock;
        synchronized (object) {
            if (this.socket == null) {
                return null;
            }
            try {
                return NetHelpers.getLocalIP(this.socket);
            }
            catch (Exception e) {
                logger.debug("Socket exception trying to read bound IP: ", e);
                return null;
            }
        }
    }

    @Override
    public InetSocketAddress getCurrentEndPoint() {
        return this.currentEndPoint;
    }

    @Override
    public ProtocolTypes getProtocolTypes() {
        return ProtocolTypes.TCP;
    }

    private class NetLoop
    implements Runnable {
        private static final int POLL_MS = 100;
        private volatile boolean cancelRequested = false;
        private volatile boolean userRequested = false;

        private NetLoop() {
        }

        void stop(boolean userRequested) {
            this.userRequested = userRequested;
            this.cancelRequested = true;
        }

        @Override
        public void run() {
            while (!this.cancelRequested) {
                boolean canRead;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    logger.debug("Thread interrupted", e);
                }
                if (this.cancelRequested) break;
                try {
                    canRead = TcpConnection.this.netReader.available() > 0;
                }
                catch (IOException e) {
                    logger.debug("Socket exception while polling", e);
                    break;
                }
                if (!canRead) continue;
                try {
                    byte[] packData = TcpConnection.this.readPacket();
                    TcpConnection.this.onNetMsgReceived(new NetMsgEventArgs(packData, TcpConnection.this.currentEndPoint));
                }
                catch (IOException e) {
                    logger.debug("Socket exception occurred while reading packet", e);
                    break;
                }
            }
            if (this.cancelRequested) {
                TcpConnection.this.shutdown();
            }
            TcpConnection.this.release(this.cancelRequested && this.userRequested);
        }
    }
}

