/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.networking.steam3;

import in.dragonbra.javasteam.enums.EUdpPacketType;
import in.dragonbra.javasteam.generated.UdpHeader;
import in.dragonbra.javasteam.util.stream.MemoryStream;
import in.dragonbra.javasteam.util.stream.SeekOrigin;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class UdpPacket {
    public static final int MAX_PAYLOAD = 1244;
    private final UdpHeader header = new UdpHeader();
    private MemoryStream payload;

    UdpPacket(MemoryStream ms) {
        try {
            this.header.deserialize(ms);
        }
        catch (IOException e) {
            return;
        }
        if (this.header.getMagic() != 825250646) {
            return;
        }
        this.setPayload(ms, this.header.getPayloadSize());
    }

    UdpPacket(EUdpPacketType type) {
        this.payload = new MemoryStream();
        this.header.setPacketType(type);
    }

    UdpPacket(EUdpPacketType type, MemoryStream payload) {
        this(type);
        this.setPayload(payload);
    }

    UdpPacket(EUdpPacketType type, MemoryStream payload, long length) {
        this(type);
        this.setPayload(payload, length);
    }

    public void setPayload(MemoryStream ms) {
        this.setPayload(ms, ms.getLength() - ms.getPosition());
    }

    public void setPayload(MemoryStream ms, long length) {
        if (length > 1244L) {
            throw new IllegalArgumentException("Payload length exceeds 0x4DC maximum");
        }
        byte[] buf = new byte[(int)length];
        ms.read(buf, 0, buf.length);
        this.payload = new MemoryStream(buf);
        this.header.setPayloadSize((short)this.payload.getLength());
        this.header.setMsgSize((int)this.payload.getLength());
    }

    public byte[] getData() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.header.serialize(baos);
            this.payload.seek(0L, SeekOrigin.BEGIN);
            baos.write(this.payload.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public boolean isValid() {
        return this.header.getMagic() == 825250646 && this.header.getPayloadSize() <= 1244 && this.payload != null;
    }

    public UdpHeader getHeader() {
        return this.header;
    }

    public MemoryStream getPayload() {
        return this.payload;
    }
}

