/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam;

import in.dragonbra.javasteam.base.ClientMsg;
import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IClientMsg;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.base.PacketClientMsg;
import in.dragonbra.javasteam.base.PacketClientMsgProtobuf;
import in.dragonbra.javasteam.base.PacketMsg;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.enums.EUniverse;
import in.dragonbra.javasteam.generated.MsgClientServerUnavailable;
import in.dragonbra.javasteam.networking.steam3.Connection;
import in.dragonbra.javasteam.networking.steam3.DisconnectedEventArgs;
import in.dragonbra.javasteam.networking.steam3.IConnectionFactory;
import in.dragonbra.javasteam.networking.steam3.NetMsgEventArgs;
import in.dragonbra.javasteam.networking.steam3.ProtocolTypes;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesBase;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverLogin;
import in.dragonbra.javasteam.steam.discovery.ServerQuality;
import in.dragonbra.javasteam.steam.discovery.ServerRecord;
import in.dragonbra.javasteam.steam.discovery.SmartCMServerList;
import in.dragonbra.javasteam.steam.steamclient.configuration.SteamConfiguration;
import in.dragonbra.javasteam.types.SteamID;
import in.dragonbra.javasteam.util.IDebugNetworkListener;
import in.dragonbra.javasteam.util.MsgUtil;
import in.dragonbra.javasteam.util.NetHelpers;
import in.dragonbra.javasteam.util.Strings;
import in.dragonbra.javasteam.util.event.EventArgs;
import in.dragonbra.javasteam.util.event.EventHandler;
import in.dragonbra.javasteam.util.event.ScheduledFunction;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import in.dragonbra.javasteam.util.stream.BinaryReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.EnumSet;
import java.util.zip.GZIPInputStream;
import org.jetbrains.annotations.Nullable;

public abstract class CMClient {
    private static final Logger logger = LogManager.getLogger(CMClient.class);
    private final SteamConfiguration configuration;
    @Nullable
    private InetAddress publicIP;
    @Nullable
    private String ipCountryCode;
    private boolean isConnected;
    private long sessionToken;
    @Nullable
    private Integer cellID;
    @Nullable
    private Integer sessionID;
    @Nullable
    private SteamID steamID;
    private IDebugNetworkListener debugNetworkListener;
    private boolean expectDisconnection;
    private final Object connectionLock = new Object();
    @Nullable
    private Connection connection;
    private final ScheduledFunction heartBeatFunc;
    private final EventHandler<NetMsgEventArgs> netMsgReceived = (sender, e) -> this.onClientMsgReceived(CMClient.getPacketMsg(e.getData()));
    private final EventHandler<EventArgs> connected = (sender, e) -> {
        logger.debug("EventHandler `connected` called");
        this.getServers().tryMark(this.connection.getCurrentEndPoint(), this.connection.getProtocolTypes(), ServerQuality.GOOD);
        this.isConnected = true;
        try {
            this.onClientConnected();
        }
        catch (Exception ex) {
            logger.error("Unhandled exception after connecting: ", ex);
            this.disconnect(false);
        }
    };
    private final EventHandler<DisconnectedEventArgs> disconnected = new EventHandler<DisconnectedEventArgs>(){

        @Override
        public void handleEvent(Object sender, DisconnectedEventArgs e) {
            logger.debug("EventHandler `disconnected` called. User Initiated: " + e.isUserInitiated() + ", Expected Disconnection: " + CMClient.this.expectDisconnection);
            CMClient.this.isConnected = false;
            if (!e.isUserInitiated() && !CMClient.this.expectDisconnection) {
                CMClient.this.getServers().tryMark(CMClient.this.connection.getCurrentEndPoint(), CMClient.this.connection.getProtocolTypes(), ServerQuality.BAD);
            }
            CMClient.this.sessionID = null;
            CMClient.this.steamID = null;
            CMClient.this.connection.getNetMsgReceived().removeEventHandler(CMClient.this.netMsgReceived);
            CMClient.this.connection.getConnected().removeEventHandler(CMClient.this.connected);
            CMClient.this.connection.getDisconnected().removeEventHandler(this);
            CMClient.this.connection = null;
            CMClient.this.heartBeatFunc.stop();
            CMClient.this.onClientDisconnected(e.isUserInitiated() || CMClient.this.expectDisconnection);
        }
    };

    public CMClient(SteamConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        this.configuration = configuration;
        this.heartBeatFunc = new ScheduledFunction(() -> {
            ClientMsgProtobuf heartbeat = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientHeartBeat.class, EMsg.ClientHeartBeat);
            ((SteammessagesClientserverLogin.CMsgClientHeartBeat.Builder)heartbeat.getBody()).setSendReply(true);
            this.send(heartbeat);
        }, 5000L);
    }

    public void receiveTestPacketMsg(IPacketMsg packetMsg) {
        this.onClientMsgReceived(packetMsg);
    }

    public void setIsConnected(boolean value) {
        this.isConnected = value;
    }

    public void connect() {
        this.connect(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ServerRecord cmServer) {
        Object object = this.connectionLock;
        synchronized (object) {
            try {
                this.disconnect(true);
                assert (this.connection == null);
                this.expectDisconnection = false;
                if (cmServer == null) {
                    cmServer = this.getServers().getNextServerCandidate(this.configuration.getProtocolTypes());
                }
                if (cmServer == null) {
                    logger.error("No CM servers available to connect to");
                    this.onClientDisconnected(false);
                    return;
                }
                this.connection = this.createConnection(cmServer.getProtocolTypes());
                this.connection.getNetMsgReceived().addEventHandler(this.netMsgReceived);
                this.connection.getConnected().addEventHandler(this.connected);
                this.connection.getDisconnected().addEventHandler(this.disconnected);
                logger.debug(String.format("Connecting to %s with protocol %s, and with connection impl %s", cmServer.getEndpoint(), cmServer.getProtocolTypes(), this.connection.getClass().getSimpleName()));
                this.connection.connect(cmServer.getEndpoint());
            }
            catch (Exception e) {
                logger.debug("Failed to connect to Steam network", e);
                this.onClientDisconnected(false);
            }
        }
    }

    public void disconnect() {
        this.disconnect(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect(boolean userInitiated) {
        Object object = this.connectionLock;
        synchronized (object) {
            this.heartBeatFunc.stop();
            if (this.connection != null) {
                this.connection.disconnect(userInitiated);
            }
        }
    }

    public void send(IClientMsg msg) {
        SteamID _steamID;
        if (msg == null) {
            throw new IllegalArgumentException("A value for 'msg' must be supplied");
        }
        Integer _sessionID = this.sessionID;
        if (_sessionID != null) {
            msg.setSessionID(_sessionID);
        }
        if ((_steamID = this.steamID) != null) {
            msg.setSteamID(_steamID);
        }
        try {
            if (this.debugNetworkListener != null) {
                this.debugNetworkListener.onOutgoingNetworkMessage(msg.getMsgType(), msg.serialize());
            }
        }
        catch (Exception e) {
            logger.debug("DebugNetworkListener threw an exception", e);
        }
        if (this.connection != null) {
            this.connection.send(msg.serialize());
        }
    }

    protected boolean onClientMsgReceived(IPacketMsg packetMsg) {
        if (packetMsg == null) {
            logger.debug("Packet message failed to parse, shutting down connection");
            this.disconnect(false);
            return false;
        }
        if (packetMsg.getMsgType() != EMsg.Multi) {
            try {
                if (this.debugNetworkListener != null) {
                    this.debugNetworkListener.onIncomingNetworkMessage(packetMsg.getMsgType(), packetMsg.getData());
                }
            }
            catch (Exception e) {
                logger.debug("debugNetworkListener threw an exception", e);
            }
        }
        switch (packetMsg.getMsgType()) {
            case Multi: {
                this.handleMulti(packetMsg);
                break;
            }
            case ClientLogOnResponse: {
                this.handleLogOnResponse(packetMsg);
                break;
            }
            case ClientLoggedOff: {
                this.handleLoggedOff(packetMsg);
                break;
            }
            case ClientServerUnavailable: {
                this.handleServerUnavailable(packetMsg);
                break;
            }
            case ClientSessionToken: {
                this.handleSessionToken(packetMsg);
            }
        }
        return true;
    }

    protected void onClientConnected() {
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientHello.class, EMsg.ClientHello);
        ((SteammessagesClientserverLogin.CMsgClientHello.Builder)request.getBody()).setProtocolVersion(65581);
        this.send(request);
    }

    protected void onClientDisconnected(boolean userInitiated) {
    }

    private Connection createConnection(EnumSet<ProtocolTypes> protocol) {
        IConnectionFactory connectionFactory = this.configuration.getConnectionFactory();
        Connection connection = connectionFactory.createConnection(this.configuration, protocol);
        if (connection == null) {
            logger.error(String.format("Connection factory returned null connection for protocols %s", protocol));
            throw new IllegalArgumentException("Connection factory returned null connection.");
        }
        return connection;
    }

    public static IPacketMsg getPacketMsg(byte[] data) {
        if (data.length < 4) {
            logger.debug("PacketMsg too small to contain a message, was only " + data.length + " bytes. Message: " + Strings.toHex(data));
            return null;
        }
        int rawEMsg = 0;
        try (BinaryReader reader = new BinaryReader(new ByteArrayInputStream(data));){
            rawEMsg = reader.readInt();
        }
        catch (IOException e) {
            logger.debug("Exception while getting EMsg code", e);
        }
        EMsg eMsg = MsgUtil.getMsg(rawEMsg);
        switch (eMsg) {
            case ChannelEncryptRequest: 
            case ChannelEncryptResponse: 
            case ChannelEncryptResult: {
                try {
                    return new PacketMsg(eMsg, data);
                }
                catch (IOException e) {
                    logger.debug("Exception deserializing emsg " + String.valueOf((Object)eMsg) + " (" + MsgUtil.isProtoBuf(rawEMsg) + ").", e);
                }
            }
        }
        try {
            if (MsgUtil.isProtoBuf(rawEMsg)) {
                return new PacketClientMsgProtobuf(eMsg, data);
            }
            return new PacketClientMsg(eMsg, data);
        }
        catch (IOException e) {
            logger.debug("Exception deserializing emsg " + String.valueOf((Object)eMsg) + " (" + MsgUtil.isProtoBuf(rawEMsg) + ").", e);
            return null;
        }
    }

    private void handleMulti(IPacketMsg packetMsg) {
        if (!packetMsg.isProto()) {
            logger.debug("HandleMulti got non-proto MsgMulti!!");
            return;
        }
        ClientMsgProtobuf msgMulti = new ClientMsgProtobuf(SteammessagesBase.CMsgMulti.class, packetMsg);
        byte[] payload = ((SteammessagesBase.CMsgMulti.Builder)msgMulti.getBody()).getMessageBody().toByteArray();
        if (((SteammessagesBase.CMsgMulti.Builder)msgMulti.getBody()).getSizeUnzipped() > 0) {
            try (GZIPInputStream gzin = new GZIPInputStream(new ByteArrayInputStream(payload));
                 ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int res = 0;
                byte[] buf = new byte[1024];
                while (res >= 0) {
                    res = gzin.read(buf, 0, buf.length);
                    if (res <= 0) continue;
                    baos.write(buf, 0, res);
                }
                payload = baos.toByteArray();
            }
            catch (IOException e) {
                logger.debug("HandleMulti encountered an exception when decompressing.", e);
                return;
            }
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(payload);
             BinaryReader br = new BinaryReader(bais);){
            while (br.available() > 0) {
                int subSize = br.readInt();
                byte[] subData = br.readBytes(subSize);
                if (this.onClientMsgReceived(CMClient.getPacketMsg(subData))) continue;
                break;
            }
        }
        catch (IOException e) {
            logger.error("error in handleMulti()", e);
        }
    }

    private void handleLogOnResponse(IPacketMsg packetMsg) {
        if (!packetMsg.isProto()) {
            logger.debug("Got non-proto logon response, this is indicative of no logon attempt after connecting.");
            return;
        }
        ClientMsgProtobuf logonResp = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientLogonResponse.class, packetMsg);
        EResult logonResponse = EResult.from(((SteammessagesClientserverLogin.CMsgClientLogonResponse.Builder)logonResp.getBody()).getEresult());
        EResult extendedResponse = EResult.from(((SteammessagesClientserverLogin.CMsgClientLogonResponse.Builder)logonResp.getBody()).getEresultExtended());
        logger.debug("handleLogOnResponse got response: " + String.valueOf((Object)logonResponse) + ", extended: " + String.valueOf((Object)extendedResponse));
        if (logonResponse == EResult.OK) {
            this.sessionID = logonResp.getProtoHeader().getClientSessionid();
            this.steamID = new SteamID(logonResp.getProtoHeader().getSteamid());
            this.cellID = ((SteammessagesClientserverLogin.CMsgClientLogonResponse.Builder)logonResp.getBody()).getCellId();
            this.publicIP = NetHelpers.getIPAddress(((SteammessagesClientserverLogin.CMsgClientLogonResponse.Builder)logonResp.getBody()).getPublicIp());
            this.ipCountryCode = ((SteammessagesClientserverLogin.CMsgClientLogonResponse.Builder)logonResp.getBody()).getIpCountryCode();
            this.heartBeatFunc.stop();
            this.heartBeatFunc.setDelay((long)((SteammessagesClientserverLogin.CMsgClientLogonResponse.Builder)logonResp.getBody()).getLegacyOutOfGameHeartbeatSeconds() * 1000L);
            this.heartBeatFunc.start();
        } else if (logonResponse == EResult.TryAnotherCM || logonResponse == EResult.ServiceUnavailable) {
            Connection connection = this.connection;
            if (connection != null) {
                this.getServers().tryMark(connection.getCurrentEndPoint(), connection.getProtocolTypes(), ServerQuality.BAD);
            } else {
                logger.error("Connection was null trying to mark endpoint bad.");
            }
        }
    }

    private void handleLoggedOff(IPacketMsg packetMsg) {
        this.sessionID = null;
        this.steamID = null;
        this.cellID = null;
        this.publicIP = null;
        this.ipCountryCode = null;
        this.heartBeatFunc.stop();
        if (packetMsg.isProto()) {
            ClientMsgProtobuf logoffMsg = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientLoggedOff.class, packetMsg);
            EResult logoffResult = EResult.from(((SteammessagesClientserverLogin.CMsgClientLoggedOff.Builder)logoffMsg.getBody()).getEresult());
            logger.debug("handleLoggedOff got " + String.valueOf((Object)logoffResult));
            if (logoffResult == EResult.TryAnotherCM || logoffResult == EResult.ServiceUnavailable) {
                Connection connection = this.connection;
                if (connection != null) {
                    this.getServers().tryMark(connection.getCurrentEndPoint(), connection.getProtocolTypes(), ServerQuality.BAD);
                } else {
                    logger.error("Connection was null trying to mark endpoint bad.");
                }
            }
        } else {
            logger.debug("handleLoggedOff got unexpected response: " + String.valueOf((Object)packetMsg.getMsgType()));
        }
    }

    private void handleServerUnavailable(IPacketMsg packetMsg) {
        ClientMsg<MsgClientServerUnavailable> msgServerUnavailable = new ClientMsg<MsgClientServerUnavailable>(MsgClientServerUnavailable.class, packetMsg);
        logger.debug("A server of type " + String.valueOf((Object)msgServerUnavailable.getBody().getEServerTypeUnavailable()) + "was not available for request: " + String.valueOf((Object)EMsg.from(msgServerUnavailable.getBody().getEMsgSent())));
        this.disconnect(false);
    }

    private void handleSessionToken(IPacketMsg packetMsg) {
        ClientMsgProtobuf sessToken = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientSessionToken.class, packetMsg);
        this.sessionToken = ((SteammessagesClientserver.CMsgClientSessionToken.Builder)sessToken.getBody()).getToken();
    }

    public SteamConfiguration getConfiguration() {
        return this.configuration;
    }

    public SmartCMServerList getServers() {
        return this.configuration.getServerList();
    }

    @Nullable
    public InetAddress getLocalIP() {
        Connection connection = this.connection;
        if (connection == null) {
            return null;
        }
        return connection.getLocalIP();
    }

    @Nullable
    public InetSocketAddress getCurrentEndpoint() {
        Connection connection = this.connection;
        if (connection == null) {
            return null;
        }
        return connection.getCurrentEndPoint();
    }

    @Nullable
    public InetAddress getPublicIP() {
        return this.publicIP;
    }

    @Nullable
    public String getIpCountryCode() {
        return this.ipCountryCode;
    }

    public EUniverse getUniverse() {
        return this.configuration.getUniverse();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean isDisconnected() {
        return !this.isConnected && this.connection == null;
    }

    public long getSessionToken() {
        return this.sessionToken;
    }

    @Nullable
    public Integer getCellID() {
        return this.cellID;
    }

    @Nullable
    public Integer getSessionID() {
        return this.sessionID;
    }

    @Nullable
    public SteamID getSteamID() {
        return this.steamID;
    }

    public long getConnectionTimeout() {
        return this.configuration.getConnectionTimeout();
    }

    public IDebugNetworkListener getDebugNetworkListener() {
        return this.debugNetworkListener;
    }

    public void setDebugNetworkListener(IDebugNetworkListener debugNetworkListener) {
        this.debugNetworkListener = debugNetworkListener;
    }

    public boolean isExpectDisconnection() {
        return this.expectDisconnection;
    }

    public void setExpectDisconnection(boolean expectDisconnection) {
        this.expectDisconnection = expectDisconnection;
    }
}

