/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.cdn;

import in.dragonbra.javasteam.types.ChunkData;
import in.dragonbra.javasteam.util.Strings;
import in.dragonbra.javasteam.util.Utils;
import in.dragonbra.javasteam.util.VZipUtil;
import in.dragonbra.javasteam.util.VZstdUtil;
import in.dragonbra.javasteam.util.ZipUtil;
import in.dragonbra.javasteam.util.crypto.CryptoHelper;
import in.dragonbra.javasteam.util.stream.MemoryStream;
import java.io.Closeable;
import java.io.IOException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0007\u00a8\u0006\f"}, d2={"Lin/dragonbra/javasteam/steam/cdn/DepotChunk;", "", "<init>", "()V", "process", "", "info", "Lin/dragonbra/javasteam/types/ChunkData;", "data", "", "destination", "depotKey", "javasteam"})
@SourceDebugExtension(value={"SMAP\nDepotChunk.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DepotChunk.kt\nin/dragonbra/javasteam/steam/cdn/DepotChunk\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1#2:139\n*E\n"})
public final class DepotChunk {
    @NotNull
    public static final DepotChunk INSTANCE = new DepotChunk();

    private DepotChunk() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final int process(@NotNull ChunkData info, @NotNull byte[] data, @NotNull byte[] destination, @NotNull byte[] depotKey) {
        int writtenDecompressed;
        block24: {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)depotKey, (String)"depotKey");
            if (!(destination.length >= info.getUncompressedLength())) {
                boolean $i$a$-require-DepotChunk$process$42 = false;
                String $i$a$-require-DepotChunk$process$42 = "The destination buffer must be longer than the chunk uncompressedLength.";
                throw new IllegalArgumentException($i$a$-require-DepotChunk$process$42.toString());
            }
            if (!(depotKey.length == 32)) {
                boolean $i$a$-require-DepotChunk$process$52 = false;
                String $i$a$-require-DepotChunk$process$52 = "Tried to decrypt depot chunk with non 32 byte key!";
                throw new IllegalArgumentException($i$a$-require-DepotChunk$process$52.toString());
            }
            SecretKeySpec keySpec = new SecretKeySpec(depotKey, "AES");
            Cipher ecbCipher = Cipher.getInstance("AES/ECB/NoPadding", CryptoHelper.SEC_PROV);
            ecbCipher.init(2, keySpec);
            byte[] iv = new byte[16];
            int ivBytesRead = ecbCipher.doFinal(data, 0, iv.length, iv);
            if (!(iv.length == ivBytesRead)) {
                boolean $i$a$-require-DepotChunk$process$62 = false;
                String $i$a$-require-DepotChunk$process$62 = "Failed to decrypt depot chunk iv (" + iv.length + " != " + ivBytesRead + ")";
                throw new IllegalArgumentException($i$a$-require-DepotChunk$process$62.toString());
            }
            byte[] buffer = new byte[data.length - iv.length];
            Cipher cbcCipher = Cipher.getInstance("AES/CBC/PKCS7Padding", CryptoHelper.SEC_PROV);
            cbcCipher.init(2, (Key)keySpec, new IvParameterSpec(iv));
            writtenDecompressed = 0;
            try {
                int written = cbcCipher.doFinal(data, iv.length, data.length - iv.length, buffer);
                if (buffer.length < 16) {
                    throw new IOException("Not enough data in the decrypted depot chunk (was " + buffer.length + " bytes).");
                }
                if (buffer[0] == 86 && buffer[1] == 83 && buffer[2] == 90 && buffer[3] == 97) {
                    writtenDecompressed = VZstdUtil.decompress(ArraysKt.copyOfRange((byte[])buffer, (int)0, (int)written), destination, false);
                    break block24;
                }
                if (buffer[0] == 86 && buffer[1] == 90 && buffer[2] == 97) {
                    Closeable closeable = new MemoryStream(buffer, 0, written);
                    Throwable throwable = null;
                    try {
                        MemoryStream decryptedStream = (MemoryStream)closeable;
                        boolean bl = false;
                        writtenDecompressed = VZipUtil.decompress(decryptedStream, destination, false);
                        decryptedStream = Unit.INSTANCE;
                        break block24;
                    }
                    catch (Throwable bl) {
                        throwable = bl;
                        throw bl;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                if (buffer[0] == 80 && buffer[1] == 75 && buffer[2] == 3 && buffer[3] == 4) {
                    Closeable closeable = new MemoryStream(buffer, 0, written);
                    Throwable throwable = null;
                    try {
                        MemoryStream decryptedStream = (MemoryStream)closeable;
                        boolean bl = false;
                        writtenDecompressed = ZipUtil.decompress(decryptedStream, destination, false);
                        Unit unit = Unit.INSTANCE;
                        break block24;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                throw new IOException("Unexpected depot chunk compression (first four bytes are " + Strings.toHex(ArraysKt.copyOfRange((byte[])buffer, (int)0, (int)4)) + ").");
            }
            catch (Exception e) {
                throw new IOException("Failed to decompress chunk " + Strings.toHex(info.getChunkID()) + ": " + e + "\n" + ExceptionsKt.stackTraceToString((Throwable)e));
            }
            finally {
                ArraysKt.fill$default((byte[])buffer, (byte)0, (int)0, (int)0, (int)6, null);
            }
        }
        if (info.getUncompressedLength() != writtenDecompressed) {
            throw new IOException("Processed data checksum failed to decompress to the expected chunk uncompressed length. (was " + writtenDecompressed + ", should be " + info.getUncompressedLength() + ")");
        }
        int dataCrc = Utils.adlerHash(ArraysKt.sliceArray((byte[])destination, (IntRange)RangesKt.until((int)0, (int)writtenDecompressed)));
        if (dataCrc != info.getChecksum()) {
            throw new IOException("Processed data checksum is incorrect (" + dataCrc + " != " + info.getChecksum() + ")! Downloaded depot chunk is corrupt or invalid/wrong depot key?");
        }
        return writtenDecompressed;
    }
}

