/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.contentdownloader;

import in.dragonbra.javasteam.steam.contentdownloader.IManifestProvider;
import in.dragonbra.javasteam.types.DepotManifest;
import in.dragonbra.javasteam.util.compat.InputStreamCompatKt;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import in.dragonbra.javasteam.util.stream.MemoryStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.io.NoSuchFileException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lin/dragonbra/javasteam/steam/contentdownloader/FileManifestProvider;", "Lin/dragonbra/javasteam/steam/contentdownloader/IManifestProvider;", "file", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "Ljava/io/File;", "(Ljava/io/File;)V", "filename", "", "(Ljava/lang/String;)V", "fetchManifest", "Lin/dragonbra/javasteam/types/DepotManifest;", "depotID", "", "manifestID", "", "fetchLatestManifest", "setLatestManifestId", "", "updateManifest", "manifest", "Companion", "javasteam"})
@SourceDebugExtension(value={"SMAP\nFileManifestProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileManifestProvider.kt\nin/dragonbra/javasteam/steam/contentdownloader/FileManifestProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n1#2:212\n*E\n"})
public final class FileManifestProvider
implements IManifestProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path file;
    @NotNull
    private static final Logger logger;

    public FileManifestProvider(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        if (!(!StringsKt.isBlank((CharSequence)((Object)this.file.getFileName()).toString()))) {
            boolean bl = false;
            String string = "FileName must not be blank";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public FileManifestProvider(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path path = file.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        this(path);
    }

    public FileManifestProvider(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Path path = Path.of(filename, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        this(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public DepotManifest fetchManifest(int depotID, long manifestID) {
        DepotManifest depotManifest2;
        Object $this$fetchManifest_u24lambda_u244;
        Object object = this;
        try {
            DepotManifest depotManifest3;
            $this$fetchManifest_u24lambda_u244 = object;
            boolean bl = false;
            Closeable closeable = Files.newInputStream(((FileManifestProvider)$this$fetchManifest_u24lambda_u244).file, new OpenOption[0]);
            Throwable throwable = null;
            try {
                DepotManifest depotManifest4;
                InputStream fis = (InputStream)closeable;
                boolean bl2 = false;
                Closeable closeable2 = new ZipInputStream(fis);
                Throwable throwable2 = null;
                try {
                    DepotManifest depotManifest5;
                    ZipInputStream zip = (ZipInputStream)closeable2;
                    boolean bl3 = false;
                    ZipEntry zipEntry = FileManifestProvider.Companion.seekToEntry(zip, FileManifestProvider.Companion.getEntryName(depotID, manifestID));
                    if (zipEntry != null) {
                        ZipEntry it = zipEntry;
                        boolean bl4 = false;
                        depotManifest5 = it.getSize() > 0L ? DepotManifest.Companion.deserialize(zip) : null;
                    } else {
                        depotManifest5 = null;
                    }
                    depotManifest4 = depotManifest5;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                depotManifest3 = depotManifest4;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            $this$fetchManifest_u24lambda_u244 = Result.constructor-impl((Object)depotManifest3);
        }
        catch (Throwable bl) {
            $this$fetchManifest_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$fetchManifest_u24lambda_u244;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable == null) {
            DepotManifest it = (DepotManifest)object;
            boolean bl = false;
            depotManifest2 = it;
        } else {
            Throwable error = throwable;
            boolean bl = false;
            if (error instanceof NoSuchFileException) {
                logger.debug("File doesn't exist");
            } else {
                logger.error("Unknown error occurred", error);
            }
            depotManifest2 = null;
        }
        return depotManifest2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public DepotManifest fetchLatestManifest(int depotID) {
        DepotManifest depotManifest2;
        Object $this$fetchLatestManifest_u24lambda_u2411;
        Object object = this;
        try {
            DepotManifest depotManifest3;
            Long l;
            $this$fetchLatestManifest_u24lambda_u2411 = object;
            boolean bl = false;
            Closeable closeable = Files.newInputStream(((FileManifestProvider)$this$fetchLatestManifest_u24lambda_u2411).file, new OpenOption[0]);
            Throwable throwable = null;
            try {
                Long l2;
                InputStream fis = (InputStream)closeable;
                boolean bl2 = false;
                Closeable closeable2 = new ZipInputStream(fis);
                Throwable throwable2 = null;
                try {
                    Long l3;
                    ZipInputStream zip = (ZipInputStream)closeable2;
                    boolean bl3 = false;
                    ZipEntry zipEntry = FileManifestProvider.Companion.seekToEntry(zip, FileManifestProvider.Companion.getLatestEntryName(depotID));
                    if (zipEntry != null) {
                        ZipEntry idEntry = zipEntry;
                        boolean bl4 = false;
                        l3 = idEntry.getSize() > 0L ? Long.valueOf(ByteBuffer.wrap(InputStreamCompatKt.readNBytesCompat(zip, (int)idEntry.getSize())).getLong()) : null;
                    } else {
                        l3 = null;
                    }
                    l2 = l3;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                l = l2;
            }
            catch (Throwable bl2) {
                throwable = bl2;
                throw bl2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Long l4 = l;
            if (l4 != null) {
                long manifestId = ((Number)l4).longValue();
                boolean bl5 = false;
                depotManifest3 = ((FileManifestProvider)$this$fetchLatestManifest_u24lambda_u2411).fetchManifest(depotID, manifestId);
            } else {
                depotManifest3 = null;
            }
            $this$fetchLatestManifest_u24lambda_u2411 = Result.constructor-impl(depotManifest3);
        }
        catch (Throwable bl) {
            $this$fetchLatestManifest_u24lambda_u2411 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$fetchLatestManifest_u24lambda_u2411;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable == null) {
            DepotManifest it = (DepotManifest)object;
            boolean bl = false;
            depotManifest2 = it;
        } else {
            Throwable error = throwable;
            boolean bl = false;
            if (error instanceof NoSuchFileException) {
                logger.debug("File doesn't exist");
            } else {
                logger.error("Unknown error occurred", error);
            }
            depotManifest2 = null;
        }
        return depotManifest2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLatestManifestId(int depotID, long manifestID) {
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream bs = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new ZipOutputStream(bs);
            Throwable throwable2 = null;
            try {
                Object object;
                Object zip = (ZipOutputStream)closeable2;
                boolean bl2 = false;
                if (Files.exists(this.file, new LinkOption[0])) {
                    object = Files.newInputStream(this.file, new OpenOption[0]);
                    Throwable throwable3 = null;
                    try {
                        InputStream fis = (InputStream)object;
                        boolean bl3 = false;
                        Closeable closeable3 = new ZipInputStream(fis);
                        Throwable throwable4 = null;
                        try {
                            ZipInputStream zs = (ZipInputStream)closeable3;
                            boolean bl4 = false;
                            String[] stringArray = new String[]{FileManifestProvider.Companion.getLatestEntryName(depotID)};
                            FileManifestProvider.Companion.copyZip(zs, (ZipOutputStream)zip, stringArray);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable5) {
                            throwable4 = throwable5;
                            throw throwable5;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable4);
                        }
                        fis = Unit.INSTANCE;
                    }
                    catch (Throwable throwable6) {
                        throwable3 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable3);
                    }
                }
                object = ByteBuffer.allocate(8);
                ByteBuffer $this$setLatestManifestId_u24lambda_u2419_u24lambda_u2417_u24lambda_u2416 = object;
                boolean bl5 = false;
                $this$setLatestManifestId_u24lambda_u2419_u24lambda_u2417_u24lambda_u2416.putLong(manifestID);
                String string = FileManifestProvider.Companion.getLatestEntryName(depotID);
                byte[] byArray = $this$setLatestManifestId_u24lambda_u2419_u24lambda_u2417_u24lambda_u2416.array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
                FileManifestProvider.Companion.zipUncompressed((ZipOutputStream)zip, string, byArray);
                zip = object;
            }
            catch (Throwable bl2) {
                throwable2 = bl2;
                throw bl2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            try {
                closeable2 = Files.newOutputStream(this.file, new OpenOption[0]);
                throwable2 = null;
                try {
                    OutputStream fos = (OutputStream)closeable2;
                    boolean bl6 = false;
                    fos.write(bs.toByteArray());
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable7) {
                    throwable2 = throwable7;
                    throw throwable7;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            catch (IOException e) {
                logger.error("Failed to write manifest ID to file " + this.file.getFileName(), e);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable8) {
            throwable = throwable8;
            throw throwable8;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateManifest(@NotNull DepotManifest manifest) {
        Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream bs = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new ZipOutputStream(bs);
            Throwable throwable2 = null;
            try {
                Throwable throwable3;
                Closeable closeable3;
                ZipOutputStream zip = (ZipOutputStream)closeable2;
                boolean bl2 = false;
                if (Files.exists(this.file, new LinkOption[0])) {
                    closeable3 = Files.newInputStream(this.file, new OpenOption[0]);
                    throwable3 = null;
                    try {
                        InputStream fis = (InputStream)closeable3;
                        boolean bl3 = false;
                        Closeable closeable4 = new ZipInputStream(fis);
                        Throwable throwable4 = null;
                        try {
                            ZipInputStream zs = (ZipInputStream)closeable4;
                            boolean bl4 = false;
                            String[] stringArray = new String[]{FileManifestProvider.Companion.getEntryName(manifest.getDepotID(), manifest.getManifestGID())};
                            FileManifestProvider.Companion.copyZip(zs, zip, stringArray);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable5) {
                            throwable4 = throwable5;
                            throw throwable5;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable4, (Throwable)throwable4);
                        }
                        fis = Unit.INSTANCE;
                    }
                    catch (Throwable bl3) {
                        throwable3 = bl3;
                        throw bl3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                    }
                }
                closeable3 = new MemoryStream();
                throwable3 = null;
                try {
                    MemoryStream ms = (MemoryStream)closeable3;
                    boolean bl5 = false;
                    OutputStream outputStream = ms.asOutputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"asOutputStream(...)");
                    manifest.serialize(outputStream);
                    String string = FileManifestProvider.Companion.getEntryName(manifest.getDepotID(), manifest.getManifestGID());
                    byte[] byArray = ms.toByteArray();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                    FileManifestProvider.Companion.zipUncompressed(zip, string, byArray);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable6) {
                    throwable3 = throwable6;
                    throw throwable6;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                zip = Unit.INSTANCE;
            }
            catch (Throwable bl2) {
                throwable2 = bl2;
                throw bl2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            try {
                closeable2 = Files.newOutputStream(this.file, new OpenOption[0]);
                throwable2 = null;
                try {
                    OutputStream fos = (OutputStream)closeable2;
                    boolean bl6 = false;
                    fos.write(bs.toByteArray());
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable7) {
                    throwable2 = throwable7;
                    throw throwable7;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            catch (IOException e) {
                logger.error("Failed to write manifest to file " + this.file.getFileName(), e);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable8) {
            throwable = throwable8;
            throw throwable8;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static {
        Logger logger = LogManager.getLogger(FileManifestProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        FileManifestProvider.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J1\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0018\"\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0019J \u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lin/dragonbra/javasteam/steam/contentdownloader/FileManifestProvider$Companion;", "", "<init>", "()V", "logger", "Lin/dragonbra/javasteam/util/log/Logger;", "getLatestEntryName", "", "depotID", "", "getEntryName", "manifestID", "", "seekToEntry", "Ljava/util/zip/ZipEntry;", "zipStream", "Ljava/util/zip/ZipInputStream;", "entryName", "copyZip", "", "from", "to", "Ljava/util/zip/ZipOutputStream;", "excludeEntries", "", "(Ljava/util/zip/ZipInputStream;Ljava/util/zip/ZipOutputStream;[Ljava/lang/String;)V", "zipUncompressed", "zip", "bytes", "", "javasteam"})
    public static final class Companion {
        private Companion() {
        }

        private final String getLatestEntryName(int depotID) {
            return depotID + File.separator + "latest";
        }

        private final String getEntryName(int depotID, long manifestID) {
            return depotID + File.separator + manifestID + ".bin";
        }

        private final ZipEntry seekToEntry(ZipInputStream zipStream, String entryName) {
            ZipEntry zipEntry;
            ZipEntry zipEntry2 = null;
            do {
                zipEntry = zipEntry2 = zipStream.getNextEntry();
            } while (!StringsKt.equals((String)(zipEntry != null ? zipEntry.getName() : null), (String)entryName, (boolean)true) && zipEntry2 != null);
            return zipEntry2;
        }

        private final void copyZip(ZipInputStream from, ZipOutputStream to, String ... excludeEntries) {
            ZipEntry entry = from.getNextEntry();
            while (entry != null) {
                if (!ArraysKt.contains((Object[])excludeEntries, (Object)entry.getName()) && (entry.isDirectory() || !entry.isDirectory() && entry.getSize() > 0L)) {
                    to.putNextEntry(entry);
                    if (!entry.isDirectory()) {
                        byte[] entryBytes = new byte[(int)entry.getSize()];
                        InputStreamCompatKt.readNBytesCompat(from, entryBytes, 0, entryBytes.length);
                        to.write(entryBytes);
                    }
                    to.closeEntry();
                }
                entry = from.getNextEntry();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void zipUncompressed(ZipOutputStream zip, String entryName, byte[] bytes) {
            void $this$zipUncompressed_u24lambda_u241_u24lambda_u240;
            ZipEntry zipEntry;
            ZipEntry $this$zipUncompressed_u24lambda_u241 = zipEntry = new ZipEntry(entryName);
            boolean bl = false;
            $this$zipUncompressed_u24lambda_u241.setMethod(0);
            $this$zipUncompressed_u24lambda_u241.setSize(bytes.length);
            $this$zipUncompressed_u24lambda_u241.setCompressedSize(bytes.length);
            CRC32 cRC32 = new CRC32();
            ZipEntry zipEntry2 = $this$zipUncompressed_u24lambda_u241;
            boolean bl2 = false;
            $this$zipUncompressed_u24lambda_u241_u24lambda_u240.update(bytes);
            zipEntry2.setCrc(((Number)$this$zipUncompressed_u24lambda_u241_u24lambda_u240.getValue()).longValue());
            ZipEntry entry = zipEntry;
            zip.putNextEntry(entry);
            zip.write(bytes);
            zip.closeEntry();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

