/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.discovery;

import in.dragonbra.javasteam.networking.steam3.ProtocolTypes;
import in.dragonbra.javasteam.protobufs.steam.discovery.BasicServerListProtos;
import in.dragonbra.javasteam.steam.discovery.IServerListProvider;
import in.dragonbra.javasteam.steam.discovery.ServerRecord;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lin/dragonbra/javasteam/steam/discovery/FileServerListProvider;", "Lin/dragonbra/javasteam/steam/discovery/IServerListProvider;", "file", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "Ljava/io/File;", "(Ljava/io/File;)V", "filename", "", "(Ljava/lang/String;)V", "getFile", "()Ljava/nio/file/Path;", "lastServerListRefresh", "Ljava/time/Instant;", "getLastServerListRefresh", "()Ljava/time/Instant;", "fetchServerList", "", "Lin/dragonbra/javasteam/steam/discovery/ServerRecord;", "updateServerList", "", "endpoints", "Companion", "javasteam"})
@SourceDebugExtension(value={"SMAP\nFileServerListProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileServerListProvider.kt\nin/dragonbra/javasteam/steam/discovery/FileServerListProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1#2:111\n1563#3:112\n1634#3,3:113\n*S KotlinDebug\n*F\n+ 1 FileServerListProvider.kt\nin/dragonbra/javasteam/steam/discovery/FileServerListProvider\n*L\n87#1:112\n87#1:113,3\n*E\n"})
public final class FileServerListProvider
implements IServerListProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path file;
    @NotNull
    private static final Logger logger;

    public FileServerListProvider(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        if (!(!StringsKt.isBlank((CharSequence)((Object)this.file.getFileName()).toString()))) {
            boolean bl = false;
            String string = "FileName must not be blank";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final Path getFile() {
        return this.file;
    }

    public FileServerListProvider(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path path = file.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        this(path);
    }

    public FileServerListProvider(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Path path = Path.of(filename, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        this(path);
    }

    @Override
    @NotNull
    public Instant getLastServerListRefresh() {
        Instant instant;
        try {
            instant = Files.getLastModifiedTime(this.file, new LinkOption[0]).toInstant();
            Intrinsics.checkNotNull((Object)instant);
        }
        catch (Exception exception) {
            Instant instant2 = Instant.MIN;
            Intrinsics.checkNotNull((Object)instant2);
            instant = instant2;
        }
        return instant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ServerRecord> fetchServerList() {
        List list;
        Object $this$fetchServerList_u24lambda_u243;
        Object object = this;
        try {
            List list2;
            $this$fetchServerList_u24lambda_u243 = object;
            boolean bl = false;
            Closeable closeable = Files.newInputStream(((FileServerListProvider)$this$fetchServerList_u24lambda_u243).file, new OpenOption[0]);
            Throwable throwable = null;
            try {
                InputStream fis = (InputStream)closeable;
                boolean bl2 = false;
                BasicServerListProtos.BasicServerList serverList = BasicServerListProtos.BasicServerList.parseFrom(fis);
                int n = serverList.getServersCount();
                ArrayList<ServerRecord> arrayList = new ArrayList<ServerRecord>(n);
                int n2 = 0;
                while (n2 < n) {
                    BasicServerListProtos.BasicServer server;
                    void i2;
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<ServerRecord> arrayList2 = arrayList;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)serverList.getServers((int)i2), (String)"getServers(...)");
                    String string = server.getAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAddress(...)");
                    int n5 = server.getPort();
                    EnumSet<ProtocolTypes> enumSet = ProtocolTypes.from(server.getProtocol());
                    Intrinsics.checkNotNullExpressionValue(enumSet, (String)"from(...)");
                    arrayList2.add(ServerRecord.Companion.createServer(string, n5, enumSet));
                }
                list2 = arrayList;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            $this$fetchServerList_u24lambda_u243 = Result.constructor-impl((Object)list2);
        }
        catch (Throwable bl) {
            $this$fetchServerList_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$fetchServerList_u24lambda_u243;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable == null) {
            List it = (List)object;
            boolean bl = false;
            list = it;
        } else {
            Throwable error = throwable;
            boolean bl = false;
            if (error instanceof NoSuchFileException) {
                logger.debug("File doesn't exist");
            } else {
                logger.error("Unknown error occurred", error);
            }
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void updateServerList(@NotNull List<ServerRecord> endpoints) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(endpoints, (String)"endpoints");
        Object object = BasicServerListProtos.BasicServerList.newBuilder();
        BasicServerListProtos.BasicServerList.Builder $this$updateServerList_u24lambda_u247 = object;
        boolean bl = false;
        Iterable iterable = endpoints;
        BasicServerListProtos.BasicServerList.Builder builder = $this$updateServerList_u24lambda_u247;
        boolean $i$f$map = false;
        void var9_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void endpoint;
            ServerRecord serverRecord = (ServerRecord)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(BasicServerListProtos.BasicServer.newBuilder().setAddress(endpoint.getHost()).setPort(endpoint.getPort()).setProtocol(ProtocolTypes.code(endpoint.getProtocolTypes())).build());
        }
        builder.addAllServers((List)destination$iv$iv);
        BasicServerListProtos.BasicServerList.Builder builder2 = object;
        try {
            object = Files.newOutputStream(this.file, new OpenOption[0]);
            Throwable throwable = null;
            try {
                OutputStream fos = (OutputStream)object;
                boolean bl3 = false;
                builder2.build().writeTo(fos);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            logger.error("Failed to write servers to file " + this.file.getFileName(), e);
        }
    }

    static {
        Logger logger = LogManager.getLogger(FileServerListProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        FileServerListProvider.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lin/dragonbra/javasteam/steam/discovery/FileServerListProvider$Companion;", "", "<init>", "()V", "logger", "Lin/dragonbra/javasteam/util/log/Logger;", "javasteam"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

