/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.discovery;

import in.dragonbra.javasteam.steam.discovery.IServerListProvider;
import in.dragonbra.javasteam.steam.discovery.ServerRecord;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lin/dragonbra/javasteam/steam/discovery/MemoryServerListProvider;", "Lin/dragonbra/javasteam/steam/discovery/IServerListProvider;", "<init>", "()V", "servers", "", "Lin/dragonbra/javasteam/steam/discovery/ServerRecord;", "lastUpdated", "Ljava/time/Instant;", "lastServerListRefresh", "getLastServerListRefresh", "()Ljava/time/Instant;", "fetchServerList", "updateServerList", "", "endpoints", "javasteam"})
public final class MemoryServerListProvider
implements IServerListProvider {
    @NotNull
    private List<ServerRecord> servers = CollectionsKt.emptyList();
    @NotNull
    private Instant lastUpdated;

    public MemoryServerListProvider() {
        Instant instant = Instant.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"MIN");
        this.lastUpdated = instant;
    }

    @Override
    @NotNull
    public Instant getLastServerListRefresh() {
        return this.lastUpdated;
    }

    @Override
    @NotNull
    public List<ServerRecord> fetchServerList() {
        return this.servers;
    }

    @Override
    public void updateServerList(@NotNull List<ServerRecord> endpoints) {
        Intrinsics.checkNotNullParameter(endpoints, (String)"endpoints");
        this.servers = endpoints;
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.lastUpdated = instant;
    }
}

