/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.discovery;

import in.dragonbra.javasteam.networking.steam3.ProtocolTypes;
import in.dragonbra.javasteam.util.NetHelpers;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lin/dragonbra/javasteam/steam/discovery/ServerRecord;", "", "endpoint", "Ljava/net/InetSocketAddress;", "protocolTypes", "Ljava/util/EnumSet;", "Lin/dragonbra/javasteam/networking/steam3/ProtocolTypes;", "<init>", "(Ljava/net/InetSocketAddress;Ljava/util/EnumSet;)V", "(Ljava/net/InetSocketAddress;Lin/dragonbra/javasteam/networking/steam3/ProtocolTypes;)V", "getEndpoint", "()Ljava/net/InetSocketAddress;", "getProtocolTypes", "()Ljava/util/EnumSet;", "host", "", "getHost", "()Ljava/lang/String;", "port", "", "getPort", "()I", "equals", "", "other", "hashCode", "Companion", "javasteam"})
public final class ServerRecord {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InetSocketAddress endpoint;
    @NotNull
    private final EnumSet<ProtocolTypes> protocolTypes;
    @NotNull
    private final String host;
    private final int port;
    private static final Logger logger = LogManager.getLogger(ServerRecord.class);

    private ServerRecord(InetSocketAddress endpoint, EnumSet<ProtocolTypes> protocolTypes) {
        this.endpoint = endpoint;
        this.protocolTypes = protocolTypes;
        String string = this.endpoint.getHostString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostString(...)");
        this.host = string;
        this.port = this.endpoint.getPort();
    }

    @NotNull
    public final InetSocketAddress getEndpoint() {
        return this.endpoint;
    }

    @NotNull
    public final EnumSet<ProtocolTypes> getProtocolTypes() {
        return this.protocolTypes;
    }

    public ServerRecord(@NotNull InetSocketAddress endpoint, @NotNull ProtocolTypes protocolTypes) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)((Object)protocolTypes), (String)"protocolTypes");
        EnumSet<Enum> enumSet = EnumSet.of((Enum)protocolTypes);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        this(endpoint, enumSet);
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ServerRecord)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.endpoint, (Object)((ServerRecord)other).endpoint) && Intrinsics.areEqual(this.protocolTypes, ((ServerRecord)other).protocolTypes);
    }

    public int hashCode() {
        return this.endpoint.hashCode() ^ this.protocolTypes.hashCode();
    }

    @JvmStatic
    @NotNull
    public static final ServerRecord createServer(@NotNull String host, int port, @NotNull ProtocolTypes protocolTypes) {
        return Companion.createServer(host, port, protocolTypes);
    }

    @JvmStatic
    @NotNull
    public static final ServerRecord createServer(@NotNull String host, int port, @NotNull EnumSet<ProtocolTypes> protocolTypes) {
        return Companion.createServer(host, port, protocolTypes);
    }

    @JvmStatic
    @NotNull
    public static final ServerRecord createSocketServer(@NotNull InetSocketAddress endpoint) {
        return Companion.createSocketServer(endpoint);
    }

    @JvmStatic
    @Nullable
    public static final ServerRecord tryCreateSocketServer(@NotNull String address) {
        return Companion.tryCreateSocketServer(address);
    }

    @JvmStatic
    @NotNull
    public static final ServerRecord createWebSocketServer(@NotNull String address) {
        return Companion.createWebSocketServer(address);
    }

    public /* synthetic */ ServerRecord(InetSocketAddress endpoint, EnumSet protocolTypes, DefaultConstructorMarker $constructor_marker) {
        this(endpoint, protocolTypes);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\nH\u0007J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\nH\u0007R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lin/dragonbra/javasteam/steam/discovery/ServerRecord$Companion;", "", "<init>", "()V", "logger", "Lin/dragonbra/javasteam/util/log/Logger;", "kotlin.jvm.PlatformType", "createServer", "Lin/dragonbra/javasteam/steam/discovery/ServerRecord;", "host", "", "port", "", "protocolTypes", "Lin/dragonbra/javasteam/networking/steam3/ProtocolTypes;", "Ljava/util/EnumSet;", "createSocketServer", "endpoint", "Ljava/net/InetSocketAddress;", "tryCreateSocketServer", "address", "createWebSocketServer", "javasteam"})
    @SourceDebugExtension(value={"SMAP\nServerRecord.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerRecord.kt\nin/dragonbra/javasteam/steam/discovery/ServerRecord$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,127:1\n739#2,9:128\n37#3:137\n36#3,3:138\n*S KotlinDebug\n*F\n+ 1 ServerRecord.kt\nin/dragonbra/javasteam/steam/discovery/ServerRecord$Companion\n*L\n116#1:128,9\n116#1:137\n116#1:138,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ServerRecord createServer(@NotNull String host, int port, @NotNull ProtocolTypes protocolTypes) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)((Object)protocolTypes), (String)"protocolTypes");
            EnumSet<Enum> enumSet = EnumSet.of((Enum)protocolTypes);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
            return this.createServer(host, port, enumSet);
        }

        @JvmStatic
        @NotNull
        public final ServerRecord createServer(@NotNull String host, int port, @NotNull EnumSet<ProtocolTypes> protocolTypes) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter(protocolTypes, (String)"protocolTypes");
            return new ServerRecord(new InetSocketAddress(host, port), protocolTypes, null);
        }

        @JvmStatic
        @NotNull
        public final ServerRecord createSocketServer(@NotNull InetSocketAddress endpoint) {
            Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
            EnumSet<Enum> enumSet = EnumSet.of((Enum)ProtocolTypes.TCP, (Enum)ProtocolTypes.UDP);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
            return new ServerRecord(endpoint, enumSet, null);
        }

        @JvmStatic
        @Nullable
        public final ServerRecord tryCreateSocketServer(@NotNull String address) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            InetSocketAddress endpoint = NetHelpers.tryParseIPEndPoint(address);
            if (endpoint == null) {
                logger.error("Unable to create socket server for: " + address);
                return null;
            }
            EnumSet<Enum> enumSet = EnumSet.of((Enum)ProtocolTypes.TCP, (Enum)ProtocolTypes.UDP);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
            return new ServerRecord(endpoint, enumSet, null);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final ServerRecord createWebSocketServer(@NotNull String address) {
            void $this$toTypedArray$iv;
            List list;
            Collection $this$dropLastWhile$iv;
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            int defaultPort = 443;
            Object object = address;
            Regex regex = new Regex(":");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] split = thisCollection$iv.toArray(new String[0]);
            InetSocketAddress endpoint = split.length > 1 ? new InetSocketAddress(split[0], Integer.parseInt(split[1])) : new InetSocketAddress(address, defaultPort);
            return new ServerRecord(endpoint, ProtocolTypes.WEB_SOCKET);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

