/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.discovery;

import in.dragonbra.javasteam.networking.steam3.ProtocolTypes;
import in.dragonbra.javasteam.steam.discovery.ServerInfo;
import in.dragonbra.javasteam.steam.discovery.ServerQuality;
import in.dragonbra.javasteam.steam.discovery.ServerRecord;
import in.dragonbra.javasteam.steam.steamclient.configuration.SteamConfiguration;
import in.dragonbra.javasteam.steam.webapi.SteamDirectory;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 42\u00020\u0001:\u00014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u00020\u00182\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\u0018J,\u0010\u001d\u001a\u00020\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\b\b\u0002\u0010!\u001a\u00020\u001b2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\nH\u0007J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020 H\u0002J\u0006\u0010%\u001a\u00020\u0018J\"\u0010&\u001a\u00020\u001b2\b\u0010$\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+J(\u0010&\u001a\u00020\u001b2\b\u0010$\u001a\u0004\u0018\u00010'2\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010,2\u0006\u0010*\u001a\u00020+J\u0018\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\b2\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u0010/\u001a\u0004\u0018\u00010 2\f\u00100\u001a\b\u0012\u0004\u0012\u00020)0,H\u0002J\u0016\u00101\u001a\u0004\u0018\u00010 2\f\u00100\u001a\b\u0012\u0004\u0012\u00020)0,J\u0010\u00101\u001a\u0004\u0018\u00010 2\u0006\u00100\u001a\u00020)J\f\u00102\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u0006\u00103\u001a\u00020\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0014\u0010\u000e\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0012\u00a8\u00065"}, d2={"Lin/dragonbra/javasteam/steam/discovery/SmartCMServerList;", "", "configuration", "Lin/dragonbra/javasteam/steam/steamclient/configuration/SteamConfiguration;", "<init>", "(Lin/dragonbra/javasteam/steam/steamclient/configuration/SteamConfiguration;)V", "servers", "", "Lin/dragonbra/javasteam/steam/discovery/ServerInfo;", "serversLastRefresh", "Ljava/time/Instant;", "serverListBeforeRefreshTimeSpan", "Ljava/time/Duration;", "getServerListBeforeRefreshTimeSpan$annotations", "()V", "getServerListBeforeRefreshTimeSpan", "()Ljava/time/Duration;", "setServerListBeforeRefreshTimeSpan", "(Ljava/time/Duration;)V", "badConnectionMemoryTimeSpan", "getBadConnectionMemoryTimeSpan$annotations", "getBadConnectionMemoryTimeSpan", "setBadConnectionMemoryTimeSpan", "startFetchingServers", "", "resolveServerList", "forceRefresh", "", "resetOldScores", "replaceList", "endpointList", "", "Lin/dragonbra/javasteam/steam/discovery/ServerRecord;", "writeProvider", "serversTime", "addCore", "endPoint", "resetBadServers", "tryMark", "Ljava/net/InetSocketAddress;", "protocolTypes", "Lin/dragonbra/javasteam/networking/steam3/ProtocolTypes;", "quality", "Lin/dragonbra/javasteam/steam/discovery/ServerQuality;", "Ljava/util/EnumSet;", "markServerCore", "serverInfo", "getNextServerCandidateInternal", "supportedProtocolTypes", "getNextServerCandidate", "getAllEndPoints", "forceRefreshServerList", "Companion", "javasteam"})
@SourceDebugExtension(value={"SMAP\nSmartCMServerList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmartCMServerList.kt\nin/dragonbra/javasteam/steam/discovery/SmartCMServerList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,321:1\n1869#2,2:322\n1869#2,2:324\n1869#2,2:326\n1869#2,2:328\n774#2:331\n865#2,2:332\n774#2:334\n865#2,2:335\n1563#2:337\n1634#2,3:338\n1#3:330\n*S KotlinDebug\n*F\n+ 1 SmartCMServerList.kt\nin/dragonbra/javasteam/steam/discovery/SmartCMServerList\n*L\n150#1:322,2\n173#1:324,2\n181#1:326,2\n191#1:328,2\n208#1:331\n208#1:332,2\n214#1:334\n214#1:335,2\n299#1:337\n299#1:338,3\n*E\n"})
public final class SmartCMServerList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SteamConfiguration configuration;
    @NotNull
    private final List<ServerInfo> servers;
    @NotNull
    private Instant serversLastRefresh;
    @NotNull
    private Duration serverListBeforeRefreshTimeSpan;
    @NotNull
    private Duration badConnectionMemoryTimeSpan;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static String defaultServerWebSocket;
    @NotNull
    private static String defaultServerNetFilter;

    public SmartCMServerList(@NotNull SteamConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        this.servers = new ArrayList();
        Instant instant = Instant.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"MIN");
        this.serversLastRefresh = instant;
        Duration duration = Duration.ofDays(7L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofDays(...)");
        this.serverListBeforeRefreshTimeSpan = duration;
        Duration duration2 = Duration.ofMinutes(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(...)");
        this.badConnectionMemoryTimeSpan = duration2;
    }

    @NotNull
    public final Duration getServerListBeforeRefreshTimeSpan() {
        return this.serverListBeforeRefreshTimeSpan;
    }

    public final void setServerListBeforeRefreshTimeSpan(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.serverListBeforeRefreshTimeSpan = duration;
    }

    public static /* synthetic */ void getServerListBeforeRefreshTimeSpan$annotations() {
    }

    @NotNull
    public final Duration getBadConnectionMemoryTimeSpan() {
        return this.badConnectionMemoryTimeSpan;
    }

    public final void setBadConnectionMemoryTimeSpan(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.badConnectionMemoryTimeSpan = duration;
    }

    public static /* synthetic */ void getBadConnectionMemoryTimeSpan$annotations() {
    }

    private final void startFetchingServers() throws IOException {
        if (!((Collection)this.servers).isEmpty()) {
            if (Duration.between(this.serversLastRefresh, Instant.now()).compareTo(this.serverListBeforeRefreshTimeSpan) >= 0) {
                this.resolveServerList(true);
            }
        } else {
            SmartCMServerList.resolveServerList$default(this, false, 1, null);
        }
    }

    private final void resolveServerList(boolean forceRefresh) throws IOException {
        boolean forcedRefresh = forceRefresh;
        Instant providerRefreshTime = this.configuration.getServerListProvider().getLastServerListRefresh();
        boolean alreadyTriedDirectoryFetch = false;
        if (!forceRefresh && Duration.between(providerRefreshTime, Instant.now()).compareTo(this.serverListBeforeRefreshTimeSpan) >= 0) {
            forcedRefresh = true;
        }
        if (forcedRefresh && this.configuration.isAllowDirectoryFetch()) {
            logger.debug("Querying SteamDirectory for a fresh server list");
            List directoryList = SteamDirectory.load$default(this.configuration, null, 2, null);
            alreadyTriedDirectoryFetch = true;
            if (!((Collection)directoryList).isEmpty()) {
                logger.debug("Resolved " + directoryList.size() + " servers from SteamDirectory");
                this.replaceList(directoryList, true, Instant.now());
                return;
            }
            logger.debug("Could not query SteamDirectory, falling back to provider");
        } else {
            logger.debug("Resolving server list using the provider");
        }
        List<ServerRecord> serverList = this.configuration.getServerListProvider().fetchServerList();
        List endpointList = CollectionsKt.toList((Iterable)serverList);
        if (!((Collection)endpointList).isEmpty()) {
            logger.debug("Resolved " + endpointList.size() + " servers from the provider");
            this.replaceList(endpointList, false, providerRefreshTime);
            return;
        }
        if (!this.configuration.isAllowDirectoryFetch()) {
            logger.debug("Server list provider had no entries, and SteamConfiguration.isAllowDirectoryFetch is false");
            this.replaceList(CollectionsKt.emptyList(), false, Instant.MIN);
            return;
        }
        if (!alreadyTriedDirectoryFetch) {
            logger.debug("Server list provider had no entries, will query SteamDirectory");
            endpointList = SteamDirectory.load$default(this.configuration, null, 2, null);
            if (!((Collection)endpointList).isEmpty()) {
                logger.debug("Resolved " + endpointList.size() + " servers from SteamDirectory");
                this.replaceList(endpointList, true, Instant.now());
                return;
            }
        }
        logger.debug("Server list provider had no entries, SteamDirectory failed, falling back to default servers");
        Object[] objectArray = new ServerRecord[]{ServerRecord.Companion.createWebSocketServer(defaultServerWebSocket), ServerRecord.Companion.tryCreateSocketServer(defaultServerNetFilter)};
        endpointList = CollectionsKt.listOfNotNull((Object[])objectArray);
        this.replaceList(endpointList, false, Instant.MIN);
    }

    static /* synthetic */ void resolveServerList$default(SmartCMServerList smartCMServerList, boolean bl, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            bl = false;
        }
        smartCMServerList.resolveServerList(bl);
    }

    public final void resetOldScores() {
        Instant cutoff = Instant.now().minus(this.badConnectionMemoryTimeSpan);
        Iterable $this$forEach$iv = this.servers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Instant lastConnectionTime;
            ServerInfo serverInfo = (ServerInfo)element$iv;
            boolean bl = false;
            if (serverInfo.getLastBadConnectionTimeUtc() == null) continue;
            boolean bl2 = false;
            if (!lastConnectionTime.isBefore(cutoff)) continue;
            serverInfo.setLastBadConnectionTimeUtc(null);
        }
    }

    @JvmOverloads
    public final void replaceList(@NotNull List<ServerRecord> endpointList, boolean writeProvider, @Nullable Instant serversTime) {
        Intrinsics.checkNotNullParameter(endpointList, (String)"endpointList");
        List distinctEndPoints = CollectionsKt.distinct((Iterable)endpointList);
        Instant instant = serversTime;
        if (instant == null) {
            Instant instant2 = Instant.now();
            instant = instant2;
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
        }
        this.serversLastRefresh = instant;
        this.servers.clear();
        Iterable $this$forEach$iv = distinctEndPoints;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerRecord p0 = (ServerRecord)element$iv;
            boolean bl = false;
            this.addCore(p0);
        }
        if (writeProvider) {
            this.configuration.getServerListProvider().updateServerList(distinctEndPoints);
        }
    }

    public static /* synthetic */ void replaceList$default(SmartCMServerList smartCMServerList, List list, boolean bl, Instant instant, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            instant = null;
        }
        smartCMServerList.replaceList(list, bl, instant);
    }

    private final void addCore(ServerRecord endPoint) {
        Iterable $this$forEach$iv = endPoint.getProtocolTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProtocolTypes protocolType = (ProtocolTypes)((Object)element$iv);
            boolean bl = false;
            Intrinsics.checkNotNull((Object)((Object)protocolType));
            ServerInfo info = new ServerInfo(endPoint, protocolType);
            this.servers.add(info);
        }
    }

    public final void resetBadServers() {
        Iterable $this$forEach$iv = this.servers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerInfo serverInfo = (ServerInfo)element$iv;
            boolean bl = false;
            serverInfo.setLastBadConnectionTimeUtc(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean tryMark(@Nullable InetSocketAddress endPoint, @Nullable ProtocolTypes protocolTypes, @NotNull ServerQuality quality) {
        EnumSet<Enum> enumSet;
        Intrinsics.checkNotNullParameter((Object)((Object)quality), (String)"quality");
        SmartCMServerList smartCMServerList = this;
        InetSocketAddress inetSocketAddress = endPoint;
        ProtocolTypes protocolTypes2 = protocolTypes;
        if (protocolTypes2 != null) {
            void it;
            ProtocolTypes protocolTypes3 = protocolTypes2;
            InetSocketAddress inetSocketAddress2 = inetSocketAddress;
            SmartCMServerList smartCMServerList2 = smartCMServerList;
            boolean bl = false;
            EnumSet<Enum> enumSet2 = EnumSet.of((Enum)it);
            smartCMServerList = smartCMServerList2;
            inetSocketAddress = inetSocketAddress2;
            enumSet = enumSet2;
        } else {
            enumSet = null;
        }
        return smartCMServerList.tryMark(inetSocketAddress, enumSet, quality);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean tryMark(@Nullable InetSocketAddress endPoint, @Nullable EnumSet<ProtocolTypes> protocolTypes, @NotNull ServerQuality quality) {
        Iterable destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)quality), (String)"quality");
        if (endPoint == null || protocolTypes == null) {
            logger.error("Couldn't mark an endpoint " + quality.name() + ", skipping it");
            return false;
        }
        List serverInfos = null;
        if (quality == ServerQuality.GOOD) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.servers;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ServerInfo x = (ServerInfo)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)x.getRecord().getEndpoint(), (Object)endPoint) && protocolTypes.contains((Object)x.getProtocol()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            serverInfos = (List)destination$iv$iv;
        } else {
            void $this$filterTo$iv$iv;
            String host = endPoint.getHostString();
            Iterable $this$filter$iv = this.servers;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ServerInfo x = (ServerInfo)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)x.getRecord().getHost(), (Object)host)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            serverInfos = (List)destination$iv$iv2;
        }
        if (serverInfos.isEmpty()) {
            return false;
        }
        for (ServerInfo serverInfo : serverInfos) {
            logger.debug("Marking " + serverInfo.getRecord().getEndpoint() + " - " + serverInfo.getProtocol() + " as " + quality);
            this.markServerCore(serverInfo, quality);
        }
        return true;
    }

    private final void markServerCore(ServerInfo serverInfo, ServerQuality quality) {
        switch (WhenMappings.$EnumSwitchMapping$0[quality.ordinal()]) {
            case 1: {
                serverInfo.setLastBadConnectionTimeUtc(null);
                break;
            }
            case 2: {
                serverInfo.setLastBadConnectionTimeUtc(Instant.now());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final ServerRecord getNextServerCandidateInternal(EnumSet<ProtocolTypes> supportedProtocolTypes) {
        this.resetOldScores();
        Function1[] function1Array = new Function1[]{SmartCMServerList::getNextServerCandidateInternal$lambda$9, SmartCMServerList::getNextServerCandidateInternal$lambda$10};
        ServerInfo result = (ServerInfo)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)SequencesKt.mapIndexed((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.servers), arg_0 -> SmartCMServerList.getNextServerCandidateInternal$lambda$7(supportedProtocolTypes, arg_0)), SmartCMServerList::getNextServerCandidateInternal$lambda$8), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array)), SmartCMServerList::getNextServerCandidateInternal$lambda$11));
        if (result == null) {
            return null;
        }
        logger.debug("Next server candidate: " + result.getRecord().getEndpoint() + " (" + result.getProtocol() + ")");
        return new ServerRecord(result.getRecord().getEndpoint(), result.getProtocol());
    }

    @Nullable
    public final ServerRecord getNextServerCandidate(@NotNull EnumSet<ProtocolTypes> supportedProtocolTypes) {
        Object $this$getNextServerCandidate_u24lambda_u2412;
        Intrinsics.checkNotNullParameter(supportedProtocolTypes, (String)"supportedProtocolTypes");
        Object object = this;
        try {
            $this$getNextServerCandidate_u24lambda_u2412 = object;
            boolean bl = false;
            super.startFetchingServers();
            $this$getNextServerCandidate_u24lambda_u2412 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$getNextServerCandidate_u24lambda_u2412 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$getNextServerCandidate_u24lambda_u2412;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable error = throwable;
            boolean bl = false;
            logger.error("Error while fetching servers", error);
            return null;
        }
        Unit it = (Unit)object;
        boolean bl = false;
        return this.getNextServerCandidateInternal(supportedProtocolTypes);
    }

    @Nullable
    public final ServerRecord getNextServerCandidate(@NotNull ProtocolTypes supportedProtocolTypes) {
        Intrinsics.checkNotNullParameter((Object)((Object)supportedProtocolTypes), (String)"supportedProtocolTypes");
        EnumSet<Enum> enumSet = EnumSet.of((Enum)supportedProtocolTypes);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        return this.getNextServerCandidate(enumSet);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ServerRecord> getAllEndPoints() {
        List list;
        Object $this$getAllEndPoints_u24lambda_u2415;
        Object object = this;
        try {
            $this$getAllEndPoints_u24lambda_u2415 = object;
            boolean bl = false;
            super.startFetchingServers();
            $this$getAllEndPoints_u24lambda_u2415 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$getAllEndPoints_u24lambda_u2415 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$getAllEndPoints_u24lambda_u2415;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable == null) {
            void $this$mapTo$iv$iv;
            Unit it = (Unit)object;
            boolean bl = false;
            Iterable $this$map$iv = this.servers;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void s;
                ServerInfo serverInfo = (ServerInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(s.getRecord());
            }
            list = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        } else {
            Throwable error = throwable;
            boolean bl = false;
            logger.error("Failed to fetch end points", error);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final boolean forceRefreshServerList() {
        boolean bl;
        Object $this$forceRefreshServerList_u24lambda_u2419;
        Object object = this;
        try {
            $this$forceRefreshServerList_u24lambda_u2419 = object;
            boolean bl2 = false;
            super.resolveServerList(true);
            $this$forceRefreshServerList_u24lambda_u2419 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl2) {
            $this$forceRefreshServerList_u24lambda_u2419 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
        }
        object = $this$forceRefreshServerList_u24lambda_u2419;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable == null) {
            Unit it = (Unit)object;
            boolean bl3 = false;
            bl = true;
        } else {
            Throwable error = throwable;
            boolean bl4 = false;
            logger.error(error);
            bl = false;
        }
        return bl;
    }

    @JvmOverloads
    public final void replaceList(@NotNull List<ServerRecord> endpointList, boolean writeProvider) {
        Intrinsics.checkNotNullParameter(endpointList, (String)"endpointList");
        SmartCMServerList.replaceList$default(this, endpointList, writeProvider, null, 4, null);
    }

    @JvmOverloads
    public final void replaceList(@NotNull List<ServerRecord> endpointList) {
        Intrinsics.checkNotNullParameter(endpointList, (String)"endpointList");
        SmartCMServerList.replaceList$default(this, endpointList, false, null, 6, null);
    }

    private static final boolean getNextServerCandidateInternal$lambda$7(EnumSet $supportedProtocolTypes, ServerInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $supportedProtocolTypes.contains((Object)it.getProtocol());
    }

    private static final Pair getNextServerCandidateInternal$lambda$8(int index, ServerInfo server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        return TuplesKt.to((Object)server, (Object)index);
    }

    private static final Comparable getNextServerCandidateInternal$lambda$9(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Instant instant = ((ServerInfo)it.getFirst()).getLastBadConnectionTimeUtc();
        return instant != null ? (Comparable)instant : (Comparable)Instant.EPOCH;
    }

    private static final Comparable getNextServerCandidateInternal$lambda$10(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)it.getSecond();
    }

    private static final ServerInfo getNextServerCandidateInternal$lambda$11(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (ServerInfo)it.getFirst();
    }

    @NotNull
    public static final String getDefaultServerWebSocket() {
        return Companion.getDefaultServerWebSocket();
    }

    public static final void setDefaultServerWebSocket(@NotNull String string) {
        Companion.setDefaultServerWebSocket(string);
    }

    @NotNull
    public static final String getDefaultServerNetFilter() {
        return Companion.getDefaultServerNetFilter();
    }

    public static final void setDefaultServerNetFilter(@NotNull String string) {
        Companion.setDefaultServerNetFilter(string);
    }

    static {
        Logger logger = LogManager.getLogger(SmartCMServerList.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        SmartCMServerList.logger = logger;
        defaultServerWebSocket = "cmp1-sea1.steamserver.net:443";
        defaultServerNetFilter = "ext1-sea1.steamserver.net:27017";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\b\u0010\u0003\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\r\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000e\u0010\u0003\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\f\u00a8\u0006\u0011"}, d2={"Lin/dragonbra/javasteam/steam/discovery/SmartCMServerList$Companion;", "", "<init>", "()V", "logger", "Lin/dragonbra/javasteam/util/log/Logger;", "defaultServerWebSocket", "", "getDefaultServerWebSocket$annotations", "getDefaultServerWebSocket", "()Ljava/lang/String;", "setDefaultServerWebSocket", "(Ljava/lang/String;)V", "defaultServerNetFilter", "getDefaultServerNetFilter$annotations", "getDefaultServerNetFilter", "setDefaultServerNetFilter", "javasteam"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDefaultServerWebSocket() {
            return defaultServerWebSocket;
        }

        public final void setDefaultServerWebSocket(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            defaultServerWebSocket = string;
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultServerWebSocket$annotations() {
        }

        @NotNull
        public final String getDefaultServerNetFilter() {
            return defaultServerNetFilter;
        }

        public final void setDefaultServerNetFilter(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            defaultServerNetFilter = string;
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultServerNetFilter$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ServerQuality.values().length];
            try {
                nArray[ServerQuality.GOOD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServerQuality.BAD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

