/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamapps;

import in.dragonbra.javasteam.enums.ELicenseFlags;
import in.dragonbra.javasteam.enums.ELicenseType;
import in.dragonbra.javasteam.enums.EPaymentMethod;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver;
import java.util.Date;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR\u0011\u0010\u0014\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\tR\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\tR\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\tR\u0011\u0010/\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\t\u00a8\u00061"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamapps/License;", "", "license", "Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesClientserver$CMsgClientLicenseList$License;", "<init>", "(Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesClientserver$CMsgClientLicenseList$License;)V", "packageID", "", "getPackageID", "()I", "lastChangeNumber", "getLastChangeNumber", "timeCreated", "Ljava/util/Date;", "getTimeCreated", "()Ljava/util/Date;", "timeNextProcess", "getTimeNextProcess", "minuteLimit", "getMinuteLimit", "minutesUsed", "getMinutesUsed", "paymentMethod", "Lin/dragonbra/javasteam/enums/EPaymentMethod;", "getPaymentMethod", "()Lin/dragonbra/javasteam/enums/EPaymentMethod;", "licenseFlags", "Ljava/util/EnumSet;", "Lin/dragonbra/javasteam/enums/ELicenseFlags;", "getLicenseFlags", "()Ljava/util/EnumSet;", "purchaseCode", "", "getPurchaseCode", "()Ljava/lang/String;", "licenseType", "Lin/dragonbra/javasteam/enums/ELicenseType;", "getLicenseType", "()Lin/dragonbra/javasteam/enums/ELicenseType;", "territoryCode", "getTerritoryCode", "accessToken", "", "getAccessToken", "()J", "ownerAccountID", "getOwnerAccountID", "masterPackageID", "getMasterPackageID", "javasteam"})
public final class License {
    private final int packageID;
    private final int lastChangeNumber;
    @NotNull
    private final Date timeCreated;
    @NotNull
    private final Date timeNextProcess;
    private final int minuteLimit;
    private final int minutesUsed;
    @NotNull
    private final EPaymentMethod paymentMethod;
    @NotNull
    private final EnumSet<ELicenseFlags> licenseFlags;
    @NotNull
    private final String purchaseCode;
    @NotNull
    private final ELicenseType licenseType;
    private final int territoryCode;
    private final long accessToken;
    private final int ownerAccountID;
    private final int masterPackageID;

    public License(@NotNull SteammessagesClientserver.CMsgClientLicenseList.License license) {
        Intrinsics.checkNotNullParameter((Object)license, (String)"license");
        this.packageID = license.getPackageId();
        this.lastChangeNumber = license.getChangeNumber();
        this.timeCreated = new Date((long)license.getTimeCreated() * 1000L);
        this.timeNextProcess = new Date((long)license.getTimeNextProcess() * 1000L);
        this.minuteLimit = license.getMinuteLimit();
        this.minutesUsed = license.getMinutesUsed();
        EPaymentMethod ePaymentMethod = EPaymentMethod.from(license.getPaymentMethod());
        if (ePaymentMethod == null) {
            ePaymentMethod = EPaymentMethod.None;
        }
        this.paymentMethod = ePaymentMethod;
        EnumSet<ELicenseFlags> enumSet = ELicenseFlags.from(license.getFlags());
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"from(...)");
        this.licenseFlags = enumSet;
        String string = license.getPurchaseCountryCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPurchaseCountryCode(...)");
        this.purchaseCode = string;
        ELicenseType eLicenseType = ELicenseType.from(license.getLicenseType());
        if (eLicenseType == null) {
            eLicenseType = ELicenseType.NoLicense;
        }
        this.licenseType = eLicenseType;
        this.territoryCode = license.getTerritoryCode();
        this.accessToken = license.getAccessToken();
        this.ownerAccountID = license.getOwnerId();
        this.masterPackageID = license.getMasterPackageId();
    }

    public final int getPackageID() {
        return this.packageID;
    }

    public final int getLastChangeNumber() {
        return this.lastChangeNumber;
    }

    @NotNull
    public final Date getTimeCreated() {
        return this.timeCreated;
    }

    @NotNull
    public final Date getTimeNextProcess() {
        return this.timeNextProcess;
    }

    public final int getMinuteLimit() {
        return this.minuteLimit;
    }

    public final int getMinutesUsed() {
        return this.minutesUsed;
    }

    @NotNull
    public final EPaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    @NotNull
    public final EnumSet<ELicenseFlags> getLicenseFlags() {
        return this.licenseFlags;
    }

    @NotNull
    public final String getPurchaseCode() {
        return this.purchaseCode;
    }

    @NotNull
    public final ELicenseType getLicenseType() {
        return this.licenseType;
    }

    public final int getTerritoryCode() {
        return this.territoryCode;
    }

    public final long getAccessToken() {
        return this.accessToken;
    }

    public final int getOwnerAccountID() {
        return this.ownerAccountID;
    }

    public final int getMasterPackageID() {
        return this.masterPackageID;
    }
}

