/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamapps;

import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverAppinfo;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.KeyValue;
import in.dragonbra.javasteam.util.Strings;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import in.dragonbra.javasteam.util.stream.BinaryReader;
import in.dragonbra.javasteam.util.stream.MemoryStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 '2\u00020\u0001:\u0001'B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0013R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013R\u001e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0013R\u0013\u0010\u001f\u001a\u0004\u0018\u00010 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0013\u00a8\u0006("}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamapps/PICSProductInfo;", "Lin/dragonbra/javasteam/steam/steamclient/callbackmgr/CallbackMsg;", "parentResponse", "Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesClientserverAppinfo$CMsgClientPICSProductInfoResponse$Builder;", "appInfo", "Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesClientserverAppinfo$CMsgClientPICSProductInfoResponse$AppInfo;", "<init>", "(Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesClientserverAppinfo$CMsgClientPICSProductInfoResponse$Builder;Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesClientserverAppinfo$CMsgClientPICSProductInfoResponse$AppInfo;)V", "packageInfo", "Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesClientserverAppinfo$CMsgClientPICSProductInfoResponse$PackageInfo;", "(Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesClientserverAppinfo$CMsgClientPICSProductInfoResponse$PackageInfo;)V", "id", "", "getId", "()I", "changeNumber", "getChangeNumber", "isMissingToken", "", "()Z", "shaHash", "", "getShaHash", "()[B", "keyValues", "Lin/dragonbra/javasteam/types/KeyValue;", "getKeyValues", "()Lin/dragonbra/javasteam/types/KeyValue;", "value", "isOnlyPublic", "isUseHttp", "httpUri", "Ljava/net/URI;", "getHttpUri", "()Ljava/net/URI;", "httpHost", "", "hasValidHttpUri", "getHasValidHttpUri", "Companion", "javasteam"})
public final class PICSProductInfo
extends CallbackMsg {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int id;
    private final int changeNumber;
    private final boolean isMissingToken;
    @Nullable
    private final byte[] shaHash;
    @NotNull
    private final KeyValue keyValues;
    private boolean isOnlyPublic;
    private boolean isUseHttp;
    @Nullable
    private String httpHost;
    private static final Logger logger = LogManager.getLogger(PICSProductInfo.class);

    public final int getId() {
        return this.id;
    }

    public final int getChangeNumber() {
        return this.changeNumber;
    }

    public final boolean isMissingToken() {
        return this.isMissingToken;
    }

    @Nullable
    public final byte[] getShaHash() {
        return this.shaHash;
    }

    @NotNull
    public final KeyValue getKeyValues() {
        return this.keyValues;
    }

    public final boolean isOnlyPublic() {
        return this.isOnlyPublic;
    }

    public final boolean isUseHttp() {
        return this.isUseHttp;
    }

    @Nullable
    public final URI getHttpUri() {
        if (!this.getHasValidHttpUri()) {
            return null;
        }
        String string = Strings.toHex(this.shaHash);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHex(...)");
        String string2 = StringsKt.replace$default((String)string, (String)"-", (String)"", (boolean)false, (int)4, null);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String shaString = string3;
        String string4 = "https://%s/appinfo/%d/sha/%s.txt.gz";
        Object[] objectArray = new Object[]{this.httpHost, this.id, shaString};
        String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        String uriString = string5;
        return URI.create(uriString);
    }

    private final boolean getHasValidHttpUri() {
        CharSequence charSequence;
        return this.shaHash != null && !(this.shaHash.length == 0) && !((charSequence = (CharSequence)this.httpHost) == null || charSequence.length() == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PICSProductInfo(@NotNull SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoResponse.Builder parentResponse, @NotNull SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoResponse.AppInfo appInfo) {
        Intrinsics.checkNotNullParameter((Object)parentResponse, (String)"parentResponse");
        Intrinsics.checkNotNullParameter((Object)appInfo, (String)"appInfo");
        this.id = appInfo.getAppid();
        this.changeNumber = appInfo.getChangeNumber();
        this.isMissingToken = appInfo.getMissingToken();
        this.shaHash = appInfo.getSha().toByteArray();
        this.keyValues = new KeyValue(null, null, 3, null);
        if (appInfo.hasBuffer() && !appInfo.getBuffer().isEmpty()) {
            try {
                Closeable closeable = new MemoryStream(appInfo.getBuffer().toByteArray(), 0, appInfo.getBuffer().size() - 1);
                Throwable throwable = null;
                try {
                    MemoryStream ms = (MemoryStream)closeable;
                    boolean bl = false;
                    Boolean bl2 = this.keyValues.readAsText(ms);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                logger.error("failed to read buffer", e);
            }
        }
        this.isOnlyPublic = appInfo.getOnlyPublic();
        this.httpHost = parentResponse.getHttpHost();
        this.isUseHttp = this.getHttpUri() != null && appInfo.getSize() >= parentResponse.getHttpMinSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PICSProductInfo(@NotNull SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoResponse.PackageInfo packageInfo) {
        Intrinsics.checkNotNullParameter((Object)packageInfo, (String)"packageInfo");
        this.id = packageInfo.getPackageid();
        this.changeNumber = packageInfo.getChangeNumber();
        this.isMissingToken = packageInfo.getMissingToken();
        this.shaHash = packageInfo.getSha().toByteArray();
        this.keyValues = new KeyValue(null, null, 3, null);
        if (packageInfo.hasBuffer()) {
            try {
                Closeable closeable = new BinaryReader(new ByteArrayInputStream(packageInfo.getBuffer().toByteArray()));
                Throwable throwable = null;
                try {
                    BinaryReader br = (BinaryReader)closeable;
                    boolean bl = false;
                    br.readInt();
                    Boolean bl2 = this.keyValues.tryReadAsBinary(br);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                logger.error("failed to read buffer", e);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamapps/PICSProductInfo$Companion;", "", "<init>", "()V", "logger", "Lin/dragonbra/javasteam/util/log/Logger;", "kotlin.jvm.PlatformType", "javasteam"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

