/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamapps.callback;

import in.dragonbra.javasteam.base.ClientMsg;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.generated.MsgClientUpdateGuestPassesList;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.KeyValue;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import in.dragonbra.javasteam.util.stream.MemoryStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamapps/callback/GuestPassListCallback;", "Lin/dragonbra/javasteam/steam/steamclient/callbackmgr/CallbackMsg;", "packetMsg", "Lin/dragonbra/javasteam/base/IPacketMsg;", "<init>", "(Lin/dragonbra/javasteam/base/IPacketMsg;)V", "result", "Lin/dragonbra/javasteam/enums/EResult;", "getResult", "()Lin/dragonbra/javasteam/enums/EResult;", "countGuestPassesToGive", "", "getCountGuestPassesToGive", "()I", "countGuestPassesToRedeem", "getCountGuestPassesToRedeem", "guestPasses", "", "Lin/dragonbra/javasteam/types/KeyValue;", "getGuestPasses", "()Ljava/util/List;", "Companion", "javasteam"})
public final class GuestPassListCallback
extends CallbackMsg {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EResult result;
    private final int countGuestPassesToGive;
    private final int countGuestPassesToRedeem;
    @NotNull
    private final List<KeyValue> guestPasses;
    private static final Logger logger = LogManager.getLogger(GuestPassListCallback.class);

    public GuestPassListCallback(@NotNull IPacketMsg packetMsg) {
        Intrinsics.checkNotNullParameter((Object)packetMsg, (String)"packetMsg");
        ClientMsg<MsgClientUpdateGuestPassesList> guestPassesResp = new ClientMsg<MsgClientUpdateGuestPassesList>(MsgClientUpdateGuestPassesList.class, packetMsg);
        MsgClientUpdateGuestPassesList msg = guestPassesResp.getBody();
        EResult eResult = msg.getResult();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)eResult), (String)"getResult(...)");
        this.result = eResult;
        this.countGuestPassesToGive = msg.getCountGuestPassesToGive();
        this.countGuestPassesToRedeem = msg.getCountGuestPassesToRedeem();
        List tempList = new ArrayList();
        try {
            int n = this.countGuestPassesToGive + this.countGuestPassesToRedeem;
            for (int i2 = 0; i2 < n; ++i2) {
                KeyValue kv = new KeyValue(null, null, 3, null);
                MemoryStream memoryStream = guestPassesResp.getPayload();
                Intrinsics.checkNotNullExpressionValue((Object)memoryStream, (String)"getPayload(...)");
                kv.tryReadAsBinary(memoryStream);
                tempList.add(kv);
            }
        }
        catch (IOException e) {
            logger.error("failed to read guest passes", e);
        }
        this.guestPasses = CollectionsKt.toList((Iterable)tempList);
    }

    @NotNull
    public final EResult getResult() {
        return this.result;
    }

    public final int getCountGuestPassesToGive() {
        return this.countGuestPassesToGive;
    }

    public final int getCountGuestPassesToRedeem() {
        return this.countGuestPassesToRedeem;
    }

    @NotNull
    public final List<KeyValue> getGuestPasses() {
        return this.guestPasses;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamapps/callback/GuestPassListCallback$Companion;", "", "<init>", "()V", "logger", "Lin/dragonbra/javasteam/util/log/Logger;", "kotlin.jvm.PlatformType", "javasteam"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

