/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamapps.callback;

import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EPurchaseResultDetail;
import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver2;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.JobID;
import in.dragonbra.javasteam.types.KeyValue;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import in.dragonbra.javasteam.util.stream.MemoryStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamapps/callback/PurchaseResponseCallback;", "Lin/dragonbra/javasteam/steam/steamclient/callbackmgr/CallbackMsg;", "packetMsg", "Lin/dragonbra/javasteam/base/IPacketMsg;", "<init>", "(Lin/dragonbra/javasteam/base/IPacketMsg;)V", "result", "Lin/dragonbra/javasteam/enums/EResult;", "getResult", "()Lin/dragonbra/javasteam/enums/EResult;", "purchaseResultDetail", "Lin/dragonbra/javasteam/enums/EPurchaseResultDetail;", "getPurchaseResultDetail", "()Lin/dragonbra/javasteam/enums/EPurchaseResultDetail;", "purchaseReceiptInfo", "Lin/dragonbra/javasteam/types/KeyValue;", "getPurchaseReceiptInfo", "()Lin/dragonbra/javasteam/types/KeyValue;", "Companion", "javasteam"})
public final class PurchaseResponseCallback
extends CallbackMsg {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EResult result;
    @Nullable
    private final EPurchaseResultDetail purchaseResultDetail;
    @NotNull
    private final KeyValue purchaseReceiptInfo;
    private static final Logger logger = LogManager.getLogger(PurchaseResponseCallback.class);

    public PurchaseResponseCallback(@NotNull IPacketMsg packetMsg) {
        Intrinsics.checkNotNullParameter((Object)packetMsg, (String)"packetMsg");
        ClientMsgProtobuf purchaseResponse = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientPurchaseResponse.class, packetMsg);
        SteammessagesClientserver2.CMsgClientPurchaseResponse.Builder msg = (SteammessagesClientserver2.CMsgClientPurchaseResponse.Builder)purchaseResponse.getBody();
        JobID jobID = purchaseResponse.getTargetJobID();
        Intrinsics.checkNotNullExpressionValue((Object)jobID, (String)"getTargetJobID(...)");
        this.setJobID(jobID);
        EResult eResult = EResult.from(msg.getEresult());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)eResult), (String)"from(...)");
        this.result = eResult;
        this.purchaseResultDetail = EPurchaseResultDetail.from(msg.getPurchaseResultDetails());
        this.purchaseReceiptInfo = new KeyValue(null, null, 3, null);
        if (msg.getPurchaseReceiptInfo() != null) {
            try {
                MemoryStream ms = new MemoryStream(msg.getPurchaseReceiptInfo().toByteArray());
                this.purchaseReceiptInfo.tryReadAsBinary(ms);
            }
            catch (Exception e) {
                logger.error("Failed to read purchase receipt info", e);
            }
        }
    }

    @NotNull
    public final EResult getResult() {
        return this.result;
    }

    @Nullable
    public final EPurchaseResultDetail getPurchaseResultDetail() {
        return this.purchaseResultDetail;
    }

    @NotNull
    public final KeyValue getPurchaseReceiptInfo() {
        return this.purchaseReceiptInfo;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamapps/callback/PurchaseResponseCallback$Companion;", "", "<init>", "()V", "logger", "Lin/dragonbra/javasteam/util/log/Logger;", "kotlin.jvm.PlatformType", "javasteam"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

