/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamcloud.callback;

import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverUfs;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.JobID;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\rR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamcloud/callback/SingleFileInfoCallback;", "Lin/dragonbra/javasteam/steam/steamclient/callbackmgr/CallbackMsg;", "packetMsg", "Lin/dragonbra/javasteam/base/IPacketMsg;", "<init>", "(Lin/dragonbra/javasteam/base/IPacketMsg;)V", "result", "Lin/dragonbra/javasteam/enums/EResult;", "getResult", "()Lin/dragonbra/javasteam/enums/EResult;", "appID", "", "getAppID", "()I", "fileName", "", "getFileName", "()Ljava/lang/String;", "shaHash", "", "getShaHash", "()[B", "timestamp", "Ljava/util/Date;", "getTimestamp", "()Ljava/util/Date;", "fileSize", "getFileSize", "isExplicitDelete", "", "()Z", "javasteam"})
public final class SingleFileInfoCallback
extends CallbackMsg {
    @NotNull
    private final EResult result;
    private final int appID;
    @NotNull
    private final String fileName;
    @NotNull
    private final byte[] shaHash;
    @NotNull
    private final Date timestamp;
    private final int fileSize;
    private final boolean isExplicitDelete;

    public SingleFileInfoCallback(@NotNull IPacketMsg packetMsg) {
        Intrinsics.checkNotNullParameter((Object)packetMsg, (String)"packetMsg");
        ClientMsgProtobuf infoResponse = new ClientMsgProtobuf(SteammessagesClientserverUfs.CMsgClientUFSGetSingleFileInfoResponse.class, packetMsg);
        SteammessagesClientserverUfs.CMsgClientUFSGetSingleFileInfoResponse.Builder msg = (SteammessagesClientserverUfs.CMsgClientUFSGetSingleFileInfoResponse.Builder)infoResponse.getBody();
        JobID jobID = infoResponse.getTargetJobID();
        Intrinsics.checkNotNullExpressionValue((Object)jobID, (String)"getTargetJobID(...)");
        this.setJobID(jobID);
        EResult eResult = EResult.from(msg.getEresult());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)eResult), (String)"from(...)");
        this.result = eResult;
        this.appID = msg.getAppId();
        String string = msg.getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        this.fileName = string;
        byte[] byArray = msg.getShaFile().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        this.shaHash = byArray;
        this.timestamp = new Date(msg.getTimeStamp() * 1000L);
        this.fileSize = msg.getRawFileSize();
        this.isExplicitDelete = msg.getIsExplicitDelete();
    }

    @NotNull
    public final EResult getResult() {
        return this.result;
    }

    public final int getAppID() {
        return this.appID;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @NotNull
    public final byte[] getShaHash() {
        return this.shaHash;
    }

    @NotNull
    public final Date getTimestamp() {
        return this.timestamp;
    }

    public final int getFileSize() {
        return this.fileSize;
    }

    public final boolean isExplicitDelete() {
        return this.isExplicitDelete;
    }
}

