/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamfriends.callback;

import in.dragonbra.javasteam.base.ClientMsg;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EChatRoomEnterResponse;
import in.dragonbra.javasteam.enums.EChatRoomType;
import in.dragonbra.javasteam.generated.MsgClientChatEnter;
import in.dragonbra.javasteam.steam.handlers.steamfriends.ChatMemberInfo;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.SteamID;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import in.dragonbra.javasteam.util.stream.BinaryReader;
import in.dragonbra.javasteam.util.stream.MemoryStream;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001e\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020!@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R*\u0010'\u001a\b\u0012\u0004\u0012\u00020&0%2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020&0%@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u0006+"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamfriends/callback/ChatEnterCallback;", "Lin/dragonbra/javasteam/steam/steamclient/callbackmgr/CallbackMsg;", "packetMsg", "Lin/dragonbra/javasteam/base/IPacketMsg;", "<init>", "(Lin/dragonbra/javasteam/base/IPacketMsg;)V", "chatID", "Lin/dragonbra/javasteam/types/SteamID;", "getChatID", "()Lin/dragonbra/javasteam/types/SteamID;", "friendID", "getFriendID", "chatRoomType", "Lin/dragonbra/javasteam/enums/EChatRoomType;", "getChatRoomType", "()Lin/dragonbra/javasteam/enums/EChatRoomType;", "ownerID", "getOwnerID", "clanID", "getClanID", "chatFlags", "", "getChatFlags", "()B", "enterResponse", "Lin/dragonbra/javasteam/enums/EChatRoomEnterResponse;", "getEnterResponse", "()Lin/dragonbra/javasteam/enums/EChatRoomEnterResponse;", "numChatMembers", "", "getNumChatMembers", "()I", "value", "", "chatRoomName", "getChatRoomName", "()Ljava/lang/String;", "", "Lin/dragonbra/javasteam/steam/handlers/steamfriends/ChatMemberInfo;", "chatMembers", "getChatMembers", "()Ljava/util/List;", "Companion", "javasteam"})
public final class ChatEnterCallback
extends CallbackMsg {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SteamID chatID;
    @NotNull
    private final SteamID friendID;
    @NotNull
    private final EChatRoomType chatRoomType;
    @NotNull
    private final SteamID ownerID;
    @NotNull
    private final SteamID clanID;
    private final byte chatFlags;
    @NotNull
    private final EChatRoomEnterResponse enterResponse;
    private final int numChatMembers;
    @NotNull
    private String chatRoomName;
    @NotNull
    private List<ChatMemberInfo> chatMembers;
    private static final Logger logger = LogManager.getLogger(ChatEnterCallback.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChatEnterCallback(@NotNull IPacketMsg packetMsg) {
        Intrinsics.checkNotNullParameter((Object)packetMsg, (String)"packetMsg");
        this.chatRoomName = "";
        this.chatMembers = CollectionsKt.emptyList();
        ClientMsg<MsgClientChatEnter> chatEnter = new ClientMsg<MsgClientChatEnter>(MsgClientChatEnter.class, packetMsg);
        MsgClientChatEnter msg = chatEnter.getBody();
        SteamID steamID = msg.getSteamIdChat();
        Intrinsics.checkNotNullExpressionValue((Object)steamID, (String)"getSteamIdChat(...)");
        this.chatID = steamID;
        SteamID steamID2 = msg.getSteamIdFriend();
        Intrinsics.checkNotNullExpressionValue((Object)steamID2, (String)"getSteamIdFriend(...)");
        this.friendID = steamID2;
        EChatRoomType eChatRoomType = msg.getChatRoomType();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)eChatRoomType), (String)"getChatRoomType(...)");
        this.chatRoomType = eChatRoomType;
        SteamID steamID3 = msg.getSteamIdOwner();
        Intrinsics.checkNotNullExpressionValue((Object)steamID3, (String)"getSteamIdOwner(...)");
        this.ownerID = steamID3;
        SteamID steamID4 = msg.getSteamIdClan();
        Intrinsics.checkNotNullExpressionValue((Object)steamID4, (String)"getSteamIdClan(...)");
        this.clanID = steamID4;
        this.chatFlags = msg.getChatFlags();
        EChatRoomEnterResponse eChatRoomEnterResponse = msg.getEnterResponse();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)eChatRoomEnterResponse), (String)"getEnterResponse(...)");
        this.enterResponse = eChatRoomEnterResponse;
        this.numChatMembers = msg.getNumMembers();
        MemoryStream ms = chatEnter.getPayload();
        try {
            Closeable closeable = new BinaryReader(ms);
            Throwable throwable = null;
            try {
                BinaryReader br = (BinaryReader)closeable;
                boolean bl = false;
                String string = br.readNullTermString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readNullTermString(...)");
                this.chatRoomName = string;
                if (this.enterResponse == EChatRoomEnterResponse.Success) {
                    List memberList = new ArrayList();
                    int n = this.numChatMembers;
                    for (int i2 = 0; i2 < n; ++i2) {
                        ChatMemberInfo memberInfo = new ChatMemberInfo();
                        memberInfo.readFromStream(br);
                        memberList.add(memberInfo);
                    }
                    this.chatMembers = CollectionsKt.toList((Iterable)memberList);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            logger.error("Failed to read chat enter info.", e);
        }
    }

    @NotNull
    public final SteamID getChatID() {
        return this.chatID;
    }

    @NotNull
    public final SteamID getFriendID() {
        return this.friendID;
    }

    @NotNull
    public final EChatRoomType getChatRoomType() {
        return this.chatRoomType;
    }

    @NotNull
    public final SteamID getOwnerID() {
        return this.ownerID;
    }

    @NotNull
    public final SteamID getClanID() {
        return this.clanID;
    }

    public final byte getChatFlags() {
        return this.chatFlags;
    }

    @NotNull
    public final EChatRoomEnterResponse getEnterResponse() {
        return this.enterResponse;
    }

    public final int getNumChatMembers() {
        return this.numChatMembers;
    }

    @NotNull
    public final String getChatRoomName() {
        return this.chatRoomName;
    }

    @NotNull
    public final List<ChatMemberInfo> getChatMembers() {
        return this.chatMembers;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamfriends/callback/ChatEnterCallback$Companion;", "", "<init>", "()V", "logger", "Lin/dragonbra/javasteam/util/log/Logger;", "kotlin.jvm.PlatformType", "javasteam"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

