/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamfriends.callback;

import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EAccountFlags;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver;
import in.dragonbra.javasteam.steam.handlers.steamfriends.Event;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.SteamID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0011R\"\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\u001e\u0010!\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001eR\u001e\u0010#\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001eR\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020'0&\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010)\u00a8\u0006,"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamfriends/callback/ClanStateCallback;", "Lin/dragonbra/javasteam/steam/steamclient/callbackmgr/CallbackMsg;", "packetMsg", "Lin/dragonbra/javasteam/base/IPacketMsg;", "<init>", "(Lin/dragonbra/javasteam/base/IPacketMsg;)V", "clanID", "Lin/dragonbra/javasteam/types/SteamID;", "getClanID", "()Lin/dragonbra/javasteam/types/SteamID;", "accountFlags", "Ljava/util/EnumSet;", "Lin/dragonbra/javasteam/enums/EAccountFlags;", "getAccountFlags", "()Ljava/util/EnumSet;", "isChatRoomPrivate", "", "()Z", "value", "", "clanName", "getClanName", "()Ljava/lang/String;", "", "avatarHash", "getAvatarHash", "()[B", "", "memberTotalCount", "getMemberTotalCount", "()I", "memberOnlineCount", "getMemberOnlineCount", "memberChattingCount", "getMemberChattingCount", "memberInGameCount", "getMemberInGameCount", "events", "", "Lin/dragonbra/javasteam/steam/handlers/steamfriends/Event;", "getEvents", "()Ljava/util/List;", "announcements", "getAnnouncements", "javasteam"})
@SourceDebugExtension(value={"SMAP\nClanStateCallback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClanStateCallback.kt\nin/dragonbra/javasteam/steam/handlers/steamfriends/callback/ClanStateCallback\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1563#2:105\n1634#2,3:106\n1563#2:109\n1634#2,3:110\n*S KotlinDebug\n*F\n+ 1 ClanStateCallback.kt\nin/dragonbra/javasteam/steam/handlers/steamfriends/callback/ClanStateCallback\n*L\n99#1:105\n99#1:106,3\n101#1:109\n101#1:110,3\n*E\n"})
public final class ClanStateCallback
extends CallbackMsg {
    @NotNull
    private final SteamID clanID;
    @NotNull
    private final EnumSet<EAccountFlags> accountFlags;
    private final boolean isChatRoomPrivate;
    @Nullable
    private String clanName;
    @NotNull
    private byte[] avatarHash;
    private int memberTotalCount;
    private int memberOnlineCount;
    private int memberChattingCount;
    private int memberInGameCount;
    @NotNull
    private final List<Event> events;
    @NotNull
    private final List<Event> announcements;

    public ClanStateCallback(@NotNull IPacketMsg packetMsg) {
        SteammessagesClientserver.CMsgClientClanState.Event it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)packetMsg, (String)"packetMsg");
        this.avatarHash = new byte[0];
        ClientMsgProtobuf clanState = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientClanState.class, packetMsg);
        SteammessagesClientserver.CMsgClientClanState.Builder msg = (SteammessagesClientserver.CMsgClientClanState.Builder)clanState.getBody();
        this.clanID = new SteamID(msg.getSteamidClan());
        EnumSet<EAccountFlags> enumSet = EAccountFlags.from(msg.getClanAccountFlags());
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"from(...)");
        this.accountFlags = enumSet;
        this.isChatRoomPrivate = msg.getChatRoomPrivate();
        if (msg.hasNameInfo()) {
            this.clanName = msg.getNameInfo().getClanName();
            byte[] byArray = msg.getNameInfo().getShaAvatar().toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            this.avatarHash = byArray;
        }
        if (msg.hasUserCounts()) {
            this.memberTotalCount = msg.getUserCounts().getMembers();
            this.memberOnlineCount = msg.getUserCounts().getOnline();
            this.memberChattingCount = msg.getUserCounts().getChatting();
            this.memberInGameCount = msg.getUserCounts().getInGame();
        }
        List<SteammessagesClientserver.CMsgClientClanState.Event> list = msg.getEventsList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getEventsList(...)");
        Iterable iterable = list;
        ClanStateCallback clanStateCallback = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SteammessagesClientserver.CMsgClientClanState.Event event = (SteammessagesClientserver.CMsgClientClanState.Event)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new Event(it));
        }
        clanStateCallback.events = (List)destination$iv$iv;
        List<SteammessagesClientserver.CMsgClientClanState.Event> list2 = msg.getAnnouncementsList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getAnnouncementsList(...)");
        $this$map$iv = list2;
        clanStateCallback = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SteammessagesClientserver.CMsgClientClanState.Event)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new Event(it));
        }
        clanStateCallback.announcements = (List)destination$iv$iv;
    }

    @NotNull
    public final SteamID getClanID() {
        return this.clanID;
    }

    @NotNull
    public final EnumSet<EAccountFlags> getAccountFlags() {
        return this.accountFlags;
    }

    public final boolean isChatRoomPrivate() {
        return this.isChatRoomPrivate;
    }

    @Nullable
    public final String getClanName() {
        return this.clanName;
    }

    @NotNull
    public final byte[] getAvatarHash() {
        return this.avatarHash;
    }

    public final int getMemberTotalCount() {
        return this.memberTotalCount;
    }

    public final int getMemberOnlineCount() {
        return this.memberOnlineCount;
    }

    public final int getMemberChattingCount() {
        return this.memberChattingCount;
    }

    public final int getMemberInGameCount() {
        return this.memberInGameCount;
    }

    @NotNull
    public final List<Event> getEvents() {
        return this.events;
    }

    @NotNull
    public final List<Event> getAnnouncements() {
        return this.announcements;
    }
}

