/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamfriends.callback;

import in.dragonbra.javasteam.enums.EClientPersonaStateFlag;
import in.dragonbra.javasteam.enums.EPersonaState;
import in.dragonbra.javasteam.enums.EPersonaStateFlag;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverFriends;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.GameID;
import in.dragonbra.javasteam.types.SteamID;
import in.dragonbra.javasteam.util.NetHelpers;
import java.net.InetAddress;
import java.util.Date;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\nR\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0019R\u0011\u0010(\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0019R\u0011\u0010*\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u000eR\u0011\u0010,\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u00100\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010!R\u0011\u00102\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010/R\u0011\u00104\u001a\u000205\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0011\u00108\u001a\u000205\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00107R\u0011\u0010:\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u0019R\u0011\u0010<\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010!R\u0011\u0010>\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010\u0019\u00a8\u0006@"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamfriends/callback/PersonaStateCallback;", "Lin/dragonbra/javasteam/steam/steamclient/callbackmgr/CallbackMsg;", "friend", "Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesClientserverFriends$CMsgClientPersonaState$Friend;", "statusFlags", "Ljava/util/EnumSet;", "Lin/dragonbra/javasteam/enums/EClientPersonaStateFlag;", "<init>", "(Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesClientserverFriends$CMsgClientPersonaState$Friend;Ljava/util/EnumSet;)V", "getStatusFlags", "()Ljava/util/EnumSet;", "friendID", "Lin/dragonbra/javasteam/types/SteamID;", "getFriendID", "()Lin/dragonbra/javasteam/types/SteamID;", "state", "Lin/dragonbra/javasteam/enums/EPersonaState;", "getState", "()Lin/dragonbra/javasteam/enums/EPersonaState;", "stateFlags", "Lin/dragonbra/javasteam/enums/EPersonaStateFlag;", "getStateFlags", "gameAppID", "", "getGameAppID", "()I", "gameID", "Lin/dragonbra/javasteam/types/GameID;", "getGameID", "()Lin/dragonbra/javasteam/types/GameID;", "gameName", "", "getGameName", "()Ljava/lang/String;", "gameServerIP", "Ljava/net/InetAddress;", "getGameServerIP", "()Ljava/net/InetAddress;", "gameServerPort", "getGameServerPort", "queryPort", "getQueryPort", "sourceSteamID", "getSourceSteamID", "gameDataBlob", "", "getGameDataBlob", "()[B", "name", "getName", "avatarHash", "getAvatarHash", "lastLogOff", "Ljava/util/Date;", "getLastLogOff", "()Ljava/util/Date;", "lastLogOn", "getLastLogOn", "clanRank", "getClanRank", "clanTag", "getClanTag", "onlineSessionInstances", "getOnlineSessionInstances", "javasteam"})
public final class PersonaStateCallback
extends CallbackMsg {
    @NotNull
    private final EnumSet<EClientPersonaStateFlag> statusFlags;
    @NotNull
    private final SteamID friendID;
    @NotNull
    private final EPersonaState state;
    @NotNull
    private final EnumSet<EPersonaStateFlag> stateFlags;
    private final int gameAppID;
    @NotNull
    private final GameID gameID;
    @NotNull
    private final String gameName;
    @NotNull
    private final InetAddress gameServerIP;
    private final int gameServerPort;
    private final int queryPort;
    @NotNull
    private final SteamID sourceSteamID;
    @NotNull
    private final byte[] gameDataBlob;
    @NotNull
    private final String name;
    @NotNull
    private final byte[] avatarHash;
    @NotNull
    private final Date lastLogOff;
    @NotNull
    private final Date lastLogOn;
    private final int clanRank;
    @NotNull
    private final String clanTag;
    private final int onlineSessionInstances;

    public PersonaStateCallback(@NotNull SteammessagesClientserverFriends.CMsgClientPersonaState.Friend friend, @NotNull EnumSet<EClientPersonaStateFlag> statusFlags) {
        Intrinsics.checkNotNullParameter((Object)friend, (String)"friend");
        Intrinsics.checkNotNullParameter(statusFlags, (String)"statusFlags");
        this.statusFlags = statusFlags;
        this.friendID = new SteamID(friend.getFriendid());
        EPersonaState ePersonaState = EPersonaState.from(friend.getPersonaState());
        if (ePersonaState == null) {
            ePersonaState = EPersonaState.Offline;
        }
        this.state = ePersonaState;
        EnumSet<EPersonaStateFlag> enumSet = EPersonaStateFlag.from(friend.getPersonaStateFlags());
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"from(...)");
        this.stateFlags = enumSet;
        this.gameAppID = friend.getGamePlayedAppId();
        this.gameID = new GameID(friend.getGameid());
        String string = friend.getGameName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGameName(...)");
        this.gameName = string;
        this.gameServerIP = NetHelpers.getIPAddress(friend.getGameServerIp());
        this.gameServerPort = friend.getGameServerPort();
        this.queryPort = friend.getQueryPort();
        this.sourceSteamID = new SteamID(friend.getSteamidSource());
        byte[] byArray = friend.getGameDataBlob().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        this.gameDataBlob = byArray;
        String string2 = friend.getPlayerName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPlayerName(...)");
        this.name = string2;
        byte[] byArray2 = friend.getAvatarHash().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
        this.avatarHash = byArray2;
        this.lastLogOff = new Date((long)friend.getLastLogoff() * 1000L);
        this.lastLogOn = new Date((long)friend.getLastLogon() * 1000L);
        this.clanRank = friend.getClanRank();
        String string3 = friend.getClanTag();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getClanTag(...)");
        this.clanTag = string3;
        this.onlineSessionInstances = friend.getOnlineSessionInstances();
    }

    @NotNull
    public final EnumSet<EClientPersonaStateFlag> getStatusFlags() {
        return this.statusFlags;
    }

    @NotNull
    public final SteamID getFriendID() {
        return this.friendID;
    }

    @NotNull
    public final EPersonaState getState() {
        return this.state;
    }

    @NotNull
    public final EnumSet<EPersonaStateFlag> getStateFlags() {
        return this.stateFlags;
    }

    public final int getGameAppID() {
        return this.gameAppID;
    }

    @NotNull
    public final GameID getGameID() {
        return this.gameID;
    }

    @NotNull
    public final String getGameName() {
        return this.gameName;
    }

    @NotNull
    public final InetAddress getGameServerIP() {
        return this.gameServerIP;
    }

    public final int getGameServerPort() {
        return this.gameServerPort;
    }

    public final int getQueryPort() {
        return this.queryPort;
    }

    @NotNull
    public final SteamID getSourceSteamID() {
        return this.sourceSteamID;
    }

    @NotNull
    public final byte[] getGameDataBlob() {
        return this.gameDataBlob;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final byte[] getAvatarHash() {
        return this.avatarHash;
    }

    @NotNull
    public final Date getLastLogOff() {
        return this.lastLogOff;
    }

    @NotNull
    public final Date getLastLogOn() {
        return this.lastLogOn;
    }

    public final int getClanRank() {
        return this.clanRank;
    }

    @NotNull
    public final String getClanTag() {
        return this.clanTag;
    }

    public final int getOnlineSessionInstances() {
        return this.onlineSessionInstances;
    }
}

