/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steammatchmaking;

import in.dragonbra.javasteam.enums.ELobbyType;
import in.dragonbra.javasteam.steam.handlers.steammatchmaking.Lobby;
import in.dragonbra.javasteam.steam.handlers.steammatchmaking.Member;
import in.dragonbra.javasteam.types.SteamID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0007J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bJ(\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014J(\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014J \u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\fJ \u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0007J\u0016\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0007J\u001e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fJ\u001e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007J$\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u001bJ\u0006\u0010\u001c\u001a\u00020\u000eJ2\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u001bH\u0002J\u001c\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0007H\u0002R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lin/dragonbra/javasteam/steam/handlers/steammatchmaking/LobbyCache;", "", "<init>", "()V", "lobbies", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lin/dragonbra/javasteam/types/SteamID;", "Lin/dragonbra/javasteam/steam/handlers/steammatchmaking/Lobby;", "getLobby", "appId", "lobbySteamId", "", "cacheLobby", "", "lobby", "addLobbyMember", "Lin/dragonbra/javasteam/steam/handlers/steammatchmaking/Member;", "memberId", "personaName", "", "removeLobbyMember", "clearLobbyMembers", "updateLobbyOwner", "ownerSteamId", "updateLobbyMembers", "members", "", "clear", "owner", "getAppLobbies", "deleteLobby", "javasteam"})
@SourceDebugExtension(value={"SMAP\nLobbyCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LobbyCache.kt\nin/dragonbra/javasteam/steam/handlers/steammatchmaking/LobbyCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n295#2,2:126\n295#2,2:128\n774#2:130\n865#2,2:131\n*S KotlinDebug\n*F\n+ 1 LobbyCache.kt\nin/dragonbra/javasteam/steam/handlers/steammatchmaking/LobbyCache\n*L\n28#1:126,2\n49#1:128,2\n55#1:130\n55#1:131,2\n*E\n"})
public final class LobbyCache {
    @NotNull
    private final ConcurrentHashMap<Integer, ConcurrentHashMap<SteamID, Lobby>> lobbies = new ConcurrentHashMap();

    @Nullable
    public final Lobby getLobby(int appId, long lobbySteamId) {
        return this.getLobby(appId, new SteamID(lobbySteamId));
    }

    @Nullable
    public final Lobby getLobby(int appId, @NotNull SteamID lobbySteamId) {
        Intrinsics.checkNotNullParameter((Object)lobbySteamId, (String)"lobbySteamId");
        return this.getAppLobbies(appId).get(lobbySteamId);
    }

    public final void cacheLobby(int appId, @NotNull Lobby lobby) {
        Intrinsics.checkNotNullParameter((Object)lobby, (String)"lobby");
        ((Map)this.getAppLobbies(appId)).put(lobby.getSteamID(), lobby);
    }

    @Nullable
    public final Member addLobbyMember(int appId, @NotNull Lobby lobby, long memberId, @NotNull String personaName) {
        Intrinsics.checkNotNullParameter((Object)lobby, (String)"lobby");
        Intrinsics.checkNotNullParameter((Object)personaName, (String)"personaName");
        return this.addLobbyMember(appId, lobby, new SteamID(memberId), personaName);
    }

    @Nullable
    public final Member addLobbyMember(int appId, @NotNull Lobby lobby, @NotNull SteamID memberId, @NotNull String personaName) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)lobby, (String)"lobby");
            Intrinsics.checkNotNullParameter((Object)memberId, (String)"memberId");
            Intrinsics.checkNotNullParameter((Object)personaName, (String)"personaName");
            Iterable $this$firstOrNull$iv = lobby.getMembers();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Member it = (Member)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSteamID(), (Object)memberId)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Member existingMember = v0;
        if (existingMember != null) {
            return null;
        }
        Member addedMember = new Member(memberId, personaName, null, 4, null);
        ArrayList<Member> members = new ArrayList<Member>(lobby.getMembers().size() + 1);
        members.addAll((Collection)lobby.getMembers());
        members.add(addedMember);
        this.updateLobbyMembers(appId, lobby, (List<Member>)members);
        return addedMember;
    }

    @Nullable
    public final Member removeLobbyMember(int appId, @NotNull Lobby lobby, long memberId) {
        Intrinsics.checkNotNullParameter((Object)lobby, (String)"lobby");
        return this.removeLobbyMember(appId, lobby, new SteamID(memberId));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Member removeLobbyMember(int appId, @NotNull Lobby lobby, @NotNull SteamID memberId) {
        void $this$filterTo$iv$iv;
        Object v0;
        Object element$iv2;
        block5: {
            Intrinsics.checkNotNullParameter((Object)lobby, (String)"lobby");
            Intrinsics.checkNotNullParameter((Object)memberId, (String)"memberId");
            Iterable $this$firstOrNull$iv = lobby.getMembers();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                Member it = (Member)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSteamID(), (Object)memberId)) continue;
                v0 = element$iv2;
                break block5;
            }
            v0 = null;
        }
        Member removedMember = v0;
        if (removedMember == null) {
            return null;
        }
        Iterable $this$filter$iv = lobby.getMembers();
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Member it = (Member)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)removedMember))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List members = (List)destination$iv$iv;
        if (!((Collection)members).isEmpty()) {
            this.updateLobbyMembers(appId, lobby, members);
        } else {
            this.deleteLobby(appId, lobby.getSteamID());
        }
        return removedMember;
    }

    public final void clearLobbyMembers(int appId, long lobbySteamId) {
        this.clearLobbyMembers(appId, new SteamID(lobbySteamId));
    }

    public final void clearLobbyMembers(int appId, @NotNull SteamID lobbySteamId) {
        Intrinsics.checkNotNullParameter((Object)lobbySteamId, (String)"lobbySteamId");
        Lobby lobby = this.getLobby(appId, lobbySteamId);
        if (lobby != null) {
            this.updateLobbyMembers(appId, lobby, null, null);
        }
    }

    public final void updateLobbyOwner(int appId, long lobbySteamId, long ownerSteamId) {
        this.updateLobbyOwner(appId, new SteamID(lobbySteamId), new SteamID(ownerSteamId));
    }

    public final void updateLobbyOwner(int appId, @NotNull SteamID lobbySteamId, @NotNull SteamID ownerSteamId) {
        Intrinsics.checkNotNullParameter((Object)lobbySteamId, (String)"lobbySteamId");
        Intrinsics.checkNotNullParameter((Object)ownerSteamId, (String)"ownerSteamId");
        Lobby lobby = this.getLobby(appId, lobbySteamId);
        if (lobby != null) {
            this.updateLobbyMembers(appId, lobby, ownerSteamId, lobby.getMembers());
        }
    }

    public final void updateLobbyMembers(int appId, @NotNull Lobby lobby, @NotNull List<Member> members) {
        Intrinsics.checkNotNullParameter((Object)lobby, (String)"lobby");
        Intrinsics.checkNotNullParameter(members, (String)"members");
        this.updateLobbyMembers(appId, lobby, lobby.getOwnerSteamID(), members);
    }

    public final void clear() {
        this.lobbies.clear();
    }

    private final void updateLobbyMembers(int appId, Lobby lobby, SteamID owner, List<Member> members) {
        SteamID steamID = lobby.getSteamID();
        ELobbyType eLobbyType = lobby.getLobbyType();
        int n = lobby.getLobbyFlags();
        Map<String, String> map = lobby.getMetadata();
        int n2 = lobby.getMaxMembers();
        int n3 = lobby.getNumMembers();
        List list = members;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        this.cacheLobby(appId, new Lobby(steamID, eLobbyType, n, owner, map, n2, n3, list, lobby.getDistance(), lobby.getWeight()));
    }

    private final ConcurrentHashMap<SteamID, Lobby> getAppLobbies(int appId) {
        ConcurrentHashMap concurrentHashMap = this.lobbies.computeIfAbsent(appId, arg_0 -> LobbyCache.getAppLobbies$lambda$4(LobbyCache::getAppLobbies$lambda$3, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentHashMap, (String)"computeIfAbsent(...)");
        return concurrentHashMap;
    }

    private final Lobby deleteLobby(int appId, SteamID lobbySteamId) {
        ConcurrentHashMap<SteamID, Lobby> concurrentHashMap = this.lobbies.get(appId);
        if (concurrentHashMap == null) {
            return null;
        }
        ConcurrentHashMap<SteamID, Lobby> appLobbies = concurrentHashMap;
        return appLobbies.remove(lobbySteamId);
    }

    private static final ConcurrentHashMap getAppLobbies$lambda$3(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ConcurrentHashMap();
    }

    private static final ConcurrentHashMap getAppLobbies$lambda$4(Function1 $tmp0, Object p0) {
        return (ConcurrentHashMap)$tmp0.invoke(p0);
    }
}

