/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamuser;

import com.google.protobuf.ByteString;
import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EAccountType;
import in.dragonbra.javasteam.enums.EGamingDeviceType;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.enums.EUIMode;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesBase;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver2;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverLogin;
import in.dragonbra.javasteam.steam.handlers.ClientMsgHandler;
import in.dragonbra.javasteam.steam.handlers.steamuser.AnonymousLogOnDetails;
import in.dragonbra.javasteam.steam.handlers.steamuser.ChatMode;
import in.dragonbra.javasteam.steam.handlers.steamuser.LogOnDetails;
import in.dragonbra.javasteam.steam.handlers.steamuser.callback.AccountInfoCallback;
import in.dragonbra.javasteam.steam.handlers.steamuser.callback.EmailAddrInfoCallback;
import in.dragonbra.javasteam.steam.handlers.steamuser.callback.LoggedOffCallback;
import in.dragonbra.javasteam.steam.handlers.steamuser.callback.LoggedOnCallback;
import in.dragonbra.javasteam.steam.handlers.steamuser.callback.MarketingMessageCallback;
import in.dragonbra.javasteam.steam.handlers.steamuser.callback.PlayingSessionStateCallback;
import in.dragonbra.javasteam.steam.handlers.steamuser.callback.SessionTokenCallback;
import in.dragonbra.javasteam.steam.handlers.steamuser.callback.VanityURLChangedCallback;
import in.dragonbra.javasteam.steam.handlers.steamuser.callback.WalletInfoCallback;
import in.dragonbra.javasteam.steam.handlers.steamuser.callback.WebAPIUserNonceCallback;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.SteamID;
import in.dragonbra.javasteam.util.HardwareUtils;
import in.dragonbra.javasteam.util.NetHelpers;
import java.net.InetAddress;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\u0010H\u0007J\u0006\u0010\u0011\u001a\u00020\tJ\u0010\u0010\u0012\u001a\u00020\t2\b\b\u0002\u0010\u0013\u001a\u00020\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamuser/SteamUser;", "Lin/dragonbra/javasteam/steam/handlers/ClientMsgHandler;", "<init>", "()V", "steamID", "Lin/dragonbra/javasteam/types/SteamID;", "getSteamID", "()Lin/dragonbra/javasteam/types/SteamID;", "handleMsg", "", "packetMsg", "Lin/dragonbra/javasteam/base/IPacketMsg;", "logOn", "details", "Lin/dragonbra/javasteam/steam/handlers/steamuser/LogOnDetails;", "logOnAnonymous", "Lin/dragonbra/javasteam/steam/handlers/steamuser/AnonymousLogOnDetails;", "logOff", "kickPlayingSession", "onlyStopGame", "", "Companion", "javasteam"})
public final class SteamUser
extends ClientMsgHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final SteamID getSteamID() {
        return this.getClient().getSteamID();
    }

    @Override
    public void handleMsg(@NotNull IPacketMsg packetMsg) {
        Intrinsics.checkNotNullParameter((Object)packetMsg, (String)"packetMsg");
        CallbackMsg callbackMsg = SteamUser.Companion.getCallback(packetMsg);
        if (callbackMsg == null) {
            return;
        }
        CallbackMsg callback = callbackMsg;
        this.getClient().postCallback(callback);
    }

    /*
     * WARNING - void declaration
     */
    public final void logOn(@NotNull LogOnDetails details) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        if (((CharSequence)details.getUsername()).length() == 0 || ((charSequence = (CharSequence)details.getPassword()) == null || charSequence.length() == 0) && ((charSequence = (CharSequence)details.getAccessToken()) == null || charSequence.length() == 0)) {
            throw new IllegalArgumentException("LogOn requires a username and password or access token to be set in 'details'.");
        }
        if (!this.getClient().isConnected()) {
            this.getClient().postCallback(new LoggedOnCallback(EResult.NoConnection));
            return;
        }
        ClientMsgProtobuf logon = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientLogon.class, EMsg.ClientLogon);
        SteamID steamID = new SteamID(details.getAccountID(), details.getAccountInstance(), this.getClient().getUniverse(), EAccountType.Individual);
        if (details.getLoginID() != null) {
            void $this$logOn_u24lambda_u240;
            SteammessagesBase.CMsgIPAddress.Builder builder;
            SteammessagesBase.CMsgIPAddress.Builder builder2 = builder = SteammessagesBase.CMsgIPAddress.newBuilder();
            SteammessagesClientserverLogin.CMsgClientLogon.Builder builder3 = (SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody();
            boolean bl = false;
            Integer n = details.getLoginID();
            Intrinsics.checkNotNull((Object)n);
            $this$logOn_u24lambda_u240.setV4(n);
            builder3.setObfuscatedPrivateIp(builder.build());
        } else {
            InetAddress inetAddress = this.getClient().getLocalIP();
            if (inetAddress != null) {
                InetAddress localIP = inetAddress;
                boolean bl = false;
                SteammessagesBase.CMsgIPAddress msgIpAddr = NetHelpers.getMsgIPAddress(localIP);
                ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setObfuscatedPrivateIp(NetHelpers.obfuscatePrivateIP(msgIpAddr));
            }
        }
        if (((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).getObfuscatedPrivateIp().hasV4()) {
            ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setDeprecatedObfustucatedPrivateIp(((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).getObfuscatedPrivateIp().getV4());
        }
        logon.getProtoHeader().setClientSessionid(0);
        logon.getProtoHeader().setSteamid(steamID.convertToUInt64());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setAccountName(details.getUsername());
        if (details.getPassword() != null) {
            ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setPassword(details.getPassword());
        }
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setShouldRememberPassword(details.getShouldRememberPassword());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setProtocolVersion(65581);
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setClientOsType(details.getClientOSType().code());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setClientLanguage(details.getClientLanguage());
        Integer n = details.getCellID();
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setCellId(n != null ? n.intValue() : this.getClient().getConfiguration().getCellID());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setSteam2TicketRequest(details.getRequestSteam2Ticket());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setClientPackageVersion(1771);
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setSupportsRateLimitResponse(true);
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setMachineName(details.getMachineName());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setMachineId(ByteString.copyFrom((byte[])HardwareUtils.getMachineID()));
        if (details.getChatMode() != ChatMode.DEFAULT) {
            ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setChatMode(details.getChatMode().getMode());
        }
        if (details.getUiMode() != EUIMode.Unknown) {
            ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setUiMode(details.getUiMode().code());
        }
        if (details.getGamingDeviceType() != EGamingDeviceType.Unknown) {
            ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setGamingDeviceType(details.getGamingDeviceType().code());
        }
        if (details.isSteamDeck()) {
            ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setIsSteamDeckDeprecated(true);
        }
        if (details.getAuthCode() != null) {
            ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setAuthCode(details.getAuthCode());
        }
        if (details.getTwoFactorCode() != null) {
            ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setTwoFactorCode(details.getTwoFactorCode());
        }
        if (details.getAccessToken() != null) {
            ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setAccessToken(details.getAccessToken());
        }
        this.getClient().send(logon);
    }

    @JvmOverloads
    public final void logOnAnonymous(@NotNull AnonymousLogOnDetails details) {
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        if (!this.getClient().isConnected()) {
            this.getClient().postCallback(new LoggedOnCallback(EResult.NoConnection));
            return;
        }
        ClientMsgProtobuf logon = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientLogon.class, EMsg.ClientLogon);
        SteamID auId = new SteamID(0L, 0L, this.getClient().getUniverse(), EAccountType.AnonUser);
        logon.getProtoHeader().setClientSessionid(0);
        logon.getProtoHeader().setSteamid(auId.convertToUInt64());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setProtocolVersion(65581);
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setClientOsType(details.getClientOSType().code());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setClientLanguage(details.getClientLanguage());
        Integer n = details.getCellID();
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setCellId(n != null ? n.intValue() : this.getClient().getConfiguration().getCellID());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setMachineId(ByteString.copyFrom((byte[])HardwareUtils.getMachineID()));
        this.getClient().send(logon);
    }

    public static /* synthetic */ void logOnAnonymous$default(SteamUser steamUser, AnonymousLogOnDetails anonymousLogOnDetails, int n, Object object) {
        if ((n & 1) != 0) {
            anonymousLogOnDetails = new AnonymousLogOnDetails(null, null, null, 7, null);
        }
        steamUser.logOnAnonymous(anonymousLogOnDetails);
    }

    public final void logOff() {
        this.setExpectDisconnection(true);
        ClientMsgProtobuf logOff = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientLogOff.class, EMsg.ClientLogOff);
        this.getClient().send(logOff);
        this.getClient().disconnect();
    }

    public final void kickPlayingSession(boolean onlyStopGame) {
        ClientMsgProtobuf clientMsgProtobuf;
        ClientMsgProtobuf $this$kickPlayingSession_u24lambda_u242 = clientMsgProtobuf = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientKickPlayingSession.class, EMsg.ClientKickPlayingSession);
        boolean bl = false;
        ((SteammessagesClientserver2.CMsgClientKickPlayingSession.Builder)$this$kickPlayingSession_u24lambda_u242.getBody()).setOnlyStopGame(onlyStopGame);
        ClientMsgProtobuf request = clientMsgProtobuf;
        this.getClient().send(request);
    }

    public static /* synthetic */ void kickPlayingSession$default(SteamUser steamUser, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        steamUser.kickPlayingSession(bl);
    }

    @JvmOverloads
    public final void logOnAnonymous() {
        SteamUser.logOnAnonymous$default(this, null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamuser/SteamUser$Companion;", "", "<init>", "()V", "getCallback", "Lin/dragonbra/javasteam/steam/steamclient/callbackmgr/CallbackMsg;", "packetMsg", "Lin/dragonbra/javasteam/base/IPacketMsg;", "javasteam"})
    public static final class Companion {
        private Companion() {
        }

        private final CallbackMsg getCallback(IPacketMsg packetMsg) {
            CallbackMsg callbackMsg;
            EMsg eMsg = packetMsg.getMsgType();
            switch (eMsg == null ? -1 : WhenMappings.$EnumSwitchMapping$0[eMsg.ordinal()]) {
                case 1: {
                    callbackMsg = new LoggedOnCallback(packetMsg);
                    break;
                }
                case 2: {
                    callbackMsg = new LoggedOffCallback(packetMsg);
                    break;
                }
                case 3: {
                    callbackMsg = new SessionTokenCallback(packetMsg);
                    break;
                }
                case 4: {
                    callbackMsg = new AccountInfoCallback(packetMsg);
                    break;
                }
                case 5: {
                    callbackMsg = new EmailAddrInfoCallback(packetMsg);
                    break;
                }
                case 6: {
                    callbackMsg = new WalletInfoCallback(packetMsg);
                    break;
                }
                case 7: {
                    callbackMsg = new WebAPIUserNonceCallback(packetMsg);
                    break;
                }
                case 8: {
                    callbackMsg = new VanityURLChangedCallback(packetMsg);
                    break;
                }
                case 9: {
                    callbackMsg = new MarketingMessageCallback(packetMsg);
                    break;
                }
                case 10: {
                    callbackMsg = new PlayingSessionStateCallback(packetMsg);
                    break;
                }
                default: {
                    callbackMsg = null;
                }
            }
            return callbackMsg;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[EMsg.values().length];
                try {
                    nArray[EMsg.ClientLogOnResponse.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EMsg.ClientLoggedOff.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EMsg.ClientSessionToken.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EMsg.ClientAccountInfo.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EMsg.ClientEmailAddrInfo.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EMsg.ClientWalletInfoUpdate.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EMsg.ClientRequestWebAPIAuthenticateUserNonceResponse.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EMsg.ClientVanityURLChangedNotification.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EMsg.ClientMarketingMessageUpdate2.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EMsg.ClientPlayingSessionState.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

