/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamuser.callback;

import in.dragonbra.javasteam.base.ClientMsg;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EMarketingMessageFlags;
import in.dragonbra.javasteam.generated.MsgClientMarketingMessageUpdate2;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.GlobalID;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import in.dragonbra.javasteam.util.stream.BinaryReader;
import in.dragonbra.javasteam.util.stream.MemoryStream;
import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00102\u00020\u0001:\u0002\u000f\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamuser/callback/MarketingMessageCallback;", "Lin/dragonbra/javasteam/steam/steamclient/callbackmgr/CallbackMsg;", "packetMsg", "Lin/dragonbra/javasteam/base/IPacketMsg;", "<init>", "(Lin/dragonbra/javasteam/base/IPacketMsg;)V", "updateTime", "Ljava/util/Date;", "getUpdateTime", "()Ljava/util/Date;", "messages", "", "Lin/dragonbra/javasteam/steam/handlers/steamuser/callback/MarketingMessageCallback$Message;", "getMessages", "()Ljava/util/List;", "Message", "Companion", "javasteam"})
public final class MarketingMessageCallback
extends CallbackMsg {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Date updateTime;
    @NotNull
    private final List<Message> messages;
    @NotNull
    private static final Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarketingMessageCallback(@NotNull IPacketMsg packetMsg) {
        Intrinsics.checkNotNullParameter((Object)packetMsg, (String)"packetMsg");
        ClientMsg<MsgClientMarketingMessageUpdate2> marketingMessage = new ClientMsg<MsgClientMarketingMessageUpdate2>(MsgClientMarketingMessageUpdate2.class, packetMsg);
        MsgClientMarketingMessageUpdate2 body = marketingMessage.getBody();
        this.updateTime = new Date((long)body.getMarketingMessageUpdateTime() * 1000L);
        List msgList = new ArrayList();
        try {
            Closeable closeable = new BinaryReader(marketingMessage.getPayload());
            Throwable throwable = null;
            try {
                BinaryReader br = (BinaryReader)closeable;
                boolean bl = false;
                int n = body.getCount();
                for (int i2 = 0; i2 < n; ++i2) {
                    int dataLen = br.readInt() - 4;
                    byte[] messageData = br.readBytes(dataLen);
                    msgList.add(new Message(messageData));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            logger.error("Failed to get marketing messages", e);
        }
        this.messages = CollectionsKt.toList((Iterable)msgList);
    }

    @NotNull
    public final Date getUpdateTime() {
        return this.updateTime;
    }

    @NotNull
    public final List<Message> getMessages() {
        return this.messages;
    }

    static {
        Logger logger = LogManager.getLogger(MarketingMessageCallback.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        MarketingMessageCallback.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamuser/callback/MarketingMessageCallback$Companion;", "", "<init>", "()V", "logger", "Lin/dragonbra/javasteam/util/log/Logger;", "javasteam"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0013\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\"\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\"\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR.\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamuser/callback/MarketingMessageCallback$Message;", "", "data", "", "<init>", "([B)V", "value", "Lin/dragonbra/javasteam/types/GlobalID;", "id", "getId", "()Lin/dragonbra/javasteam/types/GlobalID;", "", "url", "getUrl", "()Ljava/lang/String;", "Ljava/util/EnumSet;", "Lin/dragonbra/javasteam/enums/EMarketingMessageFlags;", "flags", "getFlags", "()Ljava/util/EnumSet;", "javasteam"})
    public static final class Message {
        @Nullable
        private GlobalID id;
        @Nullable
        private String url;
        @Nullable
        private EnumSet<EMarketingMessageFlags> flags;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message(@Nullable byte[] data) {
            try {
                MemoryStream ms = new MemoryStream(data);
                Closeable closeable = new BinaryReader(ms);
                Throwable throwable = null;
                try {
                    BinaryReader br = (BinaryReader)closeable;
                    boolean bl = false;
                    this.id = new GlobalID(br.readLong());
                    this.url = br.readNullTermString(StandardCharsets.UTF_8);
                    this.flags = EMarketingMessageFlags.from(br.readInt());
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                logger.error("Failed to parse marketing messages", e);
            }
        }

        @Nullable
        public final GlobalID getId() {
            return this.id;
        }

        @Nullable
        public final String getUrl() {
            return this.url;
        }

        @Nullable
        public final EnumSet<EMarketingMessageFlags> getFlags() {
            return this.flags;
        }
    }
}

